/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.server;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.smarts.core.api.Handlers;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.exceptions.ServiceException;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.rest.server.RestRequestLoggingHelper;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public interface RestHandlers
extends Handlers {
    default public Response handleRest(Request request, UriInfo uriInfo, HttpHeaders httpHeaders, RequestContext rc, Function<RequestContext, Response> func) {
        Consumer<RequestContext> cleanUp = null;
        return this.handleRest(request, uriInfo, httpHeaders, rc, func, cleanUp);
    }

    default public Response handleRest(Request request, UriInfo uriInfo, HttpHeaders httpHeaders, RequestContext rc, Function<RequestContext, Response> handler, Consumer<RequestContext> cleanUp) {
        RestRequestLoggingHelper lh = new RestRequestLoggingHelper(request, uriInfo, httpHeaders, rc);
        lh.logEntry();
        try {
            Response ret = (Response)this.handle(rc, handler, cleanUp);
            lh.logExit(ret);
            return ret;
        }
        catch (Throwable th) {
            lh.logExit(th);
            Response ret = this.handleException(th);
            return ret;
        }
    }

    default public Response GETjson(Object obj) {
        return this.createResponse(Response.Status.OK, obj);
    }

    default public Response POSTjson(Object obj) {
        return this.createResponse(Response.Status.CREATED, obj);
    }

    default public Response PUTjson(Object obj) {
        return this.createResponse(Response.Status.OK, obj);
    }

    default public Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    default public Response badRequest() {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    default public Response forbidden() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Deprecated
    default public Response okRespJson(Response.Status status, Object obj) {
        return this.createResponse(status, obj);
    }

    default public Response createResponse(Response.Status status, Object obj) {
        String json = obj == null ? "{}" : (obj instanceof String ? (String)obj : JsonParserHelper.toJson((Object)obj));
        return this.getResponse(status, json);
    }

    default public Response getResponse(Response.Status statusCode, String entity) {
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)statusCode);
        String res = entity;
        return responseBuilder.entity((Object)res).type("application/json").build();
    }

    default public Response handleException(Throwable th) {
        return this.handleException(null, th);
    }

    default public Response handleException(RequestContext rc, Throwable th) {
        JaxRs20Exceptions.ResponseProcessingException cause;
        Object srvex = th.getCause() instanceof JaxRs20Exceptions.ResponseProcessingException ? ((cause = (JaxRs20Exceptions.ResponseProcessingException)th.getCause()) != null && cause.getResponse() != null ? new InternalException((Throwable)cause, cause.getResponse().getStatus(), cause.getMessage(), new Object[0]) : new InternalException(th, th.getMessage(), new Object[0])) : (th instanceof ServiceException ? (ServiceException)th : new InternalException(th, th.getMessage(), new Object[0]));
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ObjectNode error = root.putObject("error");
        error.put("status", srvex.httpStatus);
        error.put("error_code", srvex.msg.name);
        String message = srvex.getMessage();
        if (srvex instanceof InternalException && srvex.getCause() != null) {
            LOGGER.error(message, srvex.getCause());
        }
        error.put("message", message);
        Response.ResponseBuilder responseBuilder = Response.status((int)srvex.httpStatus);
        Response ret = responseBuilder.entity((Object)root.toString()).type("application/json").build();
        return ret;
    }
}

