/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import simplenlg.aggregation.FunctionalSet;
import simplenlg.aggregation.Periphery;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.PhraseCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationHelper {
    public static List<DiscourseFunction> FUNCTIONS = Arrays.asList(DiscourseFunction.SUBJECT, DiscourseFunction.HEAD, DiscourseFunction.COMPLEMENT, DiscourseFunction.PRE_MODIFIER, DiscourseFunction.POST_MODIFIER, DiscourseFunction.VERB_PHRASE);
    public static List<DiscourseFunction> RECURSIVE = Arrays.asList(DiscourseFunction.VERB_PHRASE);

    public static List<FunctionalSet> collectFunctionalPairs(NLGElement phrase1, NLGElement phrase2) {
        List<NLGElement> children1 = AggregationHelper.getAllChildren(phrase1);
        List<NLGElement> children2 = AggregationHelper.getAllChildren(phrase2);
        ArrayList<FunctionalSet> pairs = new ArrayList<FunctionalSet>();
        if (children1.size() == children2.size()) {
            Periphery periph = Periphery.LEFT;
            for (int i = 0; i < children1.size(); ++i) {
                NLGElement child1 = children1.get(i);
                NLGElement child2 = children2.get(i);
                ElementCategory cat1 = child1.getCategory();
                ElementCategory cat2 = child2.getCategory();
                DiscourseFunction func1 = (DiscourseFunction)((Object)child1.getFeature("discourse_function"));
                DiscourseFunction func2 = (DiscourseFunction)((Object)child2.getFeature("discourse_function"));
                if (cat1 == cat2 && func1 == func2) {
                    pairs.add(FunctionalSet.newInstance(func1, cat1, periph, child1, child2));
                    if (cat1 != LexicalCategory.VERB) continue;
                    periph = Periphery.RIGHT;
                    continue;
                }
                pairs.clear();
                break;
            }
        }
        return pairs;
    }

    private static List<NLGElement> getAllChildren(NLGElement element) {
        ArrayList<NLGElement> children = new ArrayList<NLGElement>();
        List<NLGElement> components = element instanceof ListElement ? element.getFeatureAsElementList("components") : element.getChildren();
        for (NLGElement child : components) {
            children.add(child);
            if (child.getCategory() != PhraseCategory.VERB_PHRASE && child.getFeature("discourse_function") != DiscourseFunction.VERB_PHRASE) continue;
            children.addAll(AggregationHelper.getAllChildren(child));
        }
        return children;
    }
}

