/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.i18n;

public class PseudoTranslator {
    public final Config config;

    public PseudoTranslator(Config config) {
        this.config = config;
    }

    public String translate(String in) {
        if (in == null) {
            return in;
        }
        StringBuilder sb = new StringBuilder();
        if (this.config.addDelimiters) {
            sb.append(this.config.frontDelimiter);
        }
        sb.append(in);
        if (this.config.addDelimiters) {
            sb.append(this.config.endDelimiter);
        }
        String ret = sb.toString();
        return ret;
    }

    public static class Config {
        public final boolean addDelimiters;
        public final String frontDelimiter;
        public final String endDelimiter;

        public Config(boolean addDelimiters) {
            this.addDelimiters = addDelimiters;
            this.frontDelimiter = "<<";
            this.endDelimiter = ">>";
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[PseudoTranslator.Config");
            sb.append(" delimiters=" + this.addDelimiters);
            if (this.addDelimiters) {
                sb.append(" " + this.frontDelimiter + "..." + this.endDelimiter);
            }
            sb.append("]");
            String ret = sb.toString();
            return ret;
        }
    }
}

