/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import com.ibm.smarts.core.exceptions.InternalException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class ResourceLoader<T> {
    private CompletableFuture<T> future = null;
    private final AtomicBoolean isLoadStarted = new AtomicBoolean(false);
    private final CountDownLatch futureIsPresent = new CountDownLatch(1);
    private final AtomicBoolean isResourceAvailable = new AtomicBoolean(false);
    private final Supplier<T> supplier;

    public ResourceLoader(Supplier<T> supplier) {
        this(false, supplier);
    }

    public ResourceLoader(boolean loadOnDemand, Supplier<T> supplier) {
        this.supplier = supplier;
        if (!loadOnDemand) {
            this.getAsync();
        }
    }

    public boolean isLoadStarted() {
        return this.futureIsPresent.getCount() == 0L;
    }

    public boolean isResourceAvailable() {
        return this.isResourceAvailable.get();
    }

    public T get() {
        CompletableFuture<T> f = this.getAsync();
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ResourceLoadException((Throwable)e, "Resource load interrupted", new Object[0]);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new ResourceLoadException(cause, "Resource load threw exception", new Object[0]);
        }
    }

    public CompletableFuture<T> getAsync() {
        if (this.isLoadStarted.compareAndSet(false, true)) {
            this.future = CompletableFuture.supplyAsync(() -> {
                T r = this.supplier.get();
                return r;
            });
            this.future.thenRun(() -> this.isResourceAvailable.set(true));
            this.futureIsPresent.countDown();
        }
        try {
            this.futureIsPresent.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ResourceLoadException((Throwable)e, "Wait for resource load interrupted", new Object[0]);
        }
        return this.future;
    }

    public static class ResourceLoadException
    extends InternalException {
        private static final long serialVersionUID = 2380190873765220952L;

        public ResourceLoadException(Throwable cause, String message, Object ... params) {
            super(cause, message, params);
        }
    }
}

