/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class ToString {
    private final StringBuilder sb = new StringBuilder();

    public ToString(Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.endsWith("]")) {
                s = s.substring(0, s.length() - 1);
            }
            if (!s.startsWith("[")) {
                s = "[" + s;
            }
            this.sb.append(s);
        } else {
            this.sb.append("[" + obj.getClass().getSimpleName() + " @" + Integer.toHexString(obj.hashCode()));
        }
    }

    public String get() {
        this.sb.append("]");
        return this.sb.toString();
    }

    public static ToString with(Object obj) {
        return new ToString(obj);
    }

    public ToString fields(Object ... info) {
        for (int i = 0; i < info.length; ++i) {
            Object nameObj = info[i];
            Object valueObj = info[i + 1];
            if (!(nameObj instanceof String)) {
                this.sb.append("[Object at index " + i + " is not a String. It is a ");
                this.value(nameObj);
                this.sb.append(" Object at index " + (i + 1) + " is ");
                this.value(valueObj);
                this.sb.append("]");
            } else {
                String name = (String)nameObj;
                this.field(name, valueObj);
            }
            ++i;
        }
        return this;
    }

    public ToString field(String name, Object value) {
        this.sb.append(" " + name + "=");
        ToString.valueString(this.sb, value);
        return this;
    }

    private void value(Object value) {
        String s = ToString.valueString(value);
        this.sb.append(s);
    }

    public static String valueString(Object value) {
        StringBuilder sb = new StringBuilder();
        return ToString.valueString(sb, value);
    }

    private static String valueString(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            sb.append("" + b);
        } else if (value instanceof Integer) {
            Integer num = (Integer)value;
            sb.append("" + num);
        } else if (value instanceof Long) {
            Long num = (Long)value;
            sb.append("" + num);
        } else if (value instanceof Double) {
            Double num = (Double)value;
            sb.append("" + num);
        } else if (value instanceof String) {
            sb.append("'" + value + "'");
        } else if (value instanceof UUID) {
            sb.append(value.toString());
        } else if (value instanceof Locale) {
            sb.append(value.toString());
        } else if (value instanceof Object[]) {
            Object[] a = (Object[])value;
            List<Object> l = Arrays.asList(a);
            ToString.valueString(sb, l);
        } else if (value instanceof int[]) {
            int[] a = (int[])value;
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (int i : a) {
                l.add(i);
            }
            ToString.valueString(sb, l);
        } else if (value instanceof long[]) {
            long[] a = (long[])value;
            ArrayList<Long> l = new ArrayList<Long>();
            for (long i : a) {
                l.add(i);
            }
            ToString.valueString(sb, l);
        } else if (value instanceof double[]) {
            double[] a = (double[])value;
            ArrayList<Double> l = new ArrayList<Double>();
            for (double i : a) {
                l.add(i);
            }
            ToString.valueString(sb, l);
        } else if (value instanceof List) {
            List l = (List)value;
            sb.append("[");
            for (int idx = 0; idx < l.size(); ++idx) {
                if (idx > 0) {
                    sb.append(", ");
                }
                Object item = l.get(idx);
                ToString.valueString(sb, item);
            }
            sb.append("]");
        } else if (value instanceof Map) {
            Map m = (Map)value;
            sb.append("{");
            for (Map.Entry e : m.entrySet()) {
                sb.append("[");
                ToString.valueString(sb, e.getKey());
                sb.append("=>");
                Object v = e.getValue();
                ToString.valueString(sb, v);
                sb.append("]");
            }
            sb.append("}");
        } else if (value instanceof Date) {
            sb.append("[");
            sb.append(value);
            sb.append("]");
        } else {
            String valueString = value.toString();
            ToString.writeBrackets(sb, valueString);
        }
        return sb.toString();
    }

    private static void writeBrackets(StringBuilder sb, String s) {
        if (!s.startsWith("[")) {
            sb.append("[");
        }
        sb.append(s);
        if (!s.endsWith("]")) {
            sb.append("]");
        }
    }
}

