/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.uima;

import com.ibm.dltj.Dictionary;
import com.ibm.dltj.MisspeltWord;
import com.ibm.dltj.SpellCheckerSession;
import com.ibm.dltj.nondeterm.AdvancedLookupDriver;
import edu.stanford.nlp.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class LWSpellAid {
    static final String LANGUAGE = "language";
    static final String DICTIONARY = "dictionary";
    static final String ENGLISH_DICTIONARY = "dictionary/0/en-XX-LLex-7030.dic";
    static final String SPANISH_DICTIONARY = "dictionary/10/es-ES-LLex-7006.dic";
    static final String ENGLISH = "en";
    static final String SPANISH = "es";
    static final String CHECK_ONLY_ASCII = "checkOnlyAscii";
    protected Dictionary[] mSpellCheckDictionaries = null;
    protected SpellCheckerSession mSpellCheckSession = null;
    protected AdvancedLookupDriver mAdvancedLookupDriver = null;
    protected boolean mIsAvailable = false;
    protected static final int MAX_SUGGESTION = 3;

    public List<Pair<String, List<String>>> spellingCheck(String toCheck) {
        if (!this.isAvailable()) {
            return null;
        }
        try {
            ArrayList<Pair<String, List<String>>> results = null;
            List list = this.mSpellCheckSession.checkSpelling(toCheck);
            if (list == null || list.isEmpty()) {
                return results;
            }
            results = new ArrayList<Pair<String, List<String>>>(list.size());
            for (MisspeltWord w : list) {
                String spellError = toCheck.substring(w.start, w.end);
                Pair pair = new Pair();
                pair.setFirst((Object)spellError);
                String[] suggested = this.mAdvancedLookupDriver.match(spellError, 2, 3);
                if (suggested != null && suggested.length > 0) {
                    List<String> suggestedList = Arrays.asList(suggested);
                    pair.setSecond(suggestedList);
                } else {
                    pair.setSecond(new ArrayList(0));
                }
                results.add((Pair<String, List<String>>)pair);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void dispose() {
        this.mSpellCheckSession.close();
        this.mSpellCheckSession.dispose();
        this.mSpellCheckDictionaries = null;
        this.mAdvancedLookupDriver = null;
        this.mSpellCheckSession = null;
        this.mIsAvailable = false;
    }

    public boolean isAvailable() {
        return this.mIsAvailable;
    }

    public boolean shouldCheckSpell(String word) {
        return word != null && !word.isEmpty();
    }
}

