/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.impl.SemanticQueryType;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneQueryConceptSearchAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OneQueryConceptSearchAnnotator.class);
    private static final String SPACE = " ";
    private SearchContext searchContext;

    public OneQueryConceptSearchAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext nluContext) {
        List<ConceptInfo> concepts = nluContext.getConcepts();
        PhraseInfo phraseInfo = nluContext.getNluPhraseInfo();
        IFeatureStore featureStore = this.searchContext.getStoreProvider().getFeatureStore(this.searchContext.getReqCtx());
        List<ConceptInfo> conceptsList = SemanticSearchHelper.getAcceptableConcepts(concepts);
        if (!conceptsList.isEmpty()) {
            List conceptsNameList = conceptsList.stream().map(ConceptsUtil::getConceptName).collect(Collectors.toList());
            String conceptsName = String.join((CharSequence)SPACE, conceptsNameList);
            IStoreQuery query = SemanticSearchHelper.buildQuery(this.searchContext.getReqCtx(), featureStore, conceptsName, this.searchContext.getAssetTypes(), this.searchContext.isInDataValue(), SemanticQueryType.CONCEPT, this.searchContext.getAssetRefs());
            List featureHits = featureStore.executeSearch(query);
            SemanticSearchHelper.debugRawFeatureHits(featureHits, LOGGER, String.format("querySearch by concept: [%s] tagged to token: [%s]", conceptsName, phraseInfo.getText()));
            if (featureHits != null && !featureHits.isEmpty()) {
                List<IRecordResult<Feature>> newfeatureHits = featureHits.stream().filter(nluContext::isNewHit).collect(Collectors.toList());
                nluContext.cacheMultipleRawSearchResults(newfeatureHits);
                nluContext.cacheMultipleRawSearchResultsForConcepts(newfeatureHits);
            }
        }
    }
}

