/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.api;

import com.ibm.smarts.ca.api.ISmartsCa;
import com.ibm.smarts.ca.core.impl.SmartsCaStoreProvider;
import com.ibm.smarts.ca.core.rest.client.SmartsCaRestClientHelper;
import com.ibm.smarts.ca.impl.SmartsCa;
import com.ibm.smarts.ca.impl.SmartsCaAdaptor;
import com.ibm.smarts.ca.rest.CaRestDataProvider;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.common.store.SmartsFlowExecutorStore;
import com.ibm.smarts.core.config.SmartsCoreProps;
import com.ibm.smarts.core.mq.MessageQueueingSystem;
import com.ibm.smarts.core.mq.SimpleMessageQueueing;
import com.ibm.smarts.core.util.ConfigUtil;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.RequestContextDecorator;
import com.ibm.smarts.internal.ontology.api.config.KnowledgeDiscoveryProps;
import com.ibm.smarts.nlp.core.config.NLPProps;
import com.ibm.smarts.pipeline.apis.FlowExecutor;
import com.ibm.smarts.similarity.classifier.common.api.WordEmbeddingProvider;
import com.ibm.smarts.store.api.ITypedStore;
import com.ibm.smarts.store.api.multirec.MRTRecord;
import com.ibm.smarts.store.api.provider.IFlowExecutorStore;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.inmem.InMemTypedStore;
import com.ibm.smarts.store.provider.SmartsModuleStore;
import com.ibm.smarts.system.ISmartsAdaptor;
import com.ibm.smarts.system.SmartsSystem;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class SmartsCaSystem
extends SmartsSystem<SmartsCaAdaptor> {
    public final Properties caConfig;
    private static final RequestContextDecorator requestContextDecorator = new RequestContextDecorator();

    public SmartsCaSystem(Properties caConfig, SmartsCaAdaptor adaptor, IDataProvider dataProvider, SmartsCaStoreProvider storeProvider, MessageQueueingSystem messageQueueing, ExecutorService executorService) {
        super((ISmartsAdaptor)adaptor, caConfig, dataProvider, (IStoreProvider)storeProvider, messageQueueing, executorService);
        this.caConfig = caConfig;
        if (Boolean.parseBoolean(caConfig.getProperty("smarts.core.column.embedding"))) {
            WordEmbeddingProvider.initialize((Properties)caConfig);
        }
    }

    private SmartsCaSystem(Properties caConfig, SmartsCaAdaptor adaptor, SmartsCaStoreProvider storeProvider, MessageQueueingSystem messageQueueing, ExecutorService executorService) {
        this(caConfig, adaptor, new CaRestDataProvider(), storeProvider, messageQueueing, executorService);
    }

    public ISmartsCa smartsForRequest(RequestContext rc) {
        return new SmartsCa(this, rc);
    }

    public static SmartsCaSystem with(Properties caConfig) {
        Properties config = SmartsCaSystem.buildSmartsConfig(caConfig);
        ExecutorService executorService = SmartsCaSystem.getExecutorService(config);
        SimpleMessageQueueing mq = config.containsKey("smarts.ca.core.mq.threadPoolSize") ? new SimpleMessageQueueing(Integer.parseInt(config.getProperty("smarts.ca.core.mq.threadPoolSize")), requestContextDecorator) : new SimpleMessageQueueing(requestContextDecorator);
        InMemTypedStore mrtStore = new InMemTypedStore(MRTRecord.class);
        SmartsModuleStore moduleStore = new SmartsModuleStore();
        SmartsFlowExecutorStore flowExecutorStore = new SmartsFlowExecutorStore((ITypedStore)new InMemTypedStore(FlowExecutor.class));
        SmartsCaStoreProvider sp = new SmartsCaStoreProvider(moduleStore, mrtStore, (IFlowExecutorStore)flowExecutorStore, null, caConfig);
        SmartsCaAdaptor sa = new SmartsCaAdaptor();
        return new SmartsCaSystem(config, sa, sp, (MessageQueueingSystem)mq, executorService);
    }

    public static ExecutorService getExecutorService(Properties config) {
        int noOfThreads;
        if (config.containsKey("smarts.ca.core.mq.threadPoolSize")) {
            noOfThreads = Integer.parseInt(config.getProperty("smarts.ca.core.mq.threadPoolSize"));
        } else {
            int CORE_COUNT = Runtime.getRuntime().availableProcessors();
            noOfThreads = CORE_COUNT * 2;
        }
        return Executors.newFixedThreadPool(noOfThreads);
    }

    private static Properties buildSmartsConfig(Properties caConfig) {
        Properties config = ConfigUtil.mergeProps((Properties[])new Properties[]{KnowledgeDiscoveryProps.getDefaultConfig(), caConfig});
        Properties nlpConfig = NLPProps.getDefaultConfig();
        String tempFolder = config.getProperty("smarts.core.tempFolder", SmartsCoreProps.DEFAULT_TEMP_FOLDER);
        String configFolder = config.getProperty("smarts.core.configFolder", SmartsCoreProps.DEFAULT_CONFIG_FOLDER);
        String nlpLibsFolder = tempFolder + nlpConfig.getProperty("smarts.nlp.libs.folder");
        String uimaDatapath = configFolder + nlpConfig.getProperty("smarts.nlp.uima.datapath");
        String uimaDescriptor = uimaDatapath + nlpConfig.getProperty("smarts.nlp.uima.descriptor");
        config.setProperty("smarts.nlp.libs.folder", nlpLibsFolder);
        config.setProperty("smarts.nlp.uima.datapath", uimaDatapath);
        config.setProperty("smarts.nlp.uima.descriptor", uimaDescriptor);
        return config;
    }

    public Properties getCaConfig() {
        return this.caConfig;
    }

    static {
        requestContextDecorator.addDecorator((Consumer)new Consumer<RequestContext>(){

            @Override
            public void accept(RequestContext rc) {
                SmartsCaRestClientHelper.injectRCCF((RequestContext)rc);
            }
        });
    }
}

