/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.rest;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.ca.rest.CaRestDataProviderInfo;
import com.ibm.smarts.ca.rest.CaRestDataProviderModuleInfo;
import com.ibm.smarts.ca.rest.SampleQueryBuilder;
import com.ibm.smarts.common.pipeline.SampleQueryContext;
import com.ibm.smarts.common.provider.DataQueryContext;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.common.provider.IDataProviderModuleInfo;
import com.ibm.smarts.common.provider.ISampleData;
import com.ibm.smarts.common.provider.SampleData;
import com.ibm.smarts.common.rest.DatasetRestClient;
import com.ibm.smarts.common.rest.ModuleRestClient;
import com.ibm.smarts.common.rest.SmartsClientManager;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.util.UniqueNameParser;
import com.ibm.smarts.model.dataset.DatasetDataResult;
import com.ibm.smarts.model.qs.ResultSet;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.util.JAXBHelper;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaRestDataProvider
implements IDataProvider {
    public static final String REST_DATA_PROVIDER_INFO_KEY = "com.ibm.smarts.restDataProviderInfo";

    public Module getModule(RequestContext requestContext, String moduleId) {
        try (Helper h = new Helper(requestContext);){
            Module module = h.getModule(moduleId);
            return module;
        }
    }

    public ISampleData getSampleData(RequestContext requestContext, String qualifiedQuerySubjectId) {
        try (Helper h = new Helper(requestContext);){
            ISampleData iSampleData = h.getSampleData(qualifiedQuerySubjectId);
            return iSampleData;
        }
    }

    public IDataProviderModuleInfo getDataProviderModuleInfo(RequestContext requestContext, String moduleId) {
        try (Helper h = new Helper(requestContext);){
            IDataProviderModuleInfo iDataProviderModuleInfo = h.getDataProviderModuleInfo(moduleId);
            return iDataProviderModuleInfo;
        }
    }

    public ISampleData getSampleData(RequestContext requestContext, SampleQueryContext sampleQueryContext, DatasetInfo dataset) {
        try (Helper h = new Helper(requestContext);){
            ISampleData iSampleData = h.getSampleData(sampleQueryContext, dataset);
            return iSampleData;
        }
    }

    public ResultSet getData(RequestContext requestContext, DataQueryContext queryContext) {
        try (Helper h = new Helper(requestContext);){
            ResultSet resultSet = h.getData(requestContext, queryContext);
            return resultSet;
        }
    }

    private static final class Helper
    implements Closeable {
        private final RequestContext rc;
        private static final Logger LOGGER = LoggerFactory.getLogger(CaRestDataProvider.class);
        private SmartsClientManager clientManager;

        public Helper(RequestContext rc) {
            this.rc = rc;
        }

        @Override
        public void close() {
            if (this.clientManager != null) {
                try {
                    this.clientManager.close();
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e, "failed to close SmartsClientManager", new Object[0]);
                }
            }
        }

        private SmartsClientManager getClientManager() {
            if (this.clientManager == null) {
                this.clientManager = (SmartsClientManager)SmartsClientManager.getClientManager((RequestContext)this.rc, SmartsClientManager.class);
            }
            return this.clientManager;
        }

        private CaRestDataProviderModuleInfo extractRestInfo(String moduleId) {
            CaRestDataProviderModuleInfo moduleInfo = null;
            CaRestDataProviderInfo restInfo = this.extractRestDataProviderInfo();
            if (restInfo != null) {
                moduleInfo = restInfo.getModuleInfo(moduleId);
            }
            if (moduleInfo == null) {
                LOGGER.info("no data provider info found in request context for " + moduleId);
            }
            return moduleInfo;
        }

        private CaRestDataProviderInfo extractRestDataProviderInfo() {
            CaRestDataProviderInfo restInfo = null;
            Object restInfoObject = this.rc.getRequestAttribute(CaRestDataProvider.REST_DATA_PROVIDER_INFO_KEY);
            if (restInfoObject instanceof CaRestDataProviderInfo) {
                restInfo = (CaRestDataProviderInfo)restInfoObject;
            }
            if (restInfo == null) {
                LOGGER.info("no rest data provider info found in request context");
            }
            return restInfo;
        }

        public Module getModule(String moduleId) {
            CaRestDataProviderModuleInfo moduleInfo = this.extractRestInfo(moduleId);
            if (moduleInfo == null) {
                return null;
            }
            String uri = moduleInfo.moduleUri;
            if (uri == null || uri.isEmpty()) {
                LOGGER.info("no module URI found in request context for " + moduleId);
                return null;
            }
            ModuleRestClient client = this.getClientManager().getModuleClient(moduleInfo.baseUri);
            return client.getModule(uri);
        }

        public IDataProviderModuleInfo getDataProviderModuleInfo(String moduleId) {
            return this.extractRestInfo(moduleId);
        }

        public ISampleData getSampleData(SampleQueryContext sampleQueryContext, DatasetInfo dataset) {
            if (dataset.getItem().isEmpty()) {
                return new SampleData(dataset.getId(), new String[0]);
            }
            if (sampleQueryContext == null) {
                throw new InternalException("SampleQueryContext is missing.", new Object[0]);
            }
            String baseUri = sampleQueryContext.getBaseUri();
            SampleQueryBuilder builder = new SampleQueryBuilder(sampleQueryContext);
            List<String> queryItemIds = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)dataset).stream().map(BaseObject::getId).collect(Collectors.toList());
            if (sampleQueryContext.getSortColumns().containsKey(dataset.getId())) {
                queryItemIds.add(0, (String)sampleQueryContext.getSortColumns().get(dataset.getId()));
            }
            String uri = builder.getSamplesUri(baseUri, dataset.getId(), queryItemIds);
            DatasetRestClient client = this.getClientManager().getDatasetsClient(baseUri);
            DatasetDataResult dataResult = client.getDatasetData(uri);
            SampleData sampleData = null;
            if (dataResult != null) {
                sampleData = SampleData.from((String)dataset.getId(), (DatasetDataResult)dataResult);
            } else {
                LOGGER.info("no samples found for " + dataset.getId());
            }
            return sampleData;
        }

        public ISampleData getSampleData(String qualifiedQuerySubjectId) {
            String[] idParts = this.parseQualifiedName(qualifiedQuerySubjectId, 2);
            String moduleId = idParts[0];
            CaRestDataProviderModuleInfo moduleInfo = this.extractRestInfo(moduleId);
            if (moduleInfo == null) {
                LOGGER.info("no module info when when gethering samples for " + qualifiedQuerySubjectId);
                return null;
            }
            String querySubjectId = idParts[1];
            SampleQueryContext context = moduleInfo.getSampleQueryContext();
            SampleQueryBuilder builder = new SampleQueryBuilder(context);
            String uri = builder.getSamplesUri(moduleInfo.baseUri, querySubjectId);
            DatasetRestClient client = this.getClientManager().getDatasetsClient(moduleInfo.baseUri);
            DatasetDataResult dataResult = client.getDatasetData(uri);
            SampleData sampleData = null;
            if (dataResult != null) {
                sampleData = SampleData.from((String)querySubjectId, (DatasetDataResult)dataResult);
            } else {
                LOGGER.info("no samples found for " + qualifiedQuerySubjectId);
            }
            return sampleData;
        }

        public ResultSet getData(RequestContext requestContext, DataQueryContext queryContext) {
            String baseUri = queryContext.getBaseUri();
            DatasetRestClient client = this.getClientManager().getDatasetsClient(baseUri);
            String dataResult = client.getData(queryContext.getDatasetID(), queryContext.getType(), queryContext.getQuerySpec());
            try {
                return (ResultSet)JAXBHelper.unmarshalFromJSON(ResultSet.class, (String)dataResult);
            }
            catch (IOException e) {
                throw new InternalException("Query: \n" + queryContext.getQuerySpec() + " returns invalid query results. \n" + dataResult, new Object[0]);
            }
        }

        private String[] parseQualifiedName(String qualifiedName, int count) {
            String[] idParts = UniqueNameParser.parse((String)qualifiedName, (int)count);
            if (idParts.length < count) {
                throw new InternalException("qualified name must have " + count + " parts: " + qualifiedName, new Object[0]);
            }
            return idParts;
        }
    }
}

