/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedBinaryPropertyChainVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainVisitorEx;

public class IndexedBinaryPropertyChain
extends IndexedPropertyChain {
    private final IndexedObjectProperty leftProperty_;
    private final IndexedPropertyChain rightProperty_;

    IndexedBinaryPropertyChain(IndexedObjectProperty leftProperty, IndexedPropertyChain rightProperty) {
        this.leftProperty_ = leftProperty;
        this.rightProperty_ = rightProperty;
    }

    public IndexedObjectProperty getLeftProperty() {
        return this.leftProperty_;
    }

    public IndexedPropertyChain getRightProperty() {
        return this.rightProperty_;
    }

    @Override
    void updateOccurrenceNumber(int increment) {
        if (this.occurrenceNo == 0 && increment > 0) {
            this.rightProperty_.addRightChain(this);
            this.leftProperty_.addLeftChain(this);
        }
        this.occurrenceNo += increment;
        if (this.occurrenceNo == 0 && increment < 0) {
            this.rightProperty_.removeRightChain(this);
            this.leftProperty_.removeLeftChain(this);
        }
    }

    @Override
    public <O> O accept(IndexedPropertyChainVisitor<O> visitor) {
        return visitor.visit(this);
    }

    public <O> O accept(IndexedBinaryPropertyChainVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O, P> O accept(IndexedPropertyChainVisitorEx<O, P> visitor, P parameter) {
        return visitor.visit(this, parameter);
    }

    public IndexedPropertyChain getComposable(IndexedPropertyChain ipc) {
        return ipc == this.leftProperty_ ? this.rightProperty_ : (ipc == this.rightProperty_ ? this.leftProperty_ : null);
    }

    @Override
    public String toStringStructural() {
        return "ObjectPropertyChain(" + this.leftProperty_ + ' ' + this.rightProperty_ + ')';
    }
}

