/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.impl.store;

import com.ibm.smarts.ca.core.impl.search.CaSearchClient;
import com.ibm.smarts.ca.core.impl.store.CaQueryBuilder;
import com.ibm.smarts.ca.core.impl.store.SmartsCaStoreBase;
import com.ibm.smarts.schema.Clue;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.provider.IClueStore;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.Arrays;
import java.util.List;

public class SmartsCaClueStore
extends SmartsCaStoreBase<Clue>
implements IClueStore {
    public static final String DEFAULT_CLUE_INDEX_NAME = "smarts_clue";
    private static final String DEFAULT_LOCALE = "en";
    private static final String SCHEMA_NAME = "clue";
    private static final String SCHEMA_EXT = ".json";
    private static final String DEFAULT_SCHEMA_RESOURCE_NAME = "clue.json";
    private static final String DEF_TYPE = "elasticDismax";

    public SmartsCaClueStore(StoreConfig storeConfig, CaSearchClient client) {
        super(storeConfig, client, SmartsCaClueStore.buildIndexName(storeConfig), Clue.class);
    }

    private static String buildIndexName(StoreConfig storeConfig) {
        if (storeConfig.isLocale(DEFAULT_LOCALE)) {
            return DEFAULT_CLUE_INDEX_NAME;
        }
        return DEFAULT_CLUE_INDEX_NAME.concat("_" + storeConfig.locale.getLanguage());
    }

    @Override
    protected String schemaResourceName() {
        if (this.storeConfig.isLocale(DEFAULT_LOCALE)) {
            return DEFAULT_SCHEMA_RESOURCE_NAME;
        }
        StringBuilder resNameBldr = new StringBuilder();
        resNameBldr.append(SCHEMA_NAME);
        resNameBldr.append("_");
        resNameBldr.append(this.storeConfig.locale.getLanguage());
        resNameBldr.append(SCHEMA_EXT);
        return resNameBldr.toString();
    }

    @Override
    protected String primarySearchIndex() {
        return DEFAULT_CLUE_INDEX_NAME;
    }

    public StoreStatus delete(String ontoId, String tenantId, String userId) {
        throw new UnsupportedOperationException();
    }

    public StoreStatus delete(String ontoId, String tenantId) {
        throw new UnsupportedOperationException();
    }

    public StoreStatus delete(String ontoId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CaQueryBuilder queryBuilder() {
        return new ClueQueryBuilder(this.storeConfig.locale.getLanguage());
    }

    static class ClueQueryBuilder
    extends CaQueryBuilder {
        private String locale;
        private static final List<String> supportedLocales = Arrays.asList("es", "fr");

        ClueQueryBuilder(String locale) {
            this.locale = locale;
        }

        @Override
        protected CaQueryBuilder.QueryBuilderContext context(IStoreQuery sq) {
            return new CaQueryBuilder.QueryBuilderContext(sq, SmartsCaClueStore.DEF_TYPE){

                @Override
                protected void buildInternal() {
                    super.buildInternal();
                    if (!locale.equals(SmartsCaClueStore.DEFAULT_LOCALE) && supportedLocales.contains(locale)) {
                        this.addLocale(locale);
                    }
                }

                @Override
                protected String escapeSpecialCharacters(String query, boolean disMax) {
                    return disMax ? query : super.escapeSpecialCharacters(query, disMax);
                }
            };
        }
    }
}

