/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ca.core.rest.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.ibm.smarts.ca.core.rest.client.ICaResourceListener;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.core.util.ToString;
import com.sun.jersey.core.header.reader.HttpHeaderReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class CaRestClient
extends RestClient {
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String X_XSRF_TOKEN = "X-XSRF-TOKEN";
    private static final String XSRF_TOKEN_COOKIE_NAME = "XSRF-TOKEN";
    private static final String COOKIE_ASSIGNMENT = "=";
    private static final String COOKIE_DELIMITER = "; ";
    private Set<ICaResourceListener> resourceListeners = new HashSet<ICaResourceListener>();

    public CaRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        super(rccf, requestContext, uri, null);
    }

    @Deprecated
    protected CaRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri, Map<String, List<String>> headers) {
        super(rccf, requestContext, uri, headers);
    }

    public boolean isAvailable() {
        boolean ret = false;
        try {
            this.getResponse("");
            ret = true;
        }
        catch (Exception ex) {
            StringBuilder sb = new StringBuilder();
            sb.append(ex.getMessage());
            for (Throwable curr = ex.getCause(); curr != null; curr = curr.getCause()) {
                sb.append(" caused by " + this.doubleQuoted(curr.getMessage()));
            }
            String msg = sb.toString();
            LOGGER.info("CaServerFacility is not available: " + msg);
            ret = false;
        }
        return ret;
    }

    private String doubleQuoted(String s) {
        if (s == null) {
            return s;
        }
        return "\"" + s + "\"";
    }

    public boolean isDispatcherReady() {
        Response response = this.getResponse("bi");
        int status = response.getStatus();
        if (status == 404) {
            return false;
        }
        return status != 503;
    }

    public void logoff() {
        Response resp = this.deleteResponse("bi/v1/login");
        if (resp.getStatus() != 200) {
            // empty if block
        }
    }

    public Map<String, List<String>> logon(CaCredentials creds) {
        LOGGER.debug("Logging on using " + creds);
        Response getResp = this.getResponse("bi/v1/login");
        this.handleLogonResponse(getResp);
        if (!creds.isAnonymous()) {
            String credsJson = creds.toJson();
            Response postResp = this.postResponse("bi/v1/login", credsJson);
            this.handleLogonResponse(postResp);
        }
        return this.getHttpHeaders();
    }

    public Map<String, List<String>> pingCa() {
        LOGGER.debug("Pinging CA");
        Response getResp = this.getResponse("bi/v1/ping");
        this.handleLogonResponse(getResp);
        return this.getHttpHeaders();
    }

    private void handleLogonResponse(Response response) {
        int status = response.getStatus();
        if (status == 403) {
            LOGGER.debug("Already logged on");
        } else if (status == 200 || status == 441) {
            StringBuilder allCookies = new StringBuilder();
            Map<String, NewCookie> responseCookies = this.getCookies(response);
            for (NewCookie responseCookie : responseCookies.values()) {
                if (XSRF_TOKEN_COOKIE_NAME.equals(responseCookie.getName())) {
                    this.headers.put(X_XSRF_TOKEN, Arrays.asList(responseCookie.getValue()));
                }
                String cookie = responseCookie.getName() + COOKIE_ASSIGNMENT + responseCookie.getValue();
                allCookies.append(cookie);
                allCookies.append(COOKIE_DELIMITER);
            }
            String cookieString = allCookies.toString().trim();
            this.headers.put("Cookie", Arrays.asList(cookieString));
        } else {
            throw new InternalException("Login failed", new Object[]{response});
        }
    }

    private Map<String, NewCookie> getCookies(Response response) {
        MultivaluedMap hdrs = response.getMetadata();
        List cookies = (List)hdrs.get((Object)"Set-Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> result = new HashMap<String, NewCookie>();
        for (Object cookieObject : cookies) {
            if (cookieObject == null) continue;
            String cookie = (String)cookieObject;
            NewCookie newCookie = HttpHeaderReader.readNewCookie((String)cookie);
            result.put(newCookie.getName(), newCookie);
        }
        return result;
    }

    public void addResourceListener(ICaResourceListener l) {
        this.resourceListeners.add(l);
    }

    public void removeResourceListener(ICaResourceListener l) {
        this.resourceListeners.remove(l);
    }

    protected void notifyCreated(String id, String name, String type) {
        this.resourceListeners.forEach(l -> l.created(this, id, name, type));
    }

    protected void notifyDeleted(String id) {
        this.resourceListeners.forEach(l -> l.deleted(this, id));
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.registerModule((Module)new JaxbAnnotationModule());
    }

    public static class CaCredentials {
        public static final String LDAP_NAMESPACE = "LDAP";
        public static final String LOGON_ACTION = "logonAs";
        public static final String ANONYMOUS = "anonymous";
        public final String camNamespace;
        public final String camAction;
        public final String camUsername;
        public final String camPassword;

        private CaCredentials(String ns, String action, String user, String password) {
            this.camNamespace = ns;
            this.camAction = action;
            this.camUsername = user;
            this.camPassword = password;
        }

        public String toString() {
            return ToString.with((Object)this).field("camNamespace", (Object)this.camNamespace).field("camAction", (Object)this.camAction).field("camUsername", (Object)this.camUsername).field("camPassword", (Object)this.camPassword).get();
        }

        public boolean isAnonymous() {
            return CaCredentials.isAnonymous(this.camUsername);
        }

        public static boolean isAnonymous(String user) {
            return ANONYMOUS.equals(user);
        }

        public boolean usingNamespace() {
            return CaCredentials.usingNamespace(this.camNamespace);
        }

        public static boolean usingNamespace(String namespace) {
            if (namespace == null) {
                return false;
            }
            return !namespace.isEmpty();
        }

        public static CaCredentials camLogonAs(String user, String password) {
            if (ANONYMOUS.equals(user)) {
                return new CaCredentials(null, LOGON_ACTION, ANONYMOUS, null);
            }
            return new CaCredentials(LDAP_NAMESPACE, LOGON_ACTION, user, password);
        }

        public static CaCredentials camLogonAs(String namespace, String user, String password) {
            String passwordToUse = CaCredentials.isAnonymous(user) ? null : password;
            return new CaCredentials(namespace, LOGON_ACTION, user, passwordToUse);
        }

        public String toJson() {
            JsonNodeFactory f = JsonNodeFactory.instance;
            ObjectNode root = f.objectNode();
            if (!ANONYMOUS.equals(this.camUsername)) {
                ArrayNode params = f.arrayNode();
                root.set("parameters", (JsonNode)params);
                params.add((JsonNode)CaCredentials.buildObject(f, "CAMNamespace", this.camNamespace));
                params.add((JsonNode)CaCredentials.buildObject(f, "h_CAM_action", this.camAction));
                params.add((JsonNode)CaCredentials.buildObject(f, "CAMUsername", this.camUsername));
                params.add((JsonNode)CaCredentials.buildObject(f, "CAMPassword", this.camPassword));
            }
            String ret = root.toString();
            return ret;
        }

        private static ObjectNode buildObject(JsonNodeFactory f, String name, String value) {
            ObjectNode o = f.objectNode();
            o.put("name", name);
            o.put("value", value);
            return o;
        }
    }

    public static class Paths {
        public static final String BI = "bi";
        public static final String PING = "bi/v1/ping";
        public static final String LOGIN = "bi/v1/login";
    }
}

