/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CryptoHttpClient;
import com.cognos.accman.jcam.crypto.misc.CAMSSLSocketFactory;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class HttpClientInitializer {
    private static HttpClientInitializer instance = null;
    static CAMSecureProtocolSocketFactory s_SecureProtocolSocketFactory = null;
    private MultiThreadedHttpConnectionManager connMgr = null;

    public static synchronized HttpClientInitializer getInstance() throws CAMCryptoException {
        if (instance == null) {
            instance = new HttpClientInitializer();
        }
        return instance;
    }

    private HttpClientInitializer() throws CAMCryptoException {
        if (s_SecureProtocolSocketFactory == null) {
            s_SecureProtocolSocketFactory = new CAMSecureProtocolSocketFactory();
        }
        this.connMgr = new MultiThreadedHttpConnectionManager();
        this.connMgr.setMaxConnectionsPerHost(Integer.MAX_VALUE);
        this.connMgr.setMaxTotalConnections(Integer.MAX_VALUE);
    }

    public HttpClient createHttpClient(String host, int port, boolean secure) throws CAMCryptoException {
        HttpClient hc = new HttpClient();
        CamHttpClientHostConfiguration hostConfiguration = new CamHttpClientHostConfiguration(hc.getHostConfiguration());
        hc.setHostConfiguration((HostConfiguration)hostConfiguration);
        if (secure) {
            hc.getHostConfiguration().setHost(host, port, "https");
        } else {
            hc.getHostConfiguration().setHost(host, port);
        }
        return hc;
    }

    public HttpClient createSecurePooledHttpClient(String host, int port) throws CAMCryptoException {
        HttpClient hc = new HttpClient((HttpConnectionManager)this.connMgr);
        CamHttpClientHostConfiguration hostConfiguration = new CamHttpClientHostConfiguration(hc.getHostConfiguration());
        hc.setHostConfiguration((HostConfiguration)hostConfiguration);
        hc.getHostConfiguration().setHost(host, port, "https");
        return hc;
    }

    public HttpClient createHttpClient(URL url) throws CAMCryptoException {
        String host = url.getHost();
        int port = url.getPort();
        boolean secure = url.getProtocol().equalsIgnoreCase("https");
        return this.createHttpClient(host, port, secure);
    }

    public HttpConnection createHttpConnection(String host, int port, boolean secure) throws CAMCryptoException {
        HttpConnection hc;
        if (secure) {
            Protocol protocol = new Protocol("https", (SecureProtocolSocketFactory)s_SecureProtocolSocketFactory, 443);
            hc = new HttpConnection(host, port, protocol);
        } else {
            hc = new HttpConnection(host, port);
        }
        return hc;
    }

    public HttpConnection createHttpConnection(URL url) throws CAMCryptoException {
        HttpConnection hc;
        boolean secure = url.getProtocol().equalsIgnoreCase("https");
        if (secure) {
            Protocol protocol = new Protocol("https", (SecureProtocolSocketFactory)s_SecureProtocolSocketFactory, 443);
            hc = new HttpConnection(url.getHost(), url.getPort(), protocol);
        } else {
            hc = new HttpConnection(url.getHost(), url.getPort());
        }
        return hc;
    }

    public CryptoHttpClient createCryptoHttpClient(String host, int port, boolean secure) throws CAMCryptoException {
        CryptoHttpClient chc = new CryptoHttpClient();
        chc.setHost(host);
        chc.setPort(port);
        chc.setSecure(secure);
        CamHttpClientHostConfiguration hostConfiguration = new CamHttpClientHostConfiguration(chc.getHostConfiguration());
        chc.setHostConfiguration(hostConfiguration);
        if (secure) {
            chc.getHostConfiguration().setHost(host, port, "https");
        } else {
            chc.getHostConfiguration().setHost(host, port);
        }
        return chc;
    }

    public void resetCryptoHttpClient(CryptoHttpClient chc) throws CAMCryptoException {
        if (chc.getSecure()) {
            chc.getHostConfiguration().setHost(chc.getHost(), chc.getPort(), "https");
        } else {
            chc.getHostConfiguration().setHost(chc.getHost(), chc.getPort());
        }
    }

    private class CAMSecureProtocolSocketFactory
    implements SecureProtocolSocketFactory {
        private CAMSecureProtocolSocketFactory() {
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
            try {
                Configuration config = Configuration.getInstance();
                CAMSSLSocketFactory ssf = config.getCAMSSLSocketFactory();
                SSLSocket ss = (SSLSocket)ssf.createSocket(host, port, clientHost, clientPort);
                ss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
                ss.setEnabledProtocols(config.getSSLProtocols());
                return ss;
            }
            catch (CAMCryptoException e) {
                throw new IOException(e.toString());
            }
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort, HttpConnectionParams hcp) throws IOException {
            return this.createSocket(host, port, clientHost, clientPort);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            try {
                Configuration config = Configuration.getInstance();
                CAMSSLSocketFactory ssf = config.getCAMSSLSocketFactory();
                SSLSocket ss = (SSLSocket)ssf.createSocket(socket, host, port, autoClose);
                ss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
                ss.setEnabledProtocols(config.getSSLProtocols());
                return ss;
            }
            catch (CAMCryptoException e) {
                throw new IOException(e.toString());
            }
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            try {
                Configuration config = Configuration.getInstance();
                CAMSSLSocketFactory ssf = config.getCAMSSLSocketFactory();
                SSLSocket ss = (SSLSocket)ssf.createSocket(host, port);
                ss.setEnabledCipherSuites(config.getJSSECipherSuitesList());
                ss.setEnabledProtocols(config.getSSLProtocols());
                return ss;
            }
            catch (CAMCryptoException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private class CamHttpClientHostConfiguration
    extends HostConfiguration {
        public CamHttpClientHostConfiguration(HostConfiguration hostConfiguration) {
            super(hostConfiguration);
        }

        public Object clone() {
            return new CamHttpClientHostConfiguration(this);
        }

        public synchronized void setHost(String host, int port, String scheme) {
            this.setHost(new HttpHost(host, port, this.getProtocol(scheme)));
        }

        private Protocol getProtocol(String scheme) {
            if (scheme != null && scheme.compareToIgnoreCase("https") == 0) {
                return new Protocol("https", (SecureProtocolSocketFactory)s_SecureProtocolSocketFactory, 443);
            }
            return Protocol.getProtocol((String)scheme);
        }
    }
}

