/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;

public class JCAMEchoServer {
    CAMFactory cf = null;
    ServerSocket camServerSocket;
    Socket socket = null;
    ObjectOutputStream out;
    ObjectInputStream in;
    String sendMsg = null;
    String recvMsg = null;
    String stopCall = "Bye";

    JCAMEchoServer() {
        try {
            this.cf = new CAMFactory("JCAMEchoServer");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
    }

    void run(URL url) {
        try {
            this.camServerSocket = this.cf.createServerSocket(url);
            System.out.println("\nWaiting for connection ...\n");
        }
        catch (CAMCryptoException e) {
            e.printStackTrace();
        }
        try {
            this.socket = this.camServerSocket.accept();
            System.out.println("Connected from " + this.socket.getInetAddress().getHostName());
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            this.out.flush();
            this.in = new ObjectInputStream(this.socket.getInputStream());
            this.sendMsg = "Connected to server";
            this.out.writeObject(this.sendMsg);
            this.out.flush();
            System.out.println("server > " + this.sendMsg);
            do {
                try {
                    this.recvMsg = (String)this.in.readObject();
                    System.out.println("client > " + this.recvMsg);
                    if (!this.recvMsg.equals(this.stopCall)) continue;
                    this.sendMsg = this.stopCall;
                    this.out.writeObject(this.sendMsg);
                    this.out.flush();
                    System.out.println("server > " + this.sendMsg);
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
            } while (!this.recvMsg.equals(this.stopCall));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.in.close();
                this.out.close();
                this.camServerSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void start(URL url) {
        JCAMEchoServer server = new JCAMEchoServer();
        while (true) {
            server.run(url);
        }
    }
}

