/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.SmartsStatus;
import com.ibm.smarts.visualization.recommender.schema.VisRecommendation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class VisRecommenderResponse {
    private int smartsStatus;
    private String details;
    private List<VisRecommendation> recommendations;

    @JsonCreator
    public VisRecommenderResponse(@JsonProperty(value="smartsStatus") int smartsStatus, @JsonProperty(value="details") String details, @JsonProperty(value="recommendations") List<VisRecommendation> recommendations) {
        this.smartsStatus = smartsStatus;
        this.details = details;
        this.recommendations = recommendations;
    }

    public VisRecommenderResponse(List<? extends IRecommendedVisualization> recommendedVisualizations, SmartsStatus smartsStatus) {
        this.smartsStatus = smartsStatus.getValue();
        this.details = smartsStatus.getDetails();
        this.recommendations = recommendedVisualizations.stream().map(VisRecommendation::new).collect(Collectors.toList());
    }

    public VisRecommenderResponse(List<? extends IRecommendedVisualization> recommendedVisualizations) {
        this(recommendedVisualizations, SmartsStatus.OK);
    }

    public VisRecommenderResponse(SmartsStatus smartsStatus) {
        this(new ArrayList(), smartsStatus);
    }

    public VisRecommenderResponse(Exception e) {
        this.smartsStatus = SmartsStatus.ERROR.getValue();
        this.details = "";
        this.recommendations = new ArrayList<VisRecommendation>();
    }

    public VisRecommenderResponse(VisRecommendation visRecommendation) {
        this.smartsStatus = SmartsStatus.OK.getValue();
        this.details = SmartsStatus.OK.getDetails();
        this.recommendations = new ArrayList<VisRecommendation>();
        this.recommendations.add(visRecommendation);
    }

    public List<VisRecommendation> getRecommendations() {
        return this.recommendations;
    }

    public void setRecommendations(List<VisRecommendation> recommendations) {
        this.recommendations = recommendations;
    }

    public int getSmartsStatus() {
        return this.smartsStatus;
    }

    public String getDetails() {
        return this.details;
    }

    public static VisRecommenderResponse fromJSON(String str) {
        try {
            return (VisRecommenderResponse)CommonJAXBHelper.unmarshalFromJSON(VisRecommenderResponse.class, (String)str);
        }
        catch (JsonDeserializeException e) {
            return null;
        }
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        json.put((Object)"smartsStatus", (Object)this.smartsStatus);
        json.put((Object)"details", (Object)this.details);
        if (this.recommendations != null) {
            JSONArray jsonRecommendations = new JSONArray();
            this.recommendations.stream().forEach(r -> jsonRecommendations.add((Object)r.toJSONObject()));
            json.put((Object)"recommendations", (Object)jsonRecommendations);
        }
        return json;
    }
}

