/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConfigurationSource
implements PolledConfigurationSource {
    private final URL[] configUrls;
    public static final String CONFIG_URL = "archaius.configurationSource.additionalUrls";
    public static final String DEFAULT_CONFIG_FILE_NAME = "config.properties";
    public static final String DEFAULT_CONFIG_FILE_FROM_CLASSPATH = System.getProperty("archaius.configurationSource.defaultFileName") == null ? "config.properties" : System.getProperty("archaius.configurationSource.defaultFileName");
    private static final Logger logger = LoggerFactory.getLogger(URLConfigurationSource.class);

    public URLConfigurationSource(String ... urls) {
        this.configUrls = URLConfigurationSource.createUrls(urls);
    }

    private static URL[] createUrls(String ... urlStrings) {
        if (urlStrings == null || urlStrings.length == 0) {
            throw new IllegalArgumentException("urlStrings is null or empty");
        }
        URL[] urls = new URL[urlStrings.length];
        try {
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new URL(urlStrings[i]);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return urls;
    }

    public URLConfigurationSource(URL ... urls) {
        this.configUrls = urls;
    }

    public URLConfigurationSource() {
        String[] fileNames;
        ArrayList<URL> urlList = new ArrayList<URL>();
        URL configFromClasspath = this.getConfigFileFromClasspath();
        if (configFromClasspath != null) {
            urlList.add(configFromClasspath);
        }
        if ((fileNames = URLConfigurationSource.getDefaultFileSources()).length != 0) {
            urlList.addAll(Arrays.asList(URLConfigurationSource.createUrls(fileNames)));
        }
        if (urlList.size() == 0) {
            this.configUrls = new URL[0];
            logger.warn("No URLs will be polled as dynamic configuration sources.");
            logger.info("To enable URLs as dynamic configuration sources, define System property archaius.configurationSource.additionalUrls or make " + DEFAULT_CONFIG_FILE_FROM_CLASSPATH + " available on classpath.");
        } else {
            this.configUrls = urlList.toArray(new URL[urlList.size()]);
            logger.info("URLs to be used as dynamic configuration source: " + urlList);
        }
    }

    private URL getConfigFileFromClasspath() {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        if (url == null) {
            url = URLConfigurationSource.class.getResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        return url;
    }

    public List<URL> getConfigUrls() {
        return Collections.unmodifiableList(Arrays.asList(this.configUrls));
    }

    private static final String[] getDefaultFileSources() {
        String name = System.getProperty(CONFIG_URL);
        String[] fileNames = name != null ? name.split(",") : new String[]{};
        return fileNames;
    }

    @Override
    public PollResult poll(boolean initial, Object checkPoint) throws IOException {
        if (this.configUrls == null || this.configUrls.length == 0) {
            return PollResult.createFull(null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (URL url : this.configUrls) {
            Properties props = new Properties();
            InputStream fin = url.openStream();
            props.load(fin);
            fin.close();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
        return PollResult.createFull(map);
    }

    public String toString() {
        return "FileConfigurationSource [fileUrls=" + Arrays.toString(this.configUrls) + "]";
    }
}

