/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.registry.util;

import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptsUtil {
    private static final List<String> REPRESENTS_CONCEPT_IDS = Arrays.asList("http://www.ibm.com/ontologies/waca/domain/common#Geography", "http://www.ibm.com/ontologies/waca/domain/common#Temporal");
    private static final Logger LOGGER = LoggerFactory.getLogger(ConceptsUtil.class);

    private ConceptsUtil() {
    }

    public static boolean isRepresentsConcept(ConceptInfo conceptInfo) {
        Concept concept = ConceptsRegistry.instance().getConcept(conceptInfo.getConceptID());
        for (String representsIRI : REPRESENTS_CONCEPT_IDS) {
            if (concept == null || !concept.getIRI().contains(representsIRI) && !concept.getParents().stream().map(Concept::getIRI).anyMatch(c -> c.equals(representsIRI))) continue;
            return true;
        }
        return false;
    }

    public static String getConceptName(ConceptInfo conceptInfo) {
        if (conceptInfo == null) {
            LOGGER.warn("ConceptInfo is null. Will not search concept name");
            return Concept.UNKNOWN_CONCEPT.getName();
        }
        return ConceptsRegistry.instance().getConcept(conceptInfo.getConceptID()).getName();
    }

    public static String getOntologyId(ConceptInfo conceptInfo) {
        if (conceptInfo == null) {
            LOGGER.warn("ConceptInfo is null. Will not search ontology ID");
            return Concept.UNKNOWN_CONCEPT.getOntologyID();
        }
        return ConceptsRegistry.instance().getConcept(conceptInfo.getConceptID()).getOntologyID();
    }

    public static List<ConceptInfo> getDescendantsOfConcept(List<ConceptInfo> conceptInfoList, String conceptID) {
        return ConceptsUtil.is(conceptInfoList, conceptID, true);
    }

    public static List<ConceptInfo> is(List<ConceptInfo> conceptInfoList, String conceptID) {
        return ConceptsUtil.is(conceptInfoList, conceptID, false);
    }

    private static List<ConceptInfo> is(List<ConceptInfo> conceptInfoList, String conceptID, boolean excludeTarget) {
        if (conceptInfoList == null) {
            return Collections.emptyList();
        }
        ArrayList<ConceptInfo> matches = new ArrayList<ConceptInfo>();
        for (ConceptInfo ci : conceptInfoList) {
            Concept concept = ConceptsRegistry.instance().getConcept(ci.getConceptID());
            if ((excludeTarget || !concept.getIRI().equals(conceptID)) && !ConceptsUtil.isDescendantOfConcept(concept, conceptID)) continue;
            matches.add(ci);
        }
        return matches;
    }

    private static boolean isDescendantOfConcept(Concept concept, String conceptID) {
        return concept.getAncestors().stream().anyMatch(a -> a.getIRI().equals(conceptID));
    }
}

