/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.recommenders.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IChartElementTypesProvider;
import com.ibm.smarts.visualization.recommender.api.IExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.exceptions.ChartDescriptorLoaderException;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.ExternalChartDescriptorsFactory;
import com.ibm.smarts.visualization.recommender.internal.ChartCompatabilityMapper;
import com.ibm.smarts.visualization.recommender.internal.ChartDescriptorRegistery;
import com.ibm.smarts.visualization.recommender.internal.ChartRankings;
import com.ibm.smarts.visualization.recommender.internal.CompatibleChartsForBindingSets;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementType;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementTypes;
import com.ibm.smarts.visualization.recommender.internal.charts.ExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.model.charts.extensions.ModelChartDescriptorsFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChartDescriptorLoader {
    private static final String JAR_SCHEME = "jar";
    private static final String PATH_NOT_FOUND = "Path not found ";
    private static final String EMPTY_DIR = "spec directory is empty ";

    private ChartDescriptorLoader() {
    }

    private static List<String> walkDir(String dir) throws IOException {
        List<String> files;
        block31: {
            URI uri = null;
            try {
                uri = new File(dir).toURI();
            }
            catch (SecurityException exc) {
                throw new IOException("Exception with " + dir + exc);
            }
            if (uri.getScheme().equals(JAR_SCHEME)) {
                try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    Path path = fileSystem.getPath(dir, new String[0]);
                    if (path == null) {
                        throw new IOException(PATH_NOT_FOUND + dir);
                    }
                    try (Stream<Path> stream = Files.walk(path, 1, new FileVisitOption[0]);){
                        files = stream.filter(p -> !p.toFile().isDirectory()).map(p -> p.toString().substring(1)).collect(Collectors.toList());
                        break block31;
                    }
                }
            }
            files = new ArrayList<String>();
            File root = new File(dir);
            if (!root.exists()) {
                throw new IOException(PATH_NOT_FOUND + dir);
            }
            File[] rootFiles = root.listFiles();
            if (rootFiles == null) {
                throw new IOException(EMPTY_DIR + dir);
            }
            for (File f : rootFiles) {
                files.add(dir + File.separator + f.getName());
            }
        }
        return files;
    }

    private static List<String> walkResourceDir(String dir) throws IOException, URISyntaxException {
        List<String> files;
        block39: {
            URI uri = ChartDescriptorLoader.class.getResource(dir).toURI();
            if (uri.getScheme().equals(JAR_SCHEME)) {
                try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                    Path path = fileSystem.getPath(dir, new String[0]);
                    if (path == null) {
                        throw new IOException(PATH_NOT_FOUND + dir);
                    }
                    try (Stream<Path> stream = Files.walk(path, 1, new FileVisitOption[0]);){
                        files = stream.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
                        break block39;
                    }
                }
            }
            files = new ArrayList<String>();
            try (BufferedReader bf = new BufferedReader(new InputStreamReader(ChartDescriptorLoader.class.getResourceAsStream(dir), StandardCharsets.UTF_8));){
                String p2;
                while ((p2 = bf.readLine()) != null) {
                    files.add(dir + "/" + p2);
                }
            }
        }
        return files;
    }

    private static <T> List<T> loadChartDescriptors(String dir, Class<T> cls) throws IOException, URISyntaxException {
        ArrayList charts = new ArrayList();
        List<String> paths = ChartDescriptorLoader.walkResourceDir(dir);
        for (String p : paths) {
            InputStream stream = ChartDescriptorLoader.class.getResourceAsStream(p);
            Throwable throwable = null;
            try {
                List rDescriptors = JsonParserHelper.parseJsonAsList((String)JsonParserHelper.getJsonStringFromStream((InputStream)stream), cls);
                charts.addAll(rDescriptors);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return charts;
    }

    private static synchronized void loadExtTypes(String dir) throws IOException {
        List<String> paths = ChartDescriptorLoader.walkDir(dir);
        for (String p : paths) {
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(p));
            Throwable throwable = null;
            try {
                ChartElementType[] types = (ChartElementType[])JsonParserHelper.parseJson((JsonNode)JsonParserHelper.getJsonFromStream((InputStream)stream), ChartElementType[].class);
                ChartElementTypes.getTypes().putAll(Arrays.asList(types).stream().filter(ChartElementType::isValid).collect(Collectors.toMap(ChartElementType::getName, Function.identity(), (t1, t2) -> t1)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    public static void loadStdChartDescriptors(ChartDescriptorRegistery<IChartDescriptor> reg, String path) throws ChartDescriptorLoaderException {
        try {
            reg.registerAll(new ArrayList<ChartDescriptor>(ChartDescriptorLoader.loadChartDescriptors(path, ChartDescriptor.class)));
        }
        catch (IOException | URISyntaxException exc) {
            throw new ChartDescriptorLoaderException(exc);
        }
    }

    public static void loadExtensionChartDescriptors(ChartDescriptorRegistery<IChartDescriptor> reg, Optional<String> chartsPath, Optional<String> typesPath) throws ChartDescriptorLoaderException {
        reg.registerAll(ChartDescriptorLoader.loadServiceProviderCharts(IChartDescriptor.class));
        try {
            if (typesPath.isPresent()) {
                ChartDescriptorLoader.loadExtTypes(typesPath.get());
            }
            if (chartsPath.isPresent()) {
                reg.registerAll(new ArrayList<ChartDescriptor>(ChartDescriptorLoader.loadChartDescriptors(chartsPath.get(), ChartDescriptor.class)));
            }
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        reg.registerAll(ModelChartDescriptorsFactory.createModelChartDescriptorsExtensions());
    }

    private static synchronized <T> List<T> loadServiceProviderCharts(Class<T> cls) throws ChartDescriptorLoaderException {
        ArrayList<T> charts = new ArrayList<T>();
        ServiceLoader<T> loader = ServiceLoader.load(cls);
        try {
            for (T chart : loader) {
                charts.add(chart);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            throw new ChartDescriptorLoaderException(new Exception(serviceError));
        }
        return charts;
    }

    public static synchronized <T extends IChartElementTypesProvider> List<T> loadTypeProviders(Class<T> cls) {
        ArrayList<IChartElementTypesProvider> types = new ArrayList<IChartElementTypesProvider>();
        ServiceLoader<IChartElementTypesProvider> loader = ServiceLoader.load(cls);
        for (IChartElementTypesProvider type : loader) {
            types.add(type);
        }
        return types;
    }

    public static List<IChartElementTypesProvider> loadServiceProviderTypes() throws ChartDescriptorLoaderException {
        List<IChartElementTypesProvider> types;
        try {
            types = ChartDescriptorLoader.loadTypeProviders(IChartElementTypesProvider.class);
        }
        catch (ServiceConfigurationError serviceError) {
            throw new ChartDescriptorLoaderException(new Exception(serviceError));
        }
        return types;
    }

    public static void loadExternalChartDescriptors(ChartDescriptorRegistery<IExternalChartDescriptor> reg, Optional<String> dir, Optional<String> typesPath) throws ChartDescriptorLoaderException {
        try {
            if (typesPath.isPresent()) {
                ChartDescriptorLoader.loadExtTypes(typesPath.get());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (dir.isPresent()) {
                reg.registerAll(new ArrayList<ExternalChartDescriptor>(ChartDescriptorLoader.loadChartDescriptors(dir.get(), ExternalChartDescriptor.class)));
            }
        }
        catch (IOException | URISyntaxException exc) {
            throw new ChartDescriptorLoaderException(exc);
        }
        reg.registerAll(ExternalChartDescriptorsFactory.createExternalChartDescriptors());
    }

    private static <T> T loadClassFromJsonStream(InputStream stream, Class<T> klass) throws ChartDescriptorLoaderException {
        try {
            return (T)JsonParserHelper.parseJson((JsonNode)JsonParserHelper.getJsonFromStream((InputStream)stream), klass);
        }
        catch (IOException exc) {
            throw new ChartDescriptorLoaderException(exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChartCompatabilityMapper loadChartCompatibility(String file) throws ChartDescriptorLoaderException {
        try (InputStream stream = ChartDescriptorLoader.class.getResourceAsStream(file);){
            ChartCompatabilityMapper chartCompatabilityMapper = ChartDescriptorLoader.loadClassFromJsonStream(stream, ChartCompatabilityMapper.class);
            return chartCompatabilityMapper;
        }
        catch (IOException exc) {
            throw new ChartDescriptorLoaderException(exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ChartRankings loadChartRankings(String file) throws ChartDescriptorLoaderException {
        try (InputStream stream = ChartDescriptorLoader.class.getResourceAsStream(file);){
            ChartRankings chartRankings = ChartDescriptorLoader.loadClassFromJsonStream(stream, ChartRankings.class);
            return chartRankings;
        }
        catch (IOException exc) {
            throw new ChartDescriptorLoaderException(exc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompatibleChartsForBindingSets loadChartBindingsCompatibility(String file) throws ChartDescriptorLoaderException {
        try (InputStream stream = ChartDescriptorLoader.class.getResourceAsStream(file);){
            CompatibleChartsForBindingSets compatibleChartsForBindingSets = ChartDescriptorLoader.loadClassFromJsonStream(stream, CompatibleChartsForBindingSets.class);
            return compatibleChartsForBindingSets;
        }
        catch (IOException exc) {
            throw new ChartDescriptorLoaderException(exc);
        }
    }
}

