/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.recommenders.core.utils;

import com.ibm.smarts.generic.recommender.api.java.classifiers.ClassifierException;
import com.ibm.smarts.generic.recommender.api.java.classifiers.Classifiers;
import com.ibm.smarts.generic.recommender.api.java.classifiers.DatasetException;
import com.ibm.smarts.generic.recommender.api.java.classifiers.DatasetFeatureDescriptorException;
import com.ibm.smarts.generic.recommender.api.java.classifiers.IClassifier;
import com.ibm.smarts.generic.recommender.api.java.classifiers.SupportedFileFormats;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelGenerator.class);
    private static final String TRAININGSET_NOTFOUND_ERR = "trainingset file not found";
    private static final String TRAININGSET_SPEC_NOTFOUND_ERR = "trainingsetSpec file not found";
    private static final String MODEL_FILE_NOTFOUND_ERR = "model file cannot be created";
    private static final String INVALID_NUM_PARAMETERS_ERR = "Invalid number of parameters";

    public static void generate(OutputStream model, Classifiers classifiersFactory, IClassifier classifier, InputStream trainingsetStream, InputStream trainingsetSpecStream) {
        long startTime = System.currentTimeMillis();
        long endTime = 0L;
        try {
            classifier.train(trainingsetStream, SupportedFileFormats.CSV, trainingsetSpecStream);
        }
        catch (ClassifierException | DatasetException | DatasetFeatureDescriptorException e) {
            LOGGER.error("Failed to train classifier {}", e);
        }
        endTime = System.currentTimeMillis();
        LOGGER.info("VisualizationRecommender - training classifier - end {} ms", (Object)(endTime - startTime));
        try {
            byte[] bytes = classifiersFactory.serliazeClassifier(classifier);
            model.write(bytes);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write recommender trained model {}", (Throwable)e);
        }
    }

    public static void main(String[] params) {
        File trainingset;
        if (params.length < 5) {
            LOGGER.error(INVALID_NUM_PARAMETERS_ERR);
        }
        if (!(trainingset = new File(params[0])).exists()) {
            LOGGER.error(TRAININGSET_NOTFOUND_ERR);
            return;
        }
        File trainingsetSpec = new File(params[1]);
        if (!trainingsetSpec.exists()) {
            LOGGER.error(TRAININGSET_SPEC_NOTFOUND_ERR);
            return;
        }
        File model = new File(params[2]);
        try {
            if (model.exists()) {
                Files.delete(model.toPath());
            }
            if (!model.createNewFile()) {
                LOGGER.error(MODEL_FILE_NOTFOUND_ERR);
                return;
            }
            Classifiers classifiersFactory = new Classifiers(params[3]);
            IClassifier classifier = classifiersFactory.getClassifier(params[4]);
            try (BufferedInputStream trainingStream = new BufferedInputStream(new FileInputStream(trainingset));
                 BufferedInputStream trainingSpecStream = new BufferedInputStream(new FileInputStream(trainingsetSpec));
                 BufferedOutputStream modelStream = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(model)));){
                ModelGenerator.generate(modelStream, classifiersFactory, classifier, trainingStream, trainingSpecStream);
            }
        }
        catch (IOException e) {
            LOGGER.error(e.toString());
        }
    }
}

