/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.recommenders.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.icu.text.MessageFormat;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VisNLGUtils {
    static final String NLG_CODE = "/nlg/nlg_code.json";

    private VisNLGUtils() {
    }

    public static ChartNLGCode loadNLGCode() throws IOException {
        InputStream stream = VisNLGUtils.class.getResourceAsStream(NLG_CODE);
        return (ChartNLGCode)JsonParserHelper.parseJson((JsonNode)JsonParserHelper.getJsonFromStream((InputStream)stream), ChartNLGCode.class);
    }

    public static Map<String, String> flattenParameters(Map<String, List<String>> parameters) {
        HashMap<String, String> p = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            for (int i = 0; i < entry.getValue().size(); ++i) {
                builder.append(entry.getValue().get(i));
                if (i >= entry.getValue().size() - 1) continue;
                builder.append(", ");
            }
            p.put(entry.getKey(), builder.toString());
            builder.setLength(0);
        }
        return p;
    }

    public static String removeUnusedParameters(String str, Map<String, List<String>> parameters) {
        Pattern pattern = Pattern.compile("\\{\\{(\\w*)\\}\\}");
        String s = str;
        Matcher m = pattern.matcher(str);
        while (m.find()) {
            String p = m.group();
            String pname = p.replaceAll("\\{\\{", "").replaceAll("\\}\\}", "");
            if (parameters.get(pname) == null) {
                s = s.replace(p, "");
                continue;
            }
            s = s.replace(p, "{" + pname + "}");
        }
        return s;
    }

    public static String addMatrix(String title, Map<String, List<String>> parameters, ResourceBundle bundle) {
        String matrixColumn = "MATRIX_COLUMN";
        String matrixRow = "MATRIX_ROW";
        String matrixColumnStringId = "IDS_MATRIX_COLUMN";
        String matrixColumnRowStringId = "IDS_MATRIX_COLUMN_ROW";
        if (parameters.containsKey("MATRIX_COLUMN") && parameters.containsKey("MATRIX_ROW")) {
            String matrix = VisNLGUtils.removeUnusedParameters(bundle.getString("IDS_MATRIX_COLUMN_ROW"), parameters);
            MessageFormat m = new MessageFormat(matrix, bundle.getLocale());
            return title + m.format(VisNLGUtils.flattenParameters(parameters));
        }
        if (parameters.containsKey("MATRIX_COLUMN")) {
            String matrix = VisNLGUtils.removeUnusedParameters(bundle.getString("IDS_MATRIX_COLUMN"), parameters);
            MessageFormat m = new MessageFormat(matrix, bundle.getLocale());
            return title + m.format(VisNLGUtils.flattenParameters(parameters));
        }
        return title;
    }
}

