/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.recommenders.core.utils;

import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.FilterTypeConversionException;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartConcepts;
import com.ibm.smarts.visualization.recommender.internal.modeling.AxisType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class VisRecommenderUtils {
    private static final int COMBINATION_LIMIT = 256;

    private VisRecommenderUtils() {
    }

    public static <T> List<List<T>> cartesianProduct(List<List<T>> lists) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        if (lists.isEmpty()) {
            results.add(new ArrayList());
            return results;
        }
        VisRecommenderUtils.reduceConceptsInList(lists);
        List<T> first = lists.get(0);
        List<List<T>> innerProducts = VisRecommenderUtils.cartesianProduct(lists.subList(1, lists.size()));
        for (T element : first) {
            for (List<T> product : innerProducts) {
                ArrayList<T> result = new ArrayList<T>();
                result.add(element);
                result.addAll(product);
                results.add(result);
            }
        }
        return results;
    }

    private static <T> void reduceConceptsInList(List<List<T>> lists) {
        int totalCalls = 1;
        for (List concepts : lists) {
            if ((totalCalls *= concepts.size()) <= 256 || concepts.size() <= 1 || concepts.get(0) == null) continue;
            concepts.removeIf(f -> !f.equals(concepts.get(0)));
        }
    }

    private static List<AxisType> assignToAxis(int numberOfFeattures, List<AxisType> avail, List<AxisType> prefered) {
        List preferedAndAvailable = prefered.stream().filter(avail::contains).collect(Collectors.toList());
        return IntStream.range(0, numberOfFeattures).boxed().map(i -> {
            if (!preferedAndAvailable.isEmpty()) {
                AxisType t = (AxisType)((Object)((Object)preferedAndAvailable.remove(0)));
                avail.remove((Object)t);
                return t;
            }
            if (!avail.isEmpty()) {
                return (AxisType)((Object)((Object)avail.remove(0)));
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Map<FeatureType, List<AxisType>> mapFeaturesOnAxes(int numberOfCategories, int numberOfMeasures) {
        EnumMap<FeatureType, List<AxisType>> mappings = new EnumMap<FeatureType, List<AxisType>>(FeatureType.class);
        ArrayList<AxisType> avail = new ArrayList<AxisType>();
        avail.add(AxisType.X);
        avail.add(AxisType.Y);
        avail.add(AxisType.SERIES);
        avail.add(AxisType.SIZE);
        mappings.put(FeatureType.CATEGORY, VisRecommenderUtils.assignToAxis(numberOfCategories, avail, Arrays.asList(AxisType.X, AxisType.SERIES)));
        mappings.put(FeatureType.MEASURE, VisRecommenderUtils.assignToAxis(numberOfMeasures, avail, Arrays.asList(AxisType.Y, AxisType.SIZE)));
        return mappings;
    }

    public static Map<String, String> getColumnIdNameMap(Set<IDataColumn> columns) {
        return columns.stream().collect(Collectors.toMap(IDataColumn::getIdForExpression, IDataColumn::getName, (c1, c2) -> c1));
    }

    public static Pair<String, String> getColsWithPlannedActualConcept(LogicalGroup lg) {
        boolean isPlanned = false;
        boolean isActual = false;
        String actualColumn = null;
        String plannedColumn = null;
        for (LogicalGroup.Member m : lg.getMember()) {
            String memberConcept = m.getAttribute().getConceptID();
            if (memberConcept.equals(StdChartConcepts.PLANNED.getId())) {
                isPlanned = true;
                plannedColumn = m.getIdForExpression();
                continue;
            }
            if (!memberConcept.equals(StdChartConcepts.ACTUAL.getId())) continue;
            isActual = true;
            actualColumn = m.getIdForExpression();
        }
        return isPlanned && isActual ? new Pair<Object, Object>(actualColumn, plannedColumn) : null;
    }

    public static Map<String, TopBottomFilter> getFiltersTopBottomFilters(List<BaseFilter> baseFilters) {
        if (baseFilters == null) {
            return Collections.emptyMap();
        }
        return baseFilters.stream().filter(bf -> bf.getType().equals((Object)FilterType.TOP_BOTTOM)).map(bf -> {
            try {
                return bf.toTopBottomFilter();
            }
            catch (FilterTypeConversionException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(f -> f.getColumnId(), f -> f, (f1, f2) -> f1));
    }

    public static Map<String, InclusionExclusionFilter> getFiltersInclusionExclusionFilters(List<BaseFilter> baseFilters) {
        if (baseFilters == null) {
            return Collections.emptyMap();
        }
        return baseFilters.stream().filter(bf -> bf.getType().equals((Object)FilterType.INCLUSION_EXCLUSION)).map(bf -> {
            try {
                return bf.toInclusionExclusionFilter();
            }
            catch (FilterTypeConversionException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(f -> f.getColumnId(), f -> f, (f1, f2) -> f1));
    }

    public static List<LogicalGroup> getAggregatedLogicalGroups(SmartsModule smartsModule) {
        return Stream.concat(smartsModule.getDatasets().stream().flatMap(ds -> ds.getLogicalGroups().stream()), smartsModule.getLogicalGroups().stream()).collect(Collectors.toList());
    }

    public static AggregationType getAggregationForColumn(IDataColumn column, Map<String, AggregationType> aggregationMap) {
        AggregationType aggregation = AggregationType.NONE;
        if (aggregationMap.get(column.getIdForExpression()) != null) {
            aggregation = aggregationMap.get(column.getIdForExpression());
        } else if (column.getSemanticInfo() != null) {
            aggregation = column.getSemanticInfo().getDefaultAggregation();
        }
        return aggregation;
    }

    public static List<String> getHiddenIdsFromItems(List<ItemType> hiddenItems) {
        return hiddenItems.stream().map(itemType -> {
            if (itemType.getQueryItem() != null) {
                return itemType.getQueryItem().getIdForExpression();
            }
            if (itemType.getNamedSet() != null) {
                return itemType.getNamedSet().getIdForExpression();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Map<String, ItemType> getIdToHiddenItemMap(List<ItemType> hiddenItems) {
        return hiddenItems.stream().collect(Collectors.toMap(k -> {
            if (k.getQueryItem() != null) {
                return k.getQueryItem().getIdForExpression();
            }
            if (k.getNamedSet() != null) {
                return k.getNamedSet().getIdForExpression();
            }
            return "";
        }, v -> v, (a, b) -> a));
    }

    public static enum FeatureType {
        CATEGORY,
        MEASURE;

    }
}

