/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.ibm.smarts.common.learning.Sentiment;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRecommendedVisualization
implements IRecommendedVisualization {
    static final Logger LOGGER = LoggerFactory.getLogger(BaseRecommendedVisualization.class);
    protected String label;
    protected double score;
    protected int rank = -1;
    protected List<Binding> columnBinding = new ArrayList<Binding>();
    protected Locale locale;
    protected String combinationId;
    protected Sentiment sentiment = Sentiment.NONE;
    protected String naturalLanguageLabel = "";
    protected String naturalLanguageTitle = "";
    protected String naturalLanguageDescription = "";

    public BaseRecommendedVisualization(String label, double score, int rank, String combinationId) {
        this.label = label;
        this.score = score;
        this.rank = rank;
        this.combinationId = combinationId;
    }

    public BaseRecommendedVisualization(String label, double score, String combinationId) {
        this.label = label;
        this.score = score;
        this.combinationId = combinationId;
    }

    public BaseRecommendedVisualization(BaseRecommendedVisualization other) {
        this.label = other.label;
        this.score = other.score;
        this.rank = other.rank;
        this.columnBinding = other.columnBinding;
        this.combinationId = other.combinationId;
        this.naturalLanguageLabel = other.naturalLanguageLabel;
        this.naturalLanguageTitle = other.naturalLanguageTitle;
        this.naturalLanguageDescription = other.naturalLanguageDescription;
    }

    public BaseRecommendedVisualization(BaseRecommendedVisualization other, double score, int rank) {
        this(other);
        this.score = score;
        this.rank = rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setColumnBindings(List<Binding> bindings) {
        this.columnBinding.addAll(bindings);
    }

    public String getLabel() {
        return this.label;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getCombintaionId() {
        return this.combinationId;
    }

    public List<Binding> getColumnBindings() {
        return this.columnBinding;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean isMatrix() {
        return false;
    }

    public String getNaturalLanguageLabel() {
        return this.naturalLanguageLabel;
    }

    public String getNaturalLanguageTitle() {
        return this.naturalLanguageTitle;
    }

    public String getNaturalLanguageDescription() {
        return this.naturalLanguageDescription;
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }

    public void setSentiment(Sentiment sentiment) {
        this.sentiment = sentiment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseRecommendedVisualization)) {
            return false;
        }
        BaseRecommendedVisualization that = (BaseRecommendedVisualization)o;
        return Double.compare(that.getScore(), this.getScore()) == 0 && this.getRank() == that.getRank() && Objects.equals(this.getLabel(), that.getLabel()) && Objects.equals(this.columnBinding, that.columnBinding) && Objects.equals(this.locale, that.locale) && Objects.equals(this.combinationId, that.combinationId) && this.getSentiment() == that.getSentiment() && Objects.equals(this.getNaturalLanguageLabel(), that.getNaturalLanguageLabel()) && Objects.equals(this.getNaturalLanguageTitle(), that.getNaturalLanguageTitle()) && Objects.equals(this.getNaturalLanguageDescription(), that.getNaturalLanguageDescription());
    }

    public int hashCode() {
        return Objects.hash(this.getLabel(), this.getScore(), this.getRank(), this.columnBinding, this.locale, this.combinationId, this.getSentiment(), this.getNaturalLanguageLabel(), this.getNaturalLanguageTitle(), this.getNaturalLanguageDescription());
    }

    public void setNaturalLanguage(String label, String title, String description, Locale loc) {
        this.naturalLanguageLabel = label;
        this.naturalLanguageTitle = title;
        this.naturalLanguageDescription = description;
        this.locale = loc;
    }

    public String toString() {
        return "BaseRecommendedVisualization{label='" + this.label + '\'' + ", score=" + this.score + ", rank=" + this.rank + ", columnBinding=" + this.columnBinding + ", locale=" + this.locale + ", combinationId='" + this.combinationId + '\'' + ", sentiment=" + this.sentiment + ", naturalLanguageLabel='" + this.naturalLanguageLabel + '\'' + ", naturalLanguageTitle='" + this.naturalLanguageTitle + '\'' + ", naturalLanguageDescription='" + this.naturalLanguageDescription + '\'' + '}';
    }
}

