/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.ibm.smarts.recommenders.core.utils.VisNLGUtils;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGCode;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGCodeElement;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGParameters;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGUtils;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartDescriptionGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartDescriptionGenerator.class);
    private static String RESOURCE_BUNDLE = "strings.visRecommenderStrings";
    private static String IDS_MISSING_MANDATORY_SLOTS = "IDS_MANDATORY_MISSING_SLOTS";
    private static ChartNLGCode nlgCode;

    private ChartDescriptionGenerator() {
    }

    public static ChartDescription generateNaturalLanguage(Locale locale, IChartDescriptor chart, List<ExtractedFeatureSet> features, List<Binding> columnBinding, Map<String, String> mapColumnIdForExpressionToColumnName, boolean missingMandatorySlots) {
        Map<String, List<String>> parameters = ChartDescriptionGenerator.getNamedParameters(columnBinding, mapColumnIdForExpressionToColumnName);
        if (nlgCode == null || !ChartNLGUtils.NLGSupported(locale)) {
            return ChartDescriptionGenerator.legacyChartDescription(chart, parameters, locale, features, missingMandatorySlots);
        }
        Optional<ChartNLGCodeElement> pattern = ChartDescriptionGenerator.getMatchingPattern(columnBinding);
        if (!pattern.isPresent()) {
            return ChartDescriptionGenerator.legacyChartDescription(chart, parameters, locale, features, missingMandatorySlots);
        }
        try {
            Optional<ChartDescription> des = ChartNLGUtils.generateChartDescription(new ChartNLGParameters(chart.getName(), pattern.get()), features, parameters, mapColumnIdForExpressionToColumnName, locale);
            if (!des.isPresent()) {
                return ChartDescriptionGenerator.legacyChartDescription(chart, parameters, locale, features, missingMandatorySlots);
            }
            return des.get();
        }
        catch (Exception e) {
            LOGGER.error("Error encountered while processing NLG visualization strings.", (Throwable)e);
            return ChartDescriptionGenerator.legacyChartDescription(chart, parameters, locale, features, missingMandatorySlots);
        }
    }

    public static Optional<ChartNLGCodeElement> getMatchingPattern(List<Binding> bindings) {
        if (nlgCode == null) {
            return Optional.empty();
        }
        boolean foundPattern = false;
        for (int i = 0; i < nlgCode.getPatterns().size() && !foundPattern; ++i) {
            ChartNLGCodeElement pattern = nlgCode.getPatterns().get(i);
            List<String> slots = pattern.getSlots();
            if ((long)slots.size() != bindings.stream().map(b -> b.getSlot()).distinct().count()) continue;
            ArrayList<String> testSlotNames = new ArrayList<String>();
            for (String slotTest : slots) {
                testSlotNames.addAll(Arrays.asList(slotTest.split("\\|")));
            }
            foundPattern = true;
            for (Binding binding : bindings) {
                if (testSlotNames.contains(binding.getSlot())) continue;
                foundPattern = false;
                break;
            }
            if (!foundPattern) continue;
            return Optional.of(pattern);
        }
        return Optional.empty();
    }

    public static Map<String, List<String>> getNamedParameters(List<Binding> bindings, Map<String, String> idToName) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (Binding binding : bindings) {
            if (binding.getColumns().isEmpty()) continue;
            LinkedList<String> s = new LinkedList<String>();
            for (String c : binding.getColumns()) {
                String columnName = idToName.get(c);
                if (columnName != null) {
                    s.add(columnName);
                    continue;
                }
                s.add(c);
            }
            if (parameters.containsKey(binding.getSlot())) {
                s.addAll((Collection)parameters.get(binding.getSlot()));
            }
            parameters.put(binding.getSlot(), s);
        }
        parameters.putAll(ChartDescriptionGenerator.getSpecialParameters(bindings, idToName));
        return parameters;
    }

    public static Map<String, List<String>> getSpecialParameters(List<Binding> columnBinding, Map<String, String> mapColumnIdForExpressionToColumnName) {
        String ALL = "_ALL";
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("_ALL", columnBinding.stream().flatMap(b -> b.getColumns().stream().map(mapColumnIdForExpressionToColumnName::get)).filter(Objects::nonNull).collect(Collectors.toList()));
        return parameters;
    }

    public static String getMandatorySlotsMissing(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        return bundle.getString(IDS_MISSING_MANDATORY_SLOTS);
    }

    private static ChartDescription legacyChartDescription(IChartDescriptor chart, Map<String, List<String>> parameters, Locale locale, List<ExtractedFeatureSet> features, boolean missingMandatorySlots) {
        String missing = ChartDescriptionGenerator.getMandatorySlotsMissing(locale);
        String naturalLanguageLabel = missingMandatorySlots ? missing : chart.getLabel(parameters, locale);
        String naturalLanguageTitle = missingMandatorySlots ? missing : chart.getTitle(parameters, locale);
        String naturalLanguageDescription = missingMandatorySlots ? missing : chart.getDescription(parameters, features, locale);
        return new ChartDescription(naturalLanguageLabel, naturalLanguageTitle, naturalLanguageDescription, locale);
    }

    static {
        try {
            nlgCode = VisNLGUtils.loadNLGCode();
        }
        catch (IOException e) {
            LOGGER.error("Could not load NLG code file. Using defaults.");
        }
    }
}

