/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.generated.parser.ParseException;
import com.ibm.smarts.nlg.api.ISmartsNLGRealiser;
import com.ibm.smarts.nlg.api.SmartsNLGFactory;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGCodeElement;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGParameters;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartNLGProp;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureExtracter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartNLGUtils {
    static final ISmartsNLGRealiser realiser = SmartsNLGFactory.createRealiser();
    private static final Logger LOGGER = LoggerFactory.getLogger(ChartNLGUtils.class);
    static final String NLG_CODE_STRINGS = "strings.nlgRecommender";
    static final String IDS_DES_SHOW = "IDS_DES_SHOW";
    static final String IDS_DES_MEASURES = "IDS_DES_MEASURES";
    static final String IDS_DES_CATEGORIES = "IDS_DES_CATEGORIES";
    static final String IDS_DES_LOCATIONS = "IDS_DES_LOCATIONS";
    static final String IDS_DES_DATES = "IDS_DES_DATES";
    static final String IDS_DES_NULLS = "IDS_DES_NULLS";
    static final String IDS_DES_HIGHVARIANCE = "IDS_DES_HIGHVARIANCE";
    static final String IDS_DES_POSITIVE = "IDS_DES_POSITIVE";
    static final String IDS_CHART_TYPE = "CHART_TYPE";
    static final String CHART_TYPE_PREFIX = "IDS_CHART_TYPE_";
    static final String LANG_EN = "en";

    private ChartNLGUtils() {
    }

    private static String resolveLabelOrTitle(ChartNLGProp nlgProp, Map<String, List<String>> values) throws ParseException {
        List<List<String>> parameters = nlgProp.getParameters(values);
        return realiser.realise(nlgProp.getText(), new Object[]{parameters});
    }

    public static String generateDescription(List<ExtractedFeatureSet> features, Map<String, String> idToName, ResourceBundle bundle) throws ParseException {
        StringBuilder description = new StringBuilder();
        HashSet<String> allFields = new HashSet<String>();
        HashSet<String> nullFields = new HashSet<String>();
        HashSet<String> measureFields = new HashSet<String>();
        HashSet<String> categoryFields = new HashSet<String>();
        HashSet<String> dateFields = new HashSet<String>();
        HashSet<String> locationFields = new HashSet<String>();
        HashSet<String> highVarianceFields = new HashSet<String>();
        HashSet<String> positiveFields = new HashSet<String>();
        features.forEach(f -> {
            allFields.add((String)idToName.get(f.getColumnId()));
            if (f.isNullable()) {
                nullFields.add((String)idToName.get(f.getColumnId()));
            }
            if (f.getFeatureType() == BasicType.MEASURE) {
                measureFields.add((String)idToName.get(f.getColumnId()));
            }
            if (f.getFeatureType() == BasicType.CATEGORY) {
                categoryFields.add((String)idToName.get(f.getColumnId()));
            }
            if (f.getFeatureType() == BasicType.DATE) {
                dateFields.add((String)idToName.get(f.getColumnId()));
            }
            if (f.getFeatureType() == BasicType.LOCATION) {
                locationFields.add((String)idToName.get(f.getColumnId()));
            }
            if (f.isHighVariance()) {
                highVarianceFields.add((String)idToName.get(f.getColumnId()));
            }
            if (f.isPositive()) {
                positiveFields.add((String)idToName.get(f.getColumnId()));
            }
        });
        description.append(ChartNLGUtils.realiseNLG(bundle.getString(IDS_DES_SHOW), ChartNLGUtils.getDescriptionArgs(allFields)));
        if (!measureFields.isEmpty()) {
            description.append(" ");
            description.append(realiser.realise(bundle.getString(IDS_DES_MEASURES), ChartNLGUtils.getDescriptionArgs(measureFields)));
        }
        if (!categoryFields.isEmpty()) {
            description.append(" ");
            description.append(realiser.realise(bundle.getString(IDS_DES_CATEGORIES), ChartNLGUtils.getDescriptionArgs(categoryFields)));
        }
        if (!dateFields.isEmpty()) {
            description.append(" ");
            description.append(realiser.realise(bundle.getString(IDS_DES_DATES), ChartNLGUtils.getDescriptionArgs(dateFields)));
        }
        if (!locationFields.isEmpty()) {
            description.append(" ");
            description.append(realiser.realise(bundle.getString(IDS_DES_LOCATIONS), ChartNLGUtils.getDescriptionArgs(locationFields)));
        }
        if (!nullFields.isEmpty()) {
            description.append(" ");
            description.append(realiser.realise(bundle.getString(IDS_DES_NULLS), ChartNLGUtils.getDescriptionArgs(nullFields)));
        }
        if (!positiveFields.isEmpty()) {
            description.append(" ");
            description.append(realiser.realise(bundle.getString(IDS_DES_POSITIVE), ChartNLGUtils.getDescriptionArgs(positiveFields)));
        }
        if (!highVarianceFields.isEmpty()) {
            description.append(" ");
            description.append(realiser.realise(bundle.getString(IDS_DES_HIGHVARIANCE), ChartNLGUtils.getDescriptionArgs(highVarianceFields)));
        }
        return description.toString();
    }

    public static String realiseNLG(String code, List<Object> params) {
        String s = null;
        try {
            s = realiser.realise(code, params);
        }
        catch (ParseException e) {
            LOGGER.error("ParsingException realising string: " + code, (Throwable)e);
        }
        return s;
    }

    public static Optional<ChartDescription> generateChartDescription(ChartNLGParameters nlgParams, List<ExtractedFeatureSet> features, Map<String, List<String>> parameters, Map<String, String> idToName, Locale locale) {
        String chartName = nlgParams.getChartName();
        ChartNLGCodeElement pattern = nlgParams.getPattern();
        if (pattern != null) {
            ResourceBundle bundle = ResourceBundle.getBundle(NLG_CODE_STRINGS, locale);
            try {
                ArrayList<String> s = new ArrayList<String>();
                s.add(bundle.getString(CHART_TYPE_PREFIX + chartName));
                parameters.put(IDS_CHART_TYPE, s);
                String label = ChartNLGUtils.resolveLabelOrTitle(pattern.getLabel(), parameters);
                String title = ChartNLGUtils.resolveLabelOrTitle(pattern.getTitle(), parameters);
                String description = ChartNLGUtils.generateDescription(features, idToName, bundle);
                return Optional.of(new ChartDescription(label, title, description, locale));
            }
            catch (Exception e) {
                LOGGER.error("Error encountered while processes NLG visualization strings for chart: " + chartName, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public static boolean NLGSupported(Locale locale) {
        return locale != null && locale.getLanguage().equals(LANG_EN);
    }

    public static List<ExtractedFeatureSet> getFeaturesForDescription(List<IDataColumn> columns) {
        EnumMap<BindingParams, Double> bindingParams = new EnumMap<BindingParams, Double>(BindingParams.class);
        FeatureExtracter extracter = new FeatureExtracter(columns);
        try {
            extracter.extractFeatures(bindingParams, Function.identity(), true, Collections.emptyList(), false);
        }
        catch (InvalidColumnInfoException e) {
            LOGGER.error("Failed to extract features for chart description.", (Throwable)e);
            return Collections.emptyList();
        }
        List<List<ExtractedFeatureSet>> llFeatures = extracter.getFeatures();
        if (llFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        return extracter.getFeatures().get(0);
    }

    private static List<List<String>> getSimpleParameters(String chartName, List<ExtractedFeatureSet> features, Map<String, String> idToName) {
        ArrayList<List<String>> l = new ArrayList<List<String>>();
        if (chartName != null) {
            l.add(Collections.singletonList(chartName));
        }
        HashSet fieldNames = new HashSet();
        features.forEach(f -> fieldNames.add(idToName.get(f.getColumnId())));
        l.add(new ArrayList(fieldNames));
        return l;
    }

    private static List<Object> getDescriptionArgs(Set<String> fields) {
        ArrayList<String> list = new ArrayList<String>(fields);
        ArrayList<Object> listOfLists = new ArrayList<Object>();
        listOfLists.add(list);
        return listOfLists;
    }
}

