/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.exceptions.ImpossibleBindingException;
import com.ibm.smarts.visualization.recommender.internal.BaseRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartDescriptionGenerator;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.ModelChartDescriptor;
import com.ibm.smarts.visualization.recommender.schema.AutoGrouping;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecommendedVisualization
extends BaseRecommendedVisualization {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecommendedVisualization.class);
    private List<ExtractedFeatureSet> features = new ArrayList<ExtractedFeatureSet>();
    private ModelChartDescriptor desc;
    private boolean isMatrix = false;
    private Map<String, AutoGrouping> autoGroupingMap = new HashMap<String, AutoGrouping>();
    private Map<String, AggregationType> aggregationMap = new HashMap<String, AggregationType>();
    private List<BaseFilter> baseFilterList = new ArrayList<BaseFilter>();

    public RecommendedVisualization(String label, double score, int rank, List<ExtractedFeatureSet> features, String combinationId) {
        super(label, score, rank, combinationId);
        this.collectExtras();
        this.features.addAll(features.stream().map(ExtractedFeatureSet::new).collect(Collectors.toList()));
    }

    public RecommendedVisualization(String label, double score, int rank, List<ExtractedFeatureSet> features, String combinationId, List<Binding> columnBinding) {
        super(label, score, rank, combinationId);
        this.features.addAll(features.stream().map(ExtractedFeatureSet::new).collect(Collectors.toList()));
        this.collectExtras();
        this.columnBinding = columnBinding.stream().collect(Collectors.toList());
    }

    public RecommendedVisualization(String label, double score, List<ExtractedFeatureSet> features, String combinationId, List<BaseFilter> filters) {
        this(label, score, features, combinationId, filters, Collections.emptyMap());
    }

    public RecommendedVisualization(String label, double score, List<ExtractedFeatureSet> features, String combinationId, List<BaseFilter> filters, Map<String, AggregationType> aggregationMap) {
        super(label, score, combinationId);
        this.features.addAll(features.stream().map(ExtractedFeatureSet::new).collect(Collectors.toList()));
        this.aggregationMap = aggregationMap;
        this.collectExtras();
    }

    public RecommendedVisualization(RecommendedVisualization other, double score, int rank) {
        super(other);
        this.features.addAll(other.features.stream().map(ExtractedFeatureSet::new).collect(Collectors.toList()));
        this.collectExtras();
        this.desc = other.desc;
        this.isMatrix = other.isMatrix;
        this.score = score;
        this.rank = rank;
        this.aggregationMap = other.aggregationMap;
    }

    public RecommendedVisualization(RecommendedVisualization other, List<Binding> columnBinding, double score, int rank) {
        super(other);
        this.features.addAll(other.features.stream().map(ExtractedFeatureSet::new).collect(Collectors.toList()));
        this.collectExtras();
        this.desc = other.desc;
        this.isMatrix = other.isMatrix;
        this.score = score;
        this.rank = rank;
        this.columnBinding = columnBinding.stream().collect(Collectors.toList());
        this.aggregationMap = other.aggregationMap;
    }

    private void collectExtras() {
        for (ExtractedFeatureSet feature : this.features) {
            if (feature.getGrouping() != null) {
                this.autoGroupingMap.put(feature.getColumnId(), feature.getGrouping());
            }
            feature.getFilters().forEach(f -> {
                if (!this.baseFilterList.contains(f)) {
                    this.baseFilterList.add((BaseFilter)f);
                }
            });
        }
    }

    public List<ExtractedFeatureSet> getFeatures() {
        return this.features;
    }

    public boolean hasConcepts() {
        return this.features.stream().anyMatch(f -> !f.getConcept().equals("NONE"));
    }

    public void bind() {
        ModelChartDescriptor bound = this.getChartDescriptor();
        if (bound == null || this.getFeatures().isEmpty()) {
            throw new IllegalStateException("Invalid recommendation missing Chart descriptor " + this);
        }
        Optional<ExtractedFeatureSet> featureSetsWithHierarchy = this.getFeatures().stream().filter(f -> f.getColumn().isHierchical()).findAny();
        if (!bound.getHighLevelDescriptor().acceptsHierarchicalColumns() && featureSetsWithHierarchy.isPresent()) {
            return;
        }
        try {
            List<Binding> columnBindings = bound.getHighLevelDescriptor().bindChartElements(this.getFeatures());
            if (columnBindings.isEmpty()) {
                LOGGER.debug("Recommendation with invalid feature binding- combinationId: " + this.getCombintaionId() + "Label: " + this.getLabel());
            } else {
                this.setColumnBindings(columnBindings);
            }
        }
        catch (ImpossibleBindingException exc) {
            LOGGER.debug("Recommendation with invalid feature binding- combinationId: " + this.getCombintaionId() + "Label: " + this.getLabel() + "Exception: " + exc);
            this.columnBinding.clear();
        }
    }

    public Stream<RecommendedVisualization> validateAndSetChartDesc(List<ModelChartDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            LOGGER.debug("recommendation with no corresponding chart {}", (Object)this);
            return null;
        }
        return descriptors.stream().filter(d -> d.validate(this)).map(v -> {
            RecommendedVisualization r = new RecommendedVisualization(this, Collections.emptyList(), this.score, this.rank);
            r.setChartDescriptor((ModelChartDescriptor)v);
            v.updateScore(r);
            return r;
        });
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    public ModelChartDescriptor getChartDescriptor() {
        return this.desc;
    }

    public void setChartDescriptor(ModelChartDescriptor desc) {
        this.desc = desc;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.isMatrix ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecommendedVisualization other = (RecommendedVisualization)obj;
        if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
            return false;
        }
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        return this.isMatrix == other.isMatrix;
    }

    @Override
    public String toString() {
        return "RecommendedVisualization[" + super.toString() + "features=" + this.features + ", desc=" + this.desc + ", isMatrix=" + this.isMatrix + "]";
    }

    public void setMatrixFlag(boolean flag) {
        this.isMatrix = flag;
    }

    @Override
    public boolean isMatrix() {
        return this.isMatrix;
    }

    public Map<String, AutoGrouping> getAutoGrouping() {
        return this.autoGroupingMap;
    }

    public Map<String, TopBottomFilter> getTopBottomFilters() {
        return VisRecommenderUtils.getFiltersTopBottomFilters(this.baseFilterList);
    }

    public Map<String, InclusionExclusionFilter> getInclusionExclusionFilters() {
        return VisRecommenderUtils.getFiltersInclusionExclusionFilters(this.baseFilterList);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void generateNaturalLanguage(Locale locale, Map<String, String> mapColumnIdForExpresionToColumnName) {
        ChartDescription description = ChartDescriptionGenerator.generateNaturalLanguage(locale, this.desc.getHighLevelDescriptor(), this.features, this.columnBinding, mapColumnIdForExpresionToColumnName, false);
        this.naturalLanguageLabel = description.getLabel();
        this.naturalLanguageTitle = description.getTitle();
        this.naturalLanguageDescription = description.getDescription();
        this.locale = locale;
    }

    public List<BaseFilter> getBaseFilterList() {
        return this.baseFilterList;
    }

    public void setBaseFilterList(List<BaseFilter> baseFilterList) {
        this.baseFilterList = baseFilterList;
    }

    public Map<String, AggregationType> getAggregationMap() {
        return this.aggregationMap;
    }

    public void setAggregationMap(Map<String, AggregationType> aggregationMap) {
        this.aggregationMap = aggregationMap;
    }
}

