/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.recommendationmodel.RecommendationModel;
import com.ibm.smarts.combinations.generator.api.CombinationGeneratorFactory;
import com.ibm.smarts.combinations.generator.api.FilterFactory;
import com.ibm.smarts.combinations.generator.api.ICombinationGenerator;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.combinations.generator.api.IDataGroup;
import com.ibm.smarts.combinations.generator.api.IFilter;
import com.ibm.smarts.combinations.generator.exceptions.ColumnNotFoundException;
import com.ibm.smarts.combinations.generator.internal.DataColumn;
import com.ibm.smarts.combinations.generator.util.GeneratorUtils;
import com.ibm.smarts.common.learning.Sentiment;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterType;
import com.ibm.smarts.common.modifiers.InclusionExclusionFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.fields.recommender.api.InterestingFieldsRecommender;
import com.ibm.smarts.generic.recommender.api.java.classifiers.ClassifierException;
import com.ibm.smarts.generic.recommender.api.java.classifiers.Classifiers;
import com.ibm.smarts.generic.recommender.api.java.classifiers.IClassifier;
import com.ibm.smarts.generic.recommender.internal.raw.impl.classifiers.datalayer.GenericTransformerException;
import com.ibm.smarts.model.common.util.ModuleDataTypeUtil;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.model.datatype.DataTypes;
import com.ibm.smarts.recommenders.core.utils.ChartDescriptorLoader;
import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBaseChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IChartElementTypesProvider;
import com.ibm.smarts.visualization.recommender.api.IExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IVisualizationRecommender;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.exceptions.ChartDescriptorLoaderException;
import com.ibm.smarts.visualization.recommender.exceptions.ImpossibleBindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InitializationException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidChartDescriptor;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.exceptions.LearningException;
import com.ibm.smarts.visualization.recommender.exceptions.RecommendationException;
import com.ibm.smarts.visualization.recommender.exceptions.UnknownChartException;
import com.ibm.smarts.visualization.recommender.exceptions.VisRecommenderWrapperException;
import com.ibm.smarts.visualization.recommender.internal.BaseRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.ChartCompatabilityMapper;
import com.ibm.smarts.visualization.recommender.internal.ChartDescriptorRegistery;
import com.ibm.smarts.visualization.recommender.internal.ChartRankings;
import com.ibm.smarts.visualization.recommender.internal.CompatibleChartsForBindingSets;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.LabelChartsMapper;
import com.ibm.smarts.visualization.recommender.internal.NLGProperties;
import com.ibm.smarts.visualization.recommender.internal.RecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.VisualizationMatrixer;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementType;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementTypes;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartConcepts;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.AutoGroupingAllMeasure;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.ConvertCategoryAdapter;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.DualColumnsAdaptor;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.FilterApplicator;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.TopBottomFilterApplicator;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.TopBottomFilterCategoryHighDomain;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.TwinCategoryAdapter;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.TwoCategoryAdapter;
import com.ibm.smarts.visualization.recommender.internal.learning.ChartPreferenceContext;
import com.ibm.smarts.visualization.recommender.internal.learning.LearningUtils;
import com.ibm.smarts.visualization.recommender.internal.learning.PreferenceRecommender;
import com.ibm.smarts.visualization.recommender.internal.learning.SpecAnalyserAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureBinding;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureExtracter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ModelChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.modeling.ModelFeaturesBinder;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartBinder;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartConceptScoreAdjuster;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartDecomposer;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartHeatmapScoreAdjuster;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartRanker;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartScoreFilter;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartValidator;
import com.ibm.smarts.visualization.recommender.internal.pipeline.NoneAggregationFilter;
import com.ibm.smarts.visualization.recommender.internal.pipeline.PredictChartFilter;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ScatterBubbleChartFilter;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.EXTRA_BEHAVIOR;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VisualizationRecommender
implements IVisualizationRecommender {
    public static final String CHART_SPEC_DIR = "/specs";
    public static final String CHART_TYPES_DIR = "/types";
    public static final String CHART_LIB_DIR = "/lib";
    public static final String CHART_COMPATIBILITY_FILE = "/configurations/ChartCompatibility.json";
    public static final String CHART_COLUMNS_COMPATIBILITY_FILE = "/configurations/CompatibleChartsForBindingSets.json";
    public static final String CHART_RANKING_FILE = "/configurations/ChartRanking.json";
    public static final String EXTERNAL_CHART_RANKING_FILE = "/configurations/ExternalChartRanking.json";
    public static final String CONFIG_ROOT = "/configurations/";
    public static final String ML_MODEL_FILE = "/configurations/ml_model";
    public static final String LABEL_MAP_FILE = "/configurations/labelMappings.json";
    public static final String STD_EXTERNAL_CHARTS_PATH = "/external_charts";
    public static final int DEFAULT_NUMBER_OF_RECOMMENDATIONS = 20;
    private static final String UNEXPECTED_EXCEPTION = "Unexpected exception {}";
    private static final ArrayList<EXTRA_BEHAVIOR> noBehaviors = new ArrayList();
    private static final List<String> MULTI_MEASURE_IDS = Arrays.asList("_multiMeasuresValue", "_multiMeasuresSeries");
    public static final int DEFAULT_TOP_BOTTOM_DOMAIN_SIZE = 10;
    private static final String KPI = "KPI";
    private Map<BindingParams, Double> bindingParams = new EnumMap<BindingParams, Double>(BindingParams.class);
    private IClassifier classifier;
    private final Properties config;
    private Classifiers classifiersFactory;
    private Function<Pair<Stream<RecommendedVisualization>, VisualizationParameters>, Pair<Stream<RecommendedVisualization>, VisualizationParameters>> pipeline;
    private Map<String, List<ModelChartDescriptor>> modelChartDescMap = new HashMap<String, List<ModelChartDescriptor>>();
    private Map<String, List<IChartDescriptor>> chartDescMap = new HashMap<String, List<IChartDescriptor>>();
    private Map<String, List<IExternalChartDescriptor>> externalChartDescMap = new HashMap<String, List<IExternalChartDescriptor>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualizationRecommender.class);
    private ChartDescriptorRegistery<IExternalChartDescriptor> externalchartDescriptors = new ChartDescriptorRegistery();
    private LabelChartsMapper mapper;
    private ICombinationGenerator gen;
    private ChartCompatabilityMapper chartCompatibility;
    private CompatibleChartsForBindingSets compatibleChartsForBinding;
    private ChartRankings chartRankings;
    private ChartRankings externalChartRankings;
    private final List<String> matrixExcludedCharts;
    PreferenceRecommender prefRecommender;
    private InterestingFieldsRecommender fieldRecommender = null;

    public VisualizationRecommender(Properties config, InterestingFieldsRecommender fieldRecommender) throws InitializationException {
        try {
            noBehaviors.add(EXTRA_BEHAVIOR.NONE);
            this.config = config;
            this.matrixExcludedCharts = Arrays.asList(config.getProperty("smarts.visualization.recommender.matrixExcludedCharts").split(","));
            this.classifiersFactory = new Classifiers(config.getProperty("smarts.visualization.recommender.genericRecommenderImpl"));
            this.classifier = this.classifiersFactory.getClassifier(config.getProperty("smarts.visualization.recommender.mlClassifierType"));
            InputStream combStream = this.getClass().getResourceAsStream(config.getProperty("smarts.visualization.recommender.columnCombinationSpecFile"));
            this.gen = CombinationGeneratorFactory.createCombinationGenerator((InputStream)combStream, (int)Integer.parseInt(config.getProperty("smarts.visualization.recommender.combinatorThreadPoolSize")));
            this.readDefaultModel();
            this.readChartDescriptors();
            this.fieldRecommender = fieldRecommender;
            this.buildPipeline();
            this.prefRecommender = new PreferenceRecommender();
            double few_quantity_threshold = Double.valueOf(config.getProperty("smarts.visualization.recommender.featureQuantityFewThreshold"));
            double moderate_quantity_threshold = Double.valueOf(config.getProperty("smarts.visualization.recommender.featureQuantityModerateThreshold"));
            double concept_confidence_threshold = Double.valueOf(config.getProperty("smarts.visualization.recommender.conceptConfidenceThreshold"));
            this.bindingParams.put(BindingParams.QUANTITY_FEW_THRESHOLD, few_quantity_threshold);
            this.bindingParams.put(BindingParams.QUANTITY_MODERATE_THRESHOLD, moderate_quantity_threshold);
            this.bindingParams.put(BindingParams.CONCEPT_CONFIDENCE_THRESHOLD, concept_confidence_threshold);
        }
        catch (InternalException | ChartDescriptorLoaderException | InvalidChartDescriptor | IOException | ClassNotFoundException exc) {
            throw new InitializationException((Exception)exc);
        }
    }

    public VisualizationRecommender(Properties config) throws InitializationException {
        this(config, null);
    }

    @Override
    public List<IRecommendedVisualization> recommend(RecommendationModel recommendationModel, SmartsModule smartsModule, Locale locale, List<String> subsetColumnsById, VisualizationParameters params) throws RecommendationException {
        if (params == null) {
            params = new VisualizationParameters(locale);
        }
        if (params.getRequestContext() == null) {
            params.setRequestContext(new RequestContext(locale, locale));
        }
        params.setSmartsModule(smartsModule);
        return this.recommend(recommendationModel, subsetColumnsById, params);
    }

    @Override
    public List<IRecommendedVisualization> recommend(RecommendationModel recommendationModel, List<String> subsetColumnsById, VisualizationParameters params) throws RecommendationException {
        try {
            Map<String, IFilter> filterMap = params.getColumnFilterMap();
            for (Map.Entry<String, InclusionExclusionFilter> entry : params.getColumnInclusionExclusionMap().entrySet()) {
                filterMap.put(entry.getKey(), FilterFactory.createFilter());
            }
            params.setColumnFilterMap(filterMap);
            List<String> hiddenIds = VisRecommenderUtils.getHiddenIdsFromItems(params.getHiddenItems());
            subsetColumnsById = subsetColumnsById.stream().filter(h -> !hiddenIds.contains(h)).collect(Collectors.toList());
            List dataGroups = this.gen.getDataGroupsUsingAllColumns(params.getSmartsModule(), subsetColumnsById, params.getColumnFilterMap(), params.getPrimaryColumn());
            List<LogicalGroup> aggregatedLogicalGroups = VisRecommenderUtils.getAggregatedLogicalGroups(params.getSmartsModule());
            if (!params.getHiddenItems().isEmpty()) {
                this.updateDataGroups(dataGroups, params.getHiddenItems());
            }
            SpecAnalyserAdapter specAnalyserAdapter = null;
            if (recommendationModel != null) {
                specAnalyserAdapter = new SpecAnalyserAdapter(recommendationModel);
            }
            return this.recommend(specAnalyserAdapter != null ? specAnalyserAdapter.getContexts() : Collections.emptyList(), dataGroups, params, aggregatedLogicalGroups).stream().sorted(Comparator.comparing(IRecommendedVisualization::getScore).reversed().thenComparing(Comparator.comparing(IRecommendedVisualization::getRank))).collect(Collectors.toList());
        }
        catch (ColumnNotFoundException ex) {
            throw new RecommendationException(ex);
        }
    }

    private void updateDataGroups(List<IDataGroup<IDataColumn>> dataGroups, List<ItemType> hiddenItems) {
        for (ItemType item : hiddenItems) {
            IDataColumn fabricatedDataColumn = this.manufactureIDataCol(item);
            if (fabricatedDataColumn == null) continue;
            dataGroups.forEach(group -> group.getCombintions().forEach(inner -> {
                List idsPresent = inner.stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList());
                if (!idsPresent.contains(fabricatedDataColumn.getIdForExpression())) {
                    inner.add(fabricatedDataColumn);
                }
            }));
        }
    }

    @Override
    public List<IRecommendedVisualization> recommend(RecommendationModel recommendationModel, SmartsModule smartsModule, Locale locale, List<String> subsetColumnsById) throws RecommendationException {
        try {
            VisualizationParameters defaultParams = new VisualizationParameters(locale);
            defaultParams.setSmartsModule(smartsModule);
            List dataGroups = this.gen.getDataGroupsUsingAllColumns(smartsModule, subsetColumnsById, defaultParams.getColumnFilterMap(), null);
            List<LogicalGroup> aggregatedLogicalGroups = VisRecommenderUtils.getAggregatedLogicalGroups(smartsModule);
            SpecAnalyserAdapter specAnalyserAdapter = null;
            if (recommendationModel != null) {
                specAnalyserAdapter = new SpecAnalyserAdapter(recommendationModel);
            }
            return this.recommend(specAnalyserAdapter != null ? specAnalyserAdapter.getContexts() : Collections.emptyList(), dataGroups, defaultParams, aggregatedLogicalGroups).stream().sorted(Comparator.comparing(IRecommendedVisualization::getScore).reversed().thenComparing(Comparator.comparing(IRecommendedVisualization::getRank))).collect(Collectors.toList());
        }
        catch (ColumnNotFoundException ex) {
            throw new RecommendationException(ex);
        }
    }

    @Override
    public List<IRecommendedVisualization> recommendWithPair(RecommendationModel recommendationModel, SmartsModule smartsModule, Locale locale, List<Pair<String, String>> datasetAndColumnIDPair, VisualizationParameters params) throws RecommendationException {
        if (params == null) {
            params = new VisualizationParameters(locale);
        }
        if (params.getRequestContext() == null) {
            params.setRequestContext(new RequestContext(locale, locale));
        }
        params.setSmartsModule(smartsModule);
        return this.recommendWithPair(recommendationModel, datasetAndColumnIDPair, params);
    }

    @Override
    public List<IRecommendedVisualization> recommendWithPair(RecommendationModel recommendationModel, List<Pair<String, String>> datasetAndColumnIDPair, VisualizationParameters params) throws RecommendationException {
        List<String> columnIDs = this.getIDForExpression(params.getSmartsModule(), datasetAndColumnIDPair);
        return this.recommend(recommendationModel, columnIDs, params);
    }

    @Override
    public List<IRecommendedVisualization> recommendWithPair(RecommendationModel recommendationModel, SmartsModule smartsModule, Locale locale, List<Pair<String, String>> datasetAndColumnIDPair) throws RecommendationException {
        List<String> columnIDs = this.getIDForExpression(smartsModule, datasetAndColumnIDPair);
        return this.recommend(recommendationModel, smartsModule, locale, columnIDs);
    }

    private List<String> getIDForExpression(SmartsModule smartsModule, List<Pair<String, String>> datasetAndColumnIDPair) throws RecommendationException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            datasetAndColumnIDPair.forEach(pair -> {
                String datasetID = (String)pair.getLeft();
                String columnID = (String)pair.getRight();
                Optional<ColumnInfo> column = smartsModule.getDatasets().stream().filter(ds -> ds.getId().equals(datasetID)).flatMap(ds -> SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream()).filter(c -> c.getId().equals(columnID)).findFirst();
                if (!column.isPresent()) {
                    throw new VisRecommenderWrapperException(new ColumnNotFoundException("This column " + columnID + " from dataset " + datasetID + " was not found"));
                }
                result.add(column.get().getIdForExpression());
            });
        }
        catch (VisRecommenderWrapperException exception) {
            throw new RecommendationException(exception.getCause());
        }
        return result;
    }

    private void validateBoundColumns(List<Binding> boundColumns) throws BindingException {
        List illegalBindings;
        if (!boundColumns.isEmpty() && !(illegalBindings = boundColumns.stream().filter(b -> b.getColumns().isEmpty() || b.getColumns().get(0) == null || ((String)b.getColumns().get(0)).isEmpty()).collect(Collectors.toList())).isEmpty()) {
            throw new BindingException("Invalid bindings " + illegalBindings);
        }
    }

    @Override
    public List<IBindingResult> bind(RecommendationModel recommendationModel, SmartsModule smartsModule, Locale locale, String chart, String originalChart, List<Binding> bound, List<String> unbound, Map<String, IFilter> columnFilterMap, boolean forceBinding, List<ItemType> hiddenItems) throws BindingException {
        ArrayList<IBindingResult> results = new ArrayList<IBindingResult>();
        Predicate<String> multiMeasureFilter = col -> !MULTI_MEASURE_IDS.contains(col);
        Function<String, Stream> getCompatibles = ch -> this.chartCompatibility.getChartCompatability((String)ch).stream().flatMap(comp -> this.chartDescMap.getOrDefault(comp, Collections.emptyList()).stream());
        List<IChartDescriptor> charts = Stream.concat(this.chartDescMap.getOrDefault(chart, Collections.emptyList()).stream(), getCompatibles.apply(chart)).collect(Collectors.toList());
        List<IExternalChartDescriptor> externalChartDescriptors = this.externalChartDescMap.getOrDefault(chart, Collections.emptyList());
        if (recommendationModel != null) {
            try {
                List boundStrings = bound.stream().flatMap(binding -> binding.getColumns().stream()).collect(Collectors.toList());
                List<String> list = Stream.concat(boundStrings.stream(), unbound.stream()).distinct().collect(Collectors.toList());
                Map<String, IDataColumn> idToIDataColumn = this.getColumnsInfo(smartsModule, list, columnFilterMap, hiddenItems).stream().collect(Collectors.toMap(c -> c.getIdForExpression(), c -> c));
                NLGProperties properties = new NLGProperties(locale, charts, externalChartDescriptors);
                results.addAll(this.prefRecommender.getBindRecommendation(this.bindingParams, recommendationModel, idToIDataColumn, bound, unbound, chart, properties));
            }
            catch (ColumnNotFoundException exc) {
                LOGGER.warn("invalid column name during extraction for learning binding " + (Object)((Object)exc));
            }
        }
        if (originalChart != null) {
            if (this.compatibleChartsForBinding.isCompatible(originalChart, chart) && unbound.isEmpty()) {
                try {
                    List<Pair<IChartDescriptor, List<ExtractedFeatureSet>>> features;
                    BindingResult newResult = new BindingResult(locale, chart, bound, unbound, 0, PreferenceLevel.HIGH);
                    Map<String, IDataColumn> map = this.getBindingsColumnInfo(smartsModule, bound, columnFilterMap, hiddenItems);
                    Map<String, String> colToSlotMappping = bound.stream().flatMap(b -> b.getColumns().stream().map(c -> new Binding(Arrays.asList(c), b.getSlot(), b.getConcept(), Collections.emptySet()))).collect(Collectors.toMap(b -> (String)b.getColumns().get(0), b -> b.getSlot()));
                    Map<String, String> columnsMap = VisRecommenderUtils.getColumnIdNameMap(new HashSet<IDataColumn>(map.values()));
                    List slotsUsedInBinding = bound.stream().map(Binding::getSlot).collect(Collectors.toList());
                    List chartDescList = charts.stream().filter(c -> c.getChartElements().stream().map(e -> e.getType().getSlot()).collect(Collectors.toList()).containsAll(slotsUsedInBinding)).sorted(Comparator.comparingInt(c -> c.getChartElements().size())).filter(ch -> !ch.getName().equals(originalChart)).collect(Collectors.toList());
                    IChartDescriptor selectedChart = null;
                    List<ExtractedFeatureSet> selectedFeature = Collections.emptyList();
                    if (!chartDescList.isEmpty()) {
                        selectedChart = (IChartDescriptor)chartDescList.get(0);
                        selectedFeature = map.entrySet().stream().map(e -> {
                            List<ExtractedFeatureSet> features = FeatureExtracter.extractFeatureSetFromColumn((IDataColumn)e.getValue(), this.bindingParams, true, 0, false);
                            if (!features.isEmpty()) {
                                Optional<ChartElement> element;
                                String slot = (String)colToSlotMappping.get(e.getKey());
                                if (slot != null && (element = ((IChartDescriptor)chartDescList.get(0)).getChartElements().stream().filter(ce -> ce.getType().getSlot().equals(slot)).findFirst()).isPresent()) {
                                    ChartElement elem = element.get();
                                    Optional<ExtractedFeatureSet> match = features.stream().filter(f -> elem.getBasicTypes().contains((Object)f.getFeatureType()) && (elem.getConcept().equals("NONE") || elem.getConcept().equals(f.getConcept()))).findFirst();
                                    if (match.isPresent()) {
                                        return match.get();
                                    }
                                }
                                return features.get(0);
                            }
                            return null;
                        }).filter(Objects::nonNull).collect(Collectors.toList());
                    }
                    if (!(features = this.getFeaturesFromBindings(smartsModule, chart, bound, hiddenItems)).isEmpty()) {
                        selectedChart = features.get(0).getLeft();
                        selectedFeature = features.get(0).getRight();
                    }
                    if (!selectedFeature.isEmpty()) {
                        newResult.generateNaturalLanguage(locale, selectedChart, selectedFeature, bound, columnsMap);
                        results.add(newResult);
                        return results;
                    }
                }
                catch (ColumnNotFoundException e2) {
                    LOGGER.warn("Failed to bind compatible charts");
                }
            }
            for (Binding binding2 : bound) {
                unbound.addAll(binding2.getColumns().stream().filter(multiMeasureFilter).collect(Collectors.toList()));
            }
            bound = Collections.emptyList();
        }
        try {
            List<Object> boundColumns = bound;
            if (boundColumns == null) {
                boundColumns = Collections.emptyList();
            } else {
                this.validateBoundColumns(boundColumns);
            }
            List<IDataColumn> list = this.getColumnsInfo(smartsModule, unbound, columnFilterMap, hiddenItems);
            List boundMatrixColumns = boundColumns.stream().filter(s -> StdChartElements.MATRIX_COLUMN.name().equals(s.getSlot()) || StdChartElements.MATRIX_ROW.name().equals(s.getSlot())).collect(Collectors.toList());
            boundColumns = boundColumns.stream().filter(s -> !StdChartElements.MATRIX_COLUMN.name().equals(s.getSlot()) && !StdChartElements.MATRIX_ROW.name().equals(s.getSlot())).collect(Collectors.toList());
            List<IDataColumn> unboundColumnsHierarchy = this.mergeHierarchicalColumns(smartsModule, boundColumns, list, columnFilterMap, hiddenItems);
            Map<String, IDataColumn> boundColumnInfo = this.getBindingsColumnInfo(smartsModule, boundColumns, columnFilterMap, hiddenItems);
            if (!charts.isEmpty()) {
                try {
                    this.checkInvalidSlots(boundColumns, charts.stream().flatMap(c -> c.getChartElements().stream().map(ce -> ce.getType().getSlot())).collect(Collectors.toSet()));
                }
                catch (BindingException e3) {
                    this.checkInvalidSlots(boundColumns, externalChartDescriptors.stream().flatMap(c -> c.getElements().stream().map(ce -> ce.getType().getSlot())).collect(Collectors.toSet()));
                }
                List<LogicalGroup> aggregatedLogicalGroups = VisRecommenderUtils.getAggregatedLogicalGroups(smartsModule);
                results.addAll(this.bindInternalCharts(locale, charts, boundColumns, boundColumnInfo, list, unboundColumnsHierarchy, aggregatedLogicalGroups, forceBinding));
            }
            Function<String, Stream> getExternalCompatibles = ch -> this.chartCompatibility.getChartCompatability((String)ch).stream().flatMap(comp -> this.externalChartDescMap.getOrDefault(comp, Collections.emptyList()).stream());
            List<IExternalChartDescriptor> externalCharts = Stream.concat(this.externalChartDescMap.getOrDefault(chart.trim(), Collections.emptyList()).stream(), getExternalCompatibles.apply(chart)).collect(Collectors.toList());
            if (externalCharts.isEmpty() && charts.isEmpty()) {
                throw new UnknownChartException(chart);
            }
            results.addAll(VisualizationRecommender.bindExternalCharts(locale, externalCharts, boundColumns, boundColumnInfo, list, forceBinding));
            ToDoubleFunction<IBindingResult> bindingScoreLearning = r -> r.getBindingScore();
            results.sort(Comparator.comparingDouble(bindingScoreLearning::applyAsDouble).reversed());
            results.forEach(bindingRes -> bindingRes.getBinding().addAll(boundMatrixColumns));
            if (results.isEmpty()) {
                results.add(new BindingResult(locale, chart, bound, unbound, 0, PreferenceLevel.HIGH));
                return results;
            }
            return VisualizationMatrixer.addMaxtrixBinding(smartsModule, this.matrixExcludedCharts, chart, results, this.gen, columnFilterMap, this.config).stream().map(r -> r).collect(Collectors.toList());
        }
        catch (ColumnNotFoundException | UnknownChartException exc) {
            throw new BindingException(exc);
        }
    }

    private void checkInvalidSlots(List<Binding> boundColumns, Set<String> availableSlots) throws BindingException {
        List unfoundSlots = boundColumns.stream().map(Binding::getSlot).filter(s -> !availableSlots.contains(s)).collect(Collectors.toList());
        if (!unfoundSlots.isEmpty()) {
            throw new BindingException("slot does not exist: " + unfoundSlots);
        }
    }

    @Override
    public void like(RecommendationModel recommendationModel, SmartsModule smartsModule, List<String> subsetColumnsById, String chart, List<Binding> bindings) throws LearningException {
        this.learn(new SpecAnalyserAdapter(recommendationModel), smartsModule, subsetColumnsById, chart, Sentiment.LIKE, bindings);
    }

    @Override
    public void dislike(RecommendationModel recommendationModel, SmartsModule smartsModule, List<String> subsetColumnsById, String chart, List<Binding> bindings) throws LearningException {
        this.learn(new SpecAnalyserAdapter(recommendationModel), smartsModule, subsetColumnsById, chart, Sentiment.DISLIKE, bindings);
    }

    @Override
    public void use(RecommendationModel recommendationModel, SmartsModule smartsModule, List<String> subsetColumnsById, String chart, List<Binding> bindings) throws LearningException {
        this.learn(new SpecAnalyserAdapter(recommendationModel), smartsModule, subsetColumnsById, chart, Sentiment.USE, bindings);
    }

    private void processCharts(ChartDescriptorRegistery<IChartDescriptor> inDescriptors) throws InvalidChartDescriptor {
        this.modelChartDescMap.putAll(inDescriptors.stream().filter(IChartDescriptor::isValid).map(d -> {
            try {
                return ModelChartDescriptor.getModelChartDescriptor(d);
            }
            catch (InvalidChartDescriptor e) {
                LOGGER.error("Invalid chart descriptor {}", (Object)d.getName());
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(ModelChartDescriptor::getName)));
        this.chartDescMap.putAll(this.modelChartDescMap.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).map(ModelChartDescriptor::getHighLevelDescriptor).collect(Collectors.groupingBy(IBaseChartDescriptor::getName)));
    }

    private void processExternalCharts(ChartDescriptorRegistery<IExternalChartDescriptor> reg) {
        reg.forEach(chart -> {
            List list = this.externalChartDescMap.getOrDefault(chart.getName(), new ArrayList());
            list.add(chart);
            this.externalChartDescMap.put(chart.getName(), list);
        });
    }

    @Override
    public Set<String> getSupportedCharts() {
        HashSet<String> supportedCharts = new HashSet<String>();
        supportedCharts.addAll(this.externalChartDescMap.keySet());
        supportedCharts.addAll(this.chartDescMap.keySet());
        return supportedCharts;
    }

    private void readDefaultModel() throws ClassNotFoundException, IOException {
        try (InputStream mapperStream = this.getClass().getResourceAsStream(LABEL_MAP_FILE);){
            this.mapper = (LabelChartsMapper)JsonParserHelper.parseJson((JsonNode)JsonParserHelper.getJsonFromStream((InputStream)mapperStream), LabelChartsMapper.class);
            try (BufferedInputStream modelStream = new BufferedInputStream(new GZIPInputStream(this.getClass().getResourceAsStream(ML_MODEL_FILE)));){
                this.readClassifierModel(modelStream);
            }
        }
    }

    private void readStdChartDescriptors() throws ChartDescriptorLoaderException, InvalidChartDescriptor {
        ChartDescriptorRegistery<IChartDescriptor> internalRegistery = new ChartDescriptorRegistery<IChartDescriptor>();
        ChartDescriptorLoader.loadStdChartDescriptors(internalRegistery, CHART_SPEC_DIR);
        this.processCharts(internalRegistery);
    }

    private void readExtensionChartDescriptors() throws ChartDescriptorLoaderException, InvalidChartDescriptor {
        ChartDescriptorRegistery<IChartDescriptor> extensionsRegistery = new ChartDescriptorRegistery<IChartDescriptor>();
        ChartDescriptorLoader.loadExtensionChartDescriptors(extensionsRegistery, Optional.empty(), Optional.empty());
        ChartDescriptorLoader.loadExtensionChartDescriptors(extensionsRegistery, this.config.getProperty("smarts.visualization.recommender.extensionChartsPath") == null ? Optional.empty() : Optional.of(this.config.getProperty("smarts.visualization.recommender.extensionChartsPath") + CHART_SPEC_DIR), this.config.getProperty("smarts.visualization.recommender.extensionChartsPath") == null ? Optional.empty() : Optional.of(this.config.getProperty("smarts.visualization.recommender.extensionChartsPath") + CHART_TYPES_DIR));
        this.processCharts(extensionsRegistery);
    }

    private void readExternalChartDescriptors() throws ChartDescriptorLoaderException {
        ChartDescriptorLoader.loadExternalChartDescriptors(this.externalchartDescriptors, Optional.of(STD_EXTERNAL_CHARTS_PATH), Optional.empty());
        if (this.config.getProperty("smarts.visualization.recommender.externalChartsPath") != null && !this.config.getProperty("smarts.visualization.recommender.extensionChartsPath").isEmpty()) {
            ChartDescriptorLoader.loadExternalChartDescriptors(this.externalchartDescriptors, Optional.of(this.config.getProperty("smarts.visualization.recommender.externalChartsPath") + CHART_SPEC_DIR), Optional.of(this.config.getProperty("smarts.visualization.recommender.externalChartsPath") + CHART_TYPES_DIR));
        }
        this.processExternalCharts(this.externalchartDescriptors);
    }

    private void readClassifierModel(InputStream model) throws IOException, ClassNotFoundException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            int size = 0;
            byte[] buff = new byte[Short.MAX_VALUE];
            do {
                if ((size = model.read(buff)) <= 0) continue;
                stream.write(buff, 0, size);
            } while (size > 0);
            this.classifier = this.classifiersFactory.deserliazeClassifier(stream.toByteArray());
        }
    }

    private static void readChartElementTypesFromProviders() throws ChartDescriptorLoaderException {
        List<IChartElementTypesProvider> spiTypes = ChartDescriptorLoader.loadServiceProviderTypes();
        spiTypes.forEach(i -> i.getCustomChartElementTypes().forEach(t -> ChartElementTypes.getTypes().put(t.getName(), (ChartElementType)t)));
    }

    private void readChartCompatabilityMap() throws ChartDescriptorLoaderException {
        this.chartCompatibility = ChartDescriptorLoader.loadChartCompatibility(CHART_COMPATIBILITY_FILE);
    }

    private void readChartColumnsCompatabilityMap() throws ChartDescriptorLoaderException {
        this.compatibleChartsForBinding = ChartDescriptorLoader.loadChartBindingsCompatibility(CHART_COLUMNS_COMPATIBILITY_FILE);
    }

    private void readChartRankings() throws ChartDescriptorLoaderException {
        this.chartRankings = ChartDescriptorLoader.loadChartRankings(CHART_RANKING_FILE);
    }

    private void readExternalChartRankings() throws ChartDescriptorLoaderException {
        this.externalChartRankings = ChartDescriptorLoader.loadChartRankings(EXTERNAL_CHART_RANKING_FILE);
    }

    private void readChartDescriptors() throws ChartDescriptorLoaderException, InvalidChartDescriptor {
        this.readStdChartDescriptors();
        VisualizationRecommender.readChartElementTypesFromProviders();
        this.readExtensionChartDescriptors();
        this.readExternalChartDescriptors();
        this.readChartCompatabilityMap();
        this.readChartColumnsCompatabilityMap();
        this.readChartRankings();
        this.readExternalChartRankings();
    }

    private void buildPipeline() {
        this.pipeline = new ChartDecomposer(this.mapper).andThen(new ChartValidator(this.modelChartDescMap)).andThen(new PredictChartFilter(this.fieldRecommender)).andThen(new NoneAggregationFilter()).andThen(new ScatterBubbleChartFilter()).andThen(new ChartScoreFilter(Double.valueOf(this.config.getProperty("smarts.visualization.recommender.minRequiredScore")))).andThen(new ChartConceptScoreAdjuster()).andThen(new ChartHeatmapScoreAdjuster()).andThen(new ChartBinder()).andThen(new ChartRanker(this.chartRankings));
    }

    public InterestingFieldsRecommender getFieldRecommender() {
        return this.fieldRecommender;
    }

    public void setFieldRecommender(InterestingFieldsRecommender fieldRecommender) {
        this.fieldRecommender = fieldRecommender;
    }

    private List<ExternalRecommendedVisualization> recommendExternalCharts(Stream<IExternalChartDescriptor> charts, String combinationId, List<IDataColumn> columns, List<Binding> constraints, VisualizationParameters parameters) {
        Function<IExternalChartDescriptor, ExternalRecommendedVisualization> recommend = c -> {
            try {
                return c.recommend(combinationId, columns, constraints, parameters);
            }
            catch (RecommendationException e) {
                throw new VisRecommenderWrapperException(e);
            }
        };
        return charts.filter(c -> c.getNumberOfChartsElements() >= (long)columns.size()).map(recommend).filter(Objects::nonNull).sorted(Comparator.comparingDouble(BaseRecommendedVisualization::getScore).reversed()).collect(Collectors.toList());
    }

    private List<RecommendedVisualization> runPipeline(VisualizationParameters visParams, List<RecommendedVisualization> recommendations) {
        return this.pipeline.apply(new Pair(recommendations.stream(), visParams)).getLeft().collect(Collectors.toList());
    }

    public static String getColNamesCombinationId(Stream<String> names) {
        return names.sorted().collect(Collectors.joining(",", "[", "]"));
    }

    private String getIDataColumnCombinationId(List<IDataColumn> columns) {
        return VisualizationRecommender.getColNamesCombinationId(columns.stream().map(IDataColumn::getName));
    }

    private List<FeatureExtracter> getCombinationsFeaturesExtractors(List<List<IDataColumn>> combinations, VisualizationParameters parameters, List<LogicalGroup> logicalGroups) throws InvalidColumnInfoException {
        try {
            return combinations.stream().map(t -> {
                try {
                    return this.extractFeatures((List<IDataColumn>)t, parameters.getBehaviors(), parameters.getColumnTopBottomFilterMap(), parameters.getBaseFilterList(), true, logicalGroups, parameters.getAggregationMap());
                }
                catch (InvalidColumnInfoException e) {
                    throw new VisRecommenderWrapperException(e);
                }
            }).distinct().collect(Collectors.toList());
        }
        catch (VisRecommenderWrapperException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidColumnInfoException) {
                throw (InvalidColumnInfoException)cause;
            }
            LOGGER.warn(UNEXPECTED_EXCEPTION, cause);
            return Collections.emptyList();
        }
    }

    private List<FeatureBinding> getFeaturesBindings(List<FeatureExtracter> extractors) {
        return extractors.stream().filter(e -> e.getCombination().size() <= ModelFeaturesBinder.getMaxModelColNum()).flatMap(e -> VisualizationRecommender.bindFeatures(e).stream()).collect(Collectors.toList());
    }

    private Map<String, List<List<ExtractedFeatureSet>>> getCombinationFeaturesMap(List<FeatureExtracter> extractors) {
        BinaryOperator merge = (e1, e2) -> {
            ArrayList merged = new ArrayList();
            merged.addAll(e1);
            merged.addAll(e2);
            return merged;
        };
        return extractors.stream().collect(Collectors.toMap(e -> this.getIDataColumnCombinationId(e.getCombination()), FeatureExtracter::getFeatures, merge::apply));
    }

    protected FeatureExtracter extractFeatures(List<IDataColumn> combination, List<EXTRA_BEHAVIOR> behaviors, Map<String, TopBottomFilter> topBottomFiltersMap, List<BaseFilter> filters, boolean exploreWithoutConcepts, List<LogicalGroup> logicalGroups, Map<String, AggregationType> aggregationMap) throws InvalidColumnInfoException {
        FeatureExtracter extracter = new FeatureExtracter(combination);
        Function<List<List<ExtractedFeatureSet>>, List<List<ExtractedFeatureSet>>> featureAdapterPipeline = new TwinCategoryAdapter();
        BiFunction<Function, EXTRA_BEHAVIOR, Function> addToPipeline = (pipeline, behavior) -> {
            switch (behavior) {
                case ALLOW_DUAL_COLUMNS_ADAPTATION: {
                    return pipeline.andThen(new DualColumnsAdaptor());
                }
                case ALLOW_EXTRA_CATEGORY: {
                    return pipeline.andThen(new TwoCategoryAdapter());
                }
                case ALLOW_AUTO_GROUPING: {
                    return pipeline.andThen(new AutoGroupingAllMeasure());
                }
                case ALLOW_TOP_BOTTOM_FILTER: {
                    return pipeline.andThen(new TopBottomFilterCategoryHighDomain(10));
                }
            }
            return pipeline;
        };
        if (!topBottomFiltersMap.isEmpty()) {
            featureAdapterPipeline = featureAdapterPipeline.andThen(new TopBottomFilterApplicator(topBottomFiltersMap, this.bindingParams, 10));
        }
        if (!filters.isEmpty()) {
            featureAdapterPipeline = featureAdapterPipeline.andThen(new FilterApplicator(filters));
        }
        if (!aggregationMap.isEmpty()) {
            featureAdapterPipeline = featureAdapterPipeline.andThen(new ConvertCategoryAdapter(aggregationMap));
        }
        for (EXTRA_BEHAVIOR behaviour : behaviors) {
            featureAdapterPipeline = addToPipeline.apply(featureAdapterPipeline, behaviour);
        }
        extracter.extractFeatures(this.bindingParams, featureAdapterPipeline, exploreWithoutConcepts, logicalGroups, false);
        return extracter;
    }

    protected static List<FeatureBinding> bindFeatures(FeatureExtracter extracter) {
        ModelFeaturesBinder binder = new ModelFeaturesBinder();
        binder.bind(extracter);
        if (extracter.hasLocations()) {
            FeatureExtracter catExtracter = new FeatureExtracter(extracter);
            catExtracter.convertLocationsToCategories();
            binder.bind(catExtracter);
        }
        return binder.getBindings();
    }

    private List<IBindingResult> bindWithLocationsAsGenericCategory(Locale locale, IChartDescriptor desc, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, FeatureExtracter extractor, boolean forceBind) {
        FeatureExtracter catExtracter = new FeatureExtracter(extractor);
        catExtracter.convertLocationsToCategories();
        return catExtracter.getFeatures().stream().flatMap(f -> {
            try {
                return desc.bindChartElements(locale, bound, boundColumnInfo, this.bindingParams, (List<ExtractedFeatureSet>)f, forceBind).stream();
            }
            catch (ImpossibleBindingException | InvalidColumnBindingException | InvalidColumnInfoException exc) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map<String, List<RecommendedVisualization>> makeChartCombinationMap(List<FeatureBinding> bindings, List<String> excludedCharts, VisualizationParameters parameters) {
        return bindings.stream().flatMap(b -> {
            try {
                List incFilters = parameters.getBaseFilterList().stream().filter(f -> f.getType().equals((Object)FilterType.INCLUSION_EXCLUSION)).collect(Collectors.toList());
                List<RecommendedVisualization> recommendations = this.classifier.getProbabilityDistribution(b.buildFeatureVector(), parameters.getMaxChartsPerColumnCombination()).stream().map(c -> new RecommendedVisualization(c.getLabel(), (double)((int)(c.getProbability() * 100.0)) / 100.0, b.getFeatureSets(), VisualizationRecommender.getColNamesCombinationId(b.getCombinationIDs().stream()), incFilters, parameters.getAggregationMap())).collect(Collectors.toList());
                return this.runPipeline(parameters, recommendations).stream();
            }
            catch (ClassifierException | GenericTransformerException e) {
                return Collections.emptyList().stream();
            }
        }).filter(r -> !excludedCharts.contains(r.getLabel())).map(r -> {
            Map<String, String> mapColumnIdForExpresionToColumnName = VisRecommenderUtils.getColumnIdNameMap(r.getFeatures().stream().map(ExtractedFeatureSet::getColumn).collect(Collectors.toSet()));
            if (this.getLocale(parameters) != null) {
                r.generateNaturalLanguage(parameters.getRequestContext().locale, mapColumnIdForExpresionToColumnName);
            }
            return r;
        }).collect(Collectors.groupingBy(BaseRecommendedVisualization::getCombintaionId));
    }

    private List<IRecommendedVisualization> recommend(List<ChartPreferenceContext> contexts, List<IDataGroup<IDataColumn>> dataGroups, VisualizationParameters parameters, List<LogicalGroup> logicalGroups) throws RecommendationException {
        if (parameters.getMaxChartsPerColumnCombination() <= 0) {
            parameters.setMaxChartsPerColumnCombination(20);
        }
        try {
            return dataGroups.stream().flatMap(g -> this.makeRecommendations((IDataGroup<IDataColumn>)g, contexts, parameters, logicalGroups).stream()).collect(Collectors.toList());
        }
        catch (VisRecommenderWrapperException e) {
            throw new RecommendationException(e.getCause());
        }
    }

    private List<IRecommendedVisualization> makeRecommendations(IDataGroup<IDataColumn> dataGroup, List<ChartPreferenceContext> contexts, VisualizationParameters parameters, List<LogicalGroup> logicalGroups) {
        List<FeatureExtracter> extractors;
        try {
            extractors = this.getCombinationsFeaturesExtractors(dataGroup.getCombintions(), parameters, logicalGroups);
        }
        catch (InvalidColumnInfoException e2) {
            LOGGER.warn(e2.toString());
            throw new VisRecommenderWrapperException(e2);
        }
        List<FeatureBinding> bindings = this.getFeaturesBindings(extractors);
        Map<String, List<List<ExtractedFeatureSet>>> featuresPerCombination = this.getCombinationFeaturesMap(extractors);
        ArrayList<String> exclusions = new ArrayList<String>();
        if (parameters.isPredictiveOnly()) {
            exclusions.addAll(this.chartDescMap.entrySet().stream().filter(e -> ((List)e.getValue()).stream().noneMatch(c -> c.isPredictive())).map(desc -> (String)desc.getKey()).collect(Collectors.toList()));
            exclusions.addAll(this.externalChartDescMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList()));
        }
        if (parameters.getIncludedCharts() != null && !parameters.getIncludedCharts().isEmpty()) {
            exclusions.addAll(this.chartDescMap.keySet().stream().filter(k -> !parameters.getIncludedCharts().contains(k)).collect(Collectors.toList()));
            exclusions.addAll(this.externalChartDescMap.keySet().stream().filter(k -> !parameters.getIncludedCharts().contains(k)).collect(Collectors.toList()));
        } else if (parameters.getExcludedCharts() != null) {
            exclusions.addAll(parameters.getExcludedCharts());
        }
        List<RecommendedVisualization> internalChartsList = this.makeInternalRecommendations(dataGroup, bindings, exclusions, parameters);
        List<ExternalRecommendedVisualization> externalChartsList = this.makeExternalRecommendations(featuresPerCombination, exclusions, parameters);
        this.rankChartsWithPreferenceRecommender(dataGroup, contexts, this.getLocale(parameters), internalChartsList, externalChartsList);
        Map<String, List<RecommendedVisualization>> internalChartsMap = this.prepInternalRecommendationsForAggregation(internalChartsList);
        Map<String, List<ExternalRecommendedVisualization>> externalChartsMap = this.prepExternalRecommendationsForAggregation(externalChartsList);
        return featuresPerCombination.entrySet().stream().flatMap(entry -> this.aggregateRecommendations((Map.Entry<String, List<List<ExtractedFeatureSet>>>)entry, internalChartsMap, externalChartsMap, parameters.getMaxChartsPerColumnCombination()).stream()).collect(Collectors.toList());
    }

    private Locale getLocale(VisualizationParameters visParams) {
        if (visParams != null && visParams.getRequestContext() != null) {
            return visParams.getRequestContext().locale;
        }
        return null;
    }

    private List<RecommendedVisualization> makeInternalRecommendations(IDataGroup<IDataColumn> group, List<FeatureBinding> bindings, List<String> excludedCharts, VisualizationParameters parameters) {
        Map<String, List<RecommendedVisualization>> chartsPerCombination = this.makeChartCombinationMap(bindings, excludedCharts, parameters);
        VisualizationMatrixer.addMatrixCharts(group, chartsPerCombination, this.matrixExcludedCharts, this.config);
        return chartsPerCombination.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    private List<ExternalRecommendedVisualization> makeExternalRecommendations(Map<String, List<List<ExtractedFeatureSet>>> featuresPerCombination, List<String> excludedCharts, VisualizationParameters parameters) {
        double minScore = Double.valueOf(this.config.getProperty("smarts.visualization.recommender.minRequiredScore"));
        BiFunction<String, List, List> recommendExternals = (combinationId, columns) -> {
            List<Object> externals = Collections.emptyList();
            try {
                externals = this.recommendExternalCharts(this.externalchartDescriptors.stream(), (String)combinationId, (List<IDataColumn>)columns, null, parameters);
            }
            catch (VisRecommenderWrapperException exc) {
                return externals;
            }
            externals = externals.stream().filter(ext -> !excludedCharts.contains(ext.getLabel())).filter(r -> r.getScore() >= minScore).collect(Collectors.toList());
            externals.forEach(r -> r.setRank(this.externalChartRankings.getChartRanking(r.getLabel())));
            return externals;
        };
        Map<String, List> externalChartsMap = featuresPerCombination.entrySet().stream().map(e -> (List)recommendExternals.apply((String)e.getKey(), ((List)((List)e.getValue()).get(0)).stream().map(ExtractedFeatureSet::getColumn).collect(Collectors.toList()))).filter(recs -> !recs.isEmpty()).collect(Collectors.toMap(recs -> ((ExternalRecommendedVisualization)recs.get(0)).getCombintaionId(), recs -> recs, (recs1, recs2) -> recs1));
        return externalChartsMap.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    private void rankChartsWithPreferenceRecommender(IDataGroup<IDataColumn> group, List<ChartPreferenceContext> contexts, Locale locale, List<RecommendedVisualization> filteredInternalCharts, List<ExternalRecommendedVisualization> externalChartsList) {
        Map<String, IDataColumn> idToDataColumns = group.getCombintions().stream().flatMap(l -> l.stream()).flatMap(c -> c.isHierchical() ? c.getHierarchy().stream() : Arrays.asList(c).stream()).collect(Collectors.toMap(c -> c.getIdForExpression(), c -> c, (l1, l2) -> l2));
        this.prefRecommender.rankRecommendations(contexts, locale, filteredInternalCharts, externalChartsList, this.bindingParams, idToDataColumns);
    }

    private Map<String, List<RecommendedVisualization>> prepInternalRecommendationsForAggregation(List<RecommendedVisualization> filteredInternalCharts) {
        HashSet seen = new HashSet();
        Predicate<RecommendedVisualization> distinctRecommendation = r -> seen.add(r.getLabel());
        List distinctInternalCharts = filteredInternalCharts.stream().filter(distinctRecommendation::test).collect(Collectors.toList());
        return distinctInternalCharts.stream().collect(Collectors.groupingBy(r -> r.getCombintaionId()));
    }

    private Map<String, List<ExternalRecommendedVisualization>> prepExternalRecommendationsForAggregation(List<ExternalRecommendedVisualization> externalChartsList) {
        HashSet seenExternal = new HashSet();
        Predicate<ExternalRecommendedVisualization> distinctExternalRecommendation = r -> seenExternal.add(r.getLabel());
        return externalChartsList.stream().filter(distinctExternalRecommendation::test).collect(Collectors.groupingBy(r -> r.getCombintaionId()));
    }

    private List<IRecommendedVisualization> aggregateRecommendations(Map.Entry<String, List<List<ExtractedFeatureSet>>> entry, Map<String, List<RecommendedVisualization>> internalChartsMap, Map<String, List<ExternalRecommendedVisualization>> externalChartsMap, int maxNumberOfCharts) {
        ArrayList aggregated = new ArrayList();
        List internals = internalChartsMap.getOrDefault(entry.getKey(), new ArrayList());
        Map recMap = internals.stream().collect(Collectors.toMap(BaseRecommendedVisualization::getLabel, Function.identity()));
        List<ExternalRecommendedVisualization> externals = externalChartsMap.getOrDefault(entry.getKey(), Collections.emptyList());
        externals.forEach(external -> {
            RecommendedVisualization internal = (RecommendedVisualization)recMap.get(external.getLabel());
            if (internal != null) {
                if (internal.getScore() > external.getScore()) {
                    aggregated.add(internal);
                } else {
                    aggregated.add(external);
                }
                recMap.remove(internal.getLabel());
            } else {
                aggregated.add(external);
            }
        });
        aggregated.addAll(recMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList()));
        return aggregated.stream().sorted(Comparator.comparingDouble(IRecommendedVisualization::getScore).reversed().thenComparing(IRecommendedVisualization::getRank)).limit(maxNumberOfCharts).collect(Collectors.toList());
    }

    private List<Pair<IChartDescriptor, List<ExtractedFeatureSet>>> getFeaturesFromBindings(SmartsModule smartsModule, String chart, List<Binding> bindings, List<ItemType> hiddenItems) {
        List columns;
        try {
            columns = bindings.stream().map(b -> {
                try {
                    return this.getColumnsInfo(smartsModule, b.getColumns(), Collections.emptyMap(), hiddenItems);
                }
                catch (ColumnNotFoundException e) {
                    LOGGER.warn(e.toString());
                    throw new VisRecommenderWrapperException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (VisRecommenderWrapperException e) {
            return Collections.emptyList();
        }
        List flattenedColumns = columns.stream().flatMap(cols -> IDataColumn.formHierarchy((List)cols).stream()).collect(Collectors.toList());
        Map hboundColumnInfo = flattenedColumns.stream().collect(Collectors.toMap(IDataColumn::getIdForExpression, Function.identity(), (c1, c2) -> c1));
        List candidates = this.chartDescMap.getOrDefault(chart, Collections.emptyList()).stream().map(c -> {
            try {
                return LearningUtils.getFeaturesFromBindingsWithScore(bindings, hboundColumnInfo, this.bindingParams, c);
            }
            catch (InvalidColumnBindingException ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Collections.sort(candidates);
        return candidates.stream().map(c -> new Pair<IChartDescriptor, List<ExtractedFeatureSet>>((IChartDescriptor)c.getChart(), c.getExtractedFeatures())).collect(Collectors.toList());
    }

    private boolean learnInternalChart(SpecAnalyserAdapter specAnalyserAdapter, SmartsModule smartsModule, String chart, Sentiment sentiment, List<Binding> bindings) {
        List candidates = this.chartDescMap.getOrDefault(chart, Collections.emptyList());
        boolean learned = false;
        try {
            Map<String, IDataColumn> boundColumnInfo = this.getBindingsColumnInfo(smartsModule, bindings, Collections.emptyMap(), Collections.emptyList());
            for (IChartDescriptor candidate : candidates) {
                if (!this.prefRecommender.learn(specAnalyserAdapter, candidate, bindings, sentiment, this.bindingParams, boundColumnInfo)) continue;
                learned = true;
                break;
            }
        }
        catch (ColumnNotFoundException | InvalidColumnBindingException ex) {
            LOGGER.warn(ex.toString());
            return false;
        }
        return learned;
    }

    private void learnExternalChart(SpecAnalyserAdapter specAnalyserAdapter, SmartsModule smartsModule, String chart, Sentiment sentiment, List<Binding> bindings) {
        List candidates = this.externalchartDescriptors.stream().filter(c -> c.getName().equals(chart)).collect(Collectors.toList());
        try {
            Map<String, IDataColumn> boundColumnInfo = this.getBindingsColumnInfo(smartsModule, bindings, Collections.emptyMap(), Collections.emptyList());
            for (IBaseChartDescriptor candidate : candidates) {
                this.prefRecommender.learn(specAnalyserAdapter, candidate, bindings, sentiment, this.bindingParams, boundColumnInfo);
            }
        }
        catch (ColumnNotFoundException | InvalidColumnBindingException ex) {
            LOGGER.warn(ex.toString());
        }
    }

    private void learn(SpecAnalyserAdapter specAnalyserAdapter, SmartsModule smartsModule, List<String> subsetColumnsById, String chart, Sentiment sentiment, List<Binding> bindings) throws LearningException {
        if (bindings == null || bindings.stream().anyMatch(b -> b.getColumns().stream().anyMatch(c -> !subsetColumnsById.contains(c)))) {
            throw new LearningException("Inconsistent bindings and selected columns" + chart);
        }
        boolean learnt = false;
        if (this.chartDescMap.containsKey(chart)) {
            learnt = this.learnInternalChart(specAnalyserAdapter, smartsModule, chart, sentiment, bindings);
        }
        if (!learnt) {
            if (this.externalChartDescMap.containsKey(chart)) {
                this.learnExternalChart(specAnalyserAdapter, smartsModule, chart, sentiment, bindings);
            } else {
                throw new LearningException("Unknown chart type" + chart);
            }
        }
    }

    private IDataColumn getColumnInfo(SmartsModule smartsModule, String columnId, Map<String, IFilter> columnFilterMap, boolean isPrimary) {
        return this.gen.getColumn(smartsModule, columnId, columnFilterMap, isPrimary);
    }

    private List<IDataColumn> getColumnsInfo(SmartsModule smartsModule, List<String> columnIds, Map<String, IFilter> columnFilterMap, List<ItemType> hiddenItems) throws ColumnNotFoundException {
        return this.getColumnsInfo(smartsModule, columnIds, columnFilterMap, null, hiddenItems);
    }

    private List<IDataColumn> getColumnsInfo(SmartsModule smartsModule, List<String> columnIds, Map<String, IFilter> columnFilterMap, String primaryColumn, List<ItemType> hiddenItems) throws ColumnNotFoundException {
        try {
            if (columnIds == null || columnIds.isEmpty()) {
                return Collections.emptyList();
            }
            return columnIds.stream().map(id -> {
                IDataColumn col = this.mapColumnToIDataColumn(hiddenItems, smartsModule, (String)id, columnFilterMap, primaryColumn == null ? false : primaryColumn.equals(id));
                if (col == null) {
                    throw new VisRecommenderWrapperException(new ColumnNotFoundException(id));
                }
                return col;
            }).collect(Collectors.toList());
        }
        catch (VisRecommenderWrapperException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ColumnNotFoundException) {
                throw (ColumnNotFoundException)cause;
            }
            LOGGER.warn(UNEXPECTED_EXCEPTION, cause);
            return Collections.emptyList();
        }
    }

    private Map<String, IDataColumn> getBindingsColumnInfo(SmartsModule smartsModule, List<Binding> bindings, Map<String, IFilter> columnFilterMap, List<ItemType> hiddenItems) throws ColumnNotFoundException {
        try {
            Function<Binding, Stream> columnMapper = b -> {
                Function<Binding, List> getIDataColumns = binding -> binding.getColumns().stream().map(c -> {
                    IDataColumn col = this.mapColumnToIDataColumn(hiddenItems, smartsModule, (String)c, columnFilterMap, false);
                    if (col == null) {
                        LOGGER.warn("Unknown column {} bound to slot {}", c, (Object)b.getSlot());
                    }
                    return col;
                }).collect(Collectors.toList());
                if (b.getConcept().equals(StdChartConcepts.HIERARCHY.name())) {
                    List hColumns = IDataColumn.formHierarchy((List)getIDataColumns.apply((Binding)b));
                    if (hColumns.size() > 1) {
                        LOGGER.error("Unexpected multiple hierarchies with columns {}", (Object)b.getColumns());
                    } else {
                        return hColumns.stream();
                    }
                }
                return getIDataColumns.apply((Binding)b).stream();
            };
            return bindings.stream().flatMap(columnMapper::apply).filter(Objects::nonNull).collect(Collectors.toMap(IDataColumn::getIdForExpression, Function.identity(), (id1, id2) -> id1));
        }
        catch (VisRecommenderWrapperException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ColumnNotFoundException) {
                throw (ColumnNotFoundException)cause;
            }
            LOGGER.warn(UNEXPECTED_EXCEPTION, cause);
            return Collections.emptyMap();
        }
    }

    private IDataColumn manufactureIDataCol(ItemType item) {
        if (item.getQueryItem() != null) {
            QueryItem qi = item.getQueryItem();
            ColumnInfo columnInfo = new ColumnInfo();
            columnInfo.setIdForExpression(qi.getIdForExpression());
            columnInfo.setUsage(UsageType.fromValue((String)qi.getUsage().value()));
            columnInfo.setId(qi.getIdentifier());
            columnInfo.setExpression(qi.getExpression());
            columnInfo.setName(qi.getLabel());
            if (qi.getDatatype() != null) {
                columnInfo.setDataType(ModuleDataTypeUtil.createDataType((String)qi.getDatatype()));
            } else {
                columnInfo.setDataType((DataType)DataTypes.getUnknownType());
            }
            return new DataColumn(columnInfo);
        }
        return null;
    }

    private Stream<IBindingResult> getChartBindingResults(Locale locale, IChartDescriptor chart, FeatureExtracter extractor, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, boolean forceBinding) {
        List results = extractor.cloneFeatureSets().stream().flatMap(f -> {
            try {
                return chart.bindChartElements(locale, bound, boundColumnInfo, this.bindingParams, (List<ExtractedFeatureSet>)f, forceBinding).stream();
            }
            catch (ImpossibleBindingException | InvalidColumnBindingException | InvalidColumnInfoException exc) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (extractor.hasLocations()) {
            List<IBindingResult> catResults = this.bindWithLocationsAsGenericCategory(locale, chart, bound, boundColumnInfo, extractor, forceBinding);
            results.addAll(catResults);
        }
        return results.stream();
    }

    private List<IBindingResult> bindInternalCharts(Locale locale, List<IChartDescriptor> charts, FeatureExtracter extractor, FeatureExtracter extractorHierarchy, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, boolean forceBinding) {
        return charts.stream().flatMap(c -> {
            Stream<Object> resultStream = Stream.empty();
            if (c.acceptsHierarchicalColumns()) {
                resultStream = this.getChartBindingResults(locale, (IChartDescriptor)c, extractorHierarchy, bound, boundColumnInfo, forceBinding);
            }
            return Stream.concat(resultStream, this.getChartBindingResults(locale, (IChartDescriptor)c, extractor, bound, boundColumnInfo, forceBinding));
        }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private List<IBindingResult> bindInternalCharts(Locale locale, List<IChartDescriptor> charts, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unbound, List<IDataColumn> unboundColumnsHierarchy, List<LogicalGroup> aggregatedLogicalGroups, boolean forceBinding) {
        try {
            FeatureExtracter extractor = this.extractFeatures(unbound, noBehaviors, Collections.emptyMap(), Collections.emptyList(), true, aggregatedLogicalGroups, Collections.emptyMap());
            FeatureExtracter extractorHierarchy = this.extractFeatures(unboundColumnsHierarchy, noBehaviors, Collections.emptyMap(), Collections.emptyList(), false, Collections.emptyList(), Collections.emptyMap());
            return this.bindInternalCharts(locale, charts, extractor, extractorHierarchy, bound, boundColumnInfo, forceBinding);
        }
        catch (InvalidColumnInfoException e) {
            return Collections.emptyList();
        }
    }

    private static List<IBindingResult> bindExternalCharts(Locale locale, List<IExternalChartDescriptor> charts, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unbound, boolean forceBinding) {
        List<IBindingResult> results = charts.stream().flatMap(c -> {
            try {
                return c.bind(locale, bound, boundColumnInfo, unbound, forceBinding).stream();
            }
            catch (BindingException exc) {
                return null;
            }
        }).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (results.isEmpty() && !charts.isEmpty()) {
            IExternalChartDescriptor chart = charts.get(0);
            List<String> unbounds = unbound.stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList());
            results.add(new BindingResult(locale, chart.getName(), bound, unbounds, 0, chart.getPreference()));
        }
        return results;
    }

    private List<IDataColumn> mergeHierarchicalColumns(SmartsModule smartsModule, List<Binding> boundColumns, List<IDataColumn> unbound, Map<String, IFilter> columnFilterMap, List<ItemType> hiddenItems) {
        this.checkBoundColumnsForUpdateableHierarchies(smartsModule, boundColumns, unbound, columnFilterMap, hiddenItems);
        unbound = IDataColumn.formHierarchy(unbound);
        return unbound;
    }

    private void addUnboundColumnsToBoundHierarchy(List<IDataColumn> hierarchy, List<IDataColumn> bound, List<IDataColumn> unbound) {
        ListIterator<IDataColumn> itr = unbound.listIterator();
        while (itr.hasNext()) {
            IDataColumn unboundCol = itr.next();
            if (!hierarchy.contains(unboundCol) || bound.contains(unboundCol)) continue;
            bound.add(unboundCol);
            itr.remove();
        }
    }

    private void checkBoundColumnsForUpdateableHierarchies(SmartsModule smartsModule, List<Binding> boundColumns, List<IDataColumn> unbound, Map<String, IFilter> columnFilterMap, List<ItemType> hiddenItems) {
        if (boundColumns == null || boundColumns.isEmpty()) {
            return;
        }
        ListIterator<Binding> iter = boundColumns.listIterator();
        while (iter.hasNext()) {
            List<IDataColumn> bound;
            List hierarchy;
            Binding binding = iter.next();
            ChartElementType type = ChartElementTypes.getTypes().get(binding.getSlot());
            if (type == null || !StdChartConcepts.HIERARCHY.getId().equals(type.getConcept()) || (hierarchy = this.gen.getValidHierarchy(smartsModule, bound = binding.getColumns().stream().map(c -> this.mapColumnToIDataColumn(hiddenItems, smartsModule, (String)c, columnFilterMap, false)).collect(Collectors.toList()), columnFilterMap)) == null || hierarchy.isEmpty()) continue;
            this.addUnboundColumnsToBoundHierarchy(hierarchy, bound, unbound);
            binding = new Binding(GeneratorUtils.toColumnIDs(bound), binding.getSlot(), StdChartConcepts.HIERARCHY.name());
            iter.set(binding);
        }
    }

    private IDataColumn mapColumnToIDataColumn(List<ItemType> hiddenItems, SmartsModule smartsModule, String id, Map<String, IFilter> columnFilterMap, boolean isPrimary) {
        IDataColumn col;
        if (VisRecommenderUtils.getHiddenIdsFromItems(hiddenItems).contains(id)) {
            Map<String, ItemType> hiddenItemMap = VisRecommenderUtils.getIdToHiddenItemMap(hiddenItems);
            col = this.manufactureIDataCol(hiddenItemMap.get(id));
        } else {
            col = this.getColumnInfo(smartsModule, id, columnFilterMap, isPrimary);
        }
        return col;
    }
}

