/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.charts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.icu.text.MessageFormat;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.recommenders.core.utils.VisNLGUtils;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.IChartNLGDescription;
import com.ibm.smarts.visualization.recommender.api.IExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartDescriptionGenerator;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGCodeElement;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGParameters;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGUtils;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementType;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.FilterApplicator;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.TopBottomFilterApplicator;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureExtracter;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import com.ibm.smarts.visualization.recommender.schema.IRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExternalChartDescriptor
extends ChartDescriptor
implements IExternalChartDescriptor,
IChartNLGDescription {
    private int rank = 0;
    protected Map<BindingParams, Double> bindingParams = new EnumMap<BindingParams, Double>(BindingParams.class);
    private static final String IDS_REC_DES_COLUMNS = "IDS_REC_DES_COLUMNS";
    private static final double DEFAULT_FEW_QUANTITY_THRESHOLD = 10.0;
    private static final double DEFAULT_MODERATE_QUANTITY_THRESHOLD = 20.0;
    private static final double DEFAULT_CONCEPT_CONFIDENCE_THRESHOLD = 0.0;
    public static final int DEFAULT_TOP_BOTTOM_DOMAIN_SIZE = 10;

    @Override
    public long getNumberOfChartsElements() {
        return this.elements.stream().map(ChartElement::getMaxOccurence).mapToInt(e -> e).sum();
    }

    @JsonCreator
    public ExternalChartDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="labelId") String labelId, @JsonProperty(value="titleId") String titleId, @JsonProperty(value="descriptionId") String descriptionId, @JsonProperty(value="ChartElements") List<ChartElement> elements, @JsonProperty(value="preference") PreferenceLevel preference, @JsonProperty(value="QuantityFewThreshold") Double quantityFewThreshold, @JsonProperty(value="QuantityModerateThreshold") Double quantityModerateThreshold, @JsonProperty(value="ConceptConfidenceThreshold") Double conceptConfidenceThreshold) {
        super(name, labelId, titleId, elements, preference, 0, null, false, true, false);
        this.bindingParams.put(BindingParams.QUANTITY_FEW_THRESHOLD, quantityFewThreshold != null ? quantityFewThreshold : 10.0);
        this.bindingParams.put(BindingParams.QUANTITY_MODERATE_THRESHOLD, quantityModerateThreshold != null ? quantityModerateThreshold : 20.0);
        this.bindingParams.put(BindingParams.CONCEPT_CONFIDENCE_THRESHOLD, conceptConfidenceThreshold != null ? conceptConfidenceThreshold : 0.0);
    }

    @Override
    public ExternalRecommendedVisualization recommend(String combinationId, List<IDataColumn> columns, List<Binding> constraints, VisualizationParameters parameters) {
        Locale locale;
        FilterApplicator filterApplicator;
        ExternalRecommendedVisualization recommendation;
        FeatureExtracter extracter = new FeatureExtracter(columns);
        try {
            extracter.extractFeatures(this.bindingParams, Function.identity(), true, Collections.emptyList(), false);
        }
        catch (InvalidColumnInfoException e1) {
            return null;
        }
        List rangeElements = this.elements.stream().filter(e -> e.getMaxOccurence() > 1).collect(Collectors.toList());
        if (columns.size() < this.elements.size() && rangeElements.isEmpty()) {
            return null;
        }
        BiFunction<List, List, ExternalRecommendedVisualization> recommend = (features, inBindings) -> {
            List bindings = inBindings != null && !inBindings.isEmpty() ? inBindings : this.bindChartElements((List<ExtractedFeatureSet>)features);
            if (bindings.isEmpty()) {
                return null;
            }
            List boundSlots = bindings.stream().map(Binding::getSlot).collect(Collectors.toList());
            List unboundElements = this.elements.stream().filter(e -> !boundSlots.contains(e.getType().getSlot())).filter(e -> !rangeElements.contains(e)).collect(Collectors.toList());
            if (!unboundElements.isEmpty()) {
                return null;
            }
            return new ExternalRecommendedVisualization(this, bindings, this.getScore(), this.rank, combinationId);
        };
        List<List<ExtractedFeatureSet>> features2 = extracter.getFeatures();
        if (!parameters.getColumnTopBottomFilterMap().isEmpty()) {
            TopBottomFilterApplicator topBottomFilterApplicator = new TopBottomFilterApplicator(parameters.getColumnTopBottomFilterMap(), this.bindingParams, 10);
            features2 = topBottomFilterApplicator.apply(features2);
        }
        if ((recommendation = (ExternalRecommendedVisualization)(features2 = (filterApplicator = new FilterApplicator(parameters.getBaseFilterList())).apply(features2)).stream().map(f -> (ExternalRecommendedVisualization)recommend.apply((List)f, constraints)).filter(Objects::nonNull).findFirst().orElse(null)) == null && extracter.hasLocations()) {
            FeatureExtracter catExtracter = new FeatureExtracter(extracter);
            catExtracter.convertLocationsToCategories();
            recommendation = catExtracter.getFeatures().stream().map(f -> (ExternalRecommendedVisualization)recommend.apply((List)f, constraints)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        Locale locale2 = locale = parameters != null && parameters.getRequestContext() != null ? parameters.getRequestContext().locale : null;
        if (recommendation != null && locale != null) {
            this.generateNaturalLanguage(recommendation, extracter.getFeatures().get(0), locale, columns);
        }
        return recommendation;
    }

    private List<Binding> checkInvalidSlots(List<Binding> boundColumns, Set<String> availableSlots) throws BindingException {
        List unfoundSlots = boundColumns.stream().map(Binding::getSlot).filter(s -> !availableSlots.contains(s)).collect(Collectors.toList());
        if (!unfoundSlots.isEmpty()) {
            throw new BindingException("slot does not exist: " + unfoundSlots);
        }
        return boundColumns;
    }

    @Override
    public List<IBindingResult> bind(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unboundColumns, boolean forceBinding) throws BindingException {
        FeatureExtracter extracter = new FeatureExtracter(unboundColumns);
        Set<String> validSlots = this.elements.stream().map(c -> c.getType().getSlot()).collect(Collectors.toSet());
        List<Binding> boundColumns = this.checkInvalidSlots(bound, validSlots);
        try {
            extracter.extractFeatures(this.bindingParams, Function.identity(), true, Collections.emptyList(), false);
        }
        catch (InvalidColumnInfoException e) {
            throw new BindingException(String.format("Chart %s cannot bind %s", this.getName(), unboundColumns));
        }
        Function<List, Stream> binder = fl -> {
            try {
                return super.bindChartElements(locale, boundColumns, boundColumnInfo, this.bindingParams, (List<ExtractedFeatureSet>)fl, forceBinding).stream();
            }
            catch (InvalidColumnBindingException | InvalidColumnInfoException e) {
                return null;
            }
        };
        List<IBindingResult> result = extracter.cloneFeatureSets().stream().flatMap(binder).filter(Objects::nonNull).collect(Collectors.toList());
        if (extracter.hasLocations()) {
            FeatureExtracter catExtracter = new FeatureExtracter(extracter);
            catExtracter.convertLocationsToCategories();
            result.addAll(catExtracter.getFeatures().stream().flatMap(binder).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public boolean validateBindings(List<IDataColumn> columns, List<Binding> bindings) {
        FeatureExtracter extracter = new FeatureExtracter(columns);
        try {
            extracter.extractFeatures(this.bindingParams, Function.identity(), true, Collections.emptyList(), false);
        }
        catch (InvalidColumnInfoException e1) {
            return false;
        }
        return extracter.getFeatures().stream().anyMatch(f -> this.validateBindings((List<ExtractedFeatureSet>)f, bindings, ChartElementFeatureMismatch.getTypeMatchMinScore()));
    }

    @Override
    public String getDescription(Map<String, List<String>> parameters, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        String labelString = this.getStringFromBundle(bundle, IDS_REC_DES_COLUMNS);
        labelString = VisNLGUtils.removeUnusedParameters(labelString, parameters);
        MessageFormat fLabel = new MessageFormat(labelString, bundle.getLocale());
        return fLabel.format(VisNLGUtils.flattenParameters(parameters));
    }

    @Override
    public List<String> getSlots() {
        return this.getChartElements().stream().map(ChartElement::getType).map(ChartElementType::getSlot).collect(Collectors.toList());
    }

    @Override
    public boolean hasNLG(Locale loc) {
        return ChartNLGUtils.NLGSupported(loc);
    }

    @Override
    public Optional<ChartDescription> processNaturalLanguage(List<ExtractedFeatureSet> features, Map<String, String> idToName, List<Binding> columnBinding, Locale loc) {
        ChartNLGCodeElement parameter = null;
        Optional<ChartNLGCodeElement> opt = ChartDescriptionGenerator.getMatchingPattern(columnBinding);
        if (opt.isPresent()) {
            parameter = opt.get();
        }
        return ChartNLGUtils.generateChartDescription(new ChartNLGParameters(this.getName(), parameter), features, new HashMap<String, List<String>>(), idToName, loc);
    }

    public void generateNaturalLanguage(IRecommendedVisualization recommendation, List<ExtractedFeatureSet> features, Locale locale, List<IDataColumn> columns) {
        Map<String, String> idToName = this.getMapColumnIdForExpresionToColumnName(columns);
        Map<String, List<String>> parameters = this.getParameters(recommendation.getColumnBindings(), idToName);
        parameters.putAll(ChartDescriptionGenerator.getSpecialParameters(recommendation.getColumnBindings(), idToName));
        if (this.hasNLG(locale)) {
            Optional<ChartDescription> cd = this.processNaturalLanguage(features, idToName, recommendation.getColumnBindings(), locale);
            if (cd.isPresent()) {
                recommendation.setNaturalLanguage(cd.get().getLabel(), cd.get().getTitle(), cd.get().getDescription(), cd.get().getLocale());
            } else {
                recommendation.setNaturalLanguage(this.getLabel(parameters, locale), this.getTitle(parameters, locale), this.getDescription(parameters, locale), locale);
            }
        } else {
            recommendation.setNaturalLanguage(this.getLabel(parameters, locale), this.getTitle(parameters, locale), this.getDescription(parameters, locale), locale);
        }
    }

    protected Map<String, List<String>> getParameters(List<Binding> bindings, Map<String, String> idToName) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (Binding b : bindings) {
            String slot = b.getSlot();
            ArrayList<String> columnNameList = (ArrayList<String>)parameters.get(slot);
            if (columnNameList == null) {
                columnNameList = new ArrayList<String>();
            }
            for (String col : b.getColumns()) {
                columnNameList.add(idToName.get(col));
            }
            parameters.put(slot, columnNameList);
        }
        return parameters;
    }

    protected boolean genericNLGGeneration(BindingResult binding, List<IDataColumn> columns, Locale locale) {
        Optional<ChartNLGCodeElement> pattern;
        if (ChartNLGUtils.NLGSupported(locale) && (pattern = ChartDescriptionGenerator.getMatchingPattern(binding.getBinding())).isPresent()) {
            ChartNLGParameters p = new ChartNLGParameters(this.getName(), pattern.get());
            List<ExtractedFeatureSet> features = ChartNLGUtils.getFeaturesForDescription(columns);
            Map<String, String> idToName = this.getMapColumnIdForExpresionToColumnName(columns);
            Map<String, List<String>> parameters = ChartDescriptionGenerator.getNamedParameters(binding.getBinding(), idToName);
            Optional<ChartDescription> des = ChartNLGUtils.generateChartDescription(p, features, parameters, idToName, locale);
            if (des.isPresent()) {
                binding.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
                return true;
            }
        }
        return false;
    }

    protected Optional<ChartDescription> genericNLGGeneration(List<Binding> binding, List<IDataColumn> columns, Locale locale) {
        Optional<ChartNLGCodeElement> pattern;
        if (ChartNLGUtils.NLGSupported(locale) && (pattern = ChartDescriptionGenerator.getMatchingPattern(binding)).isPresent()) {
            ChartNLGParameters p = new ChartNLGParameters(this.getName(), pattern.get());
            List<ExtractedFeatureSet> features = ChartNLGUtils.getFeaturesForDescription(columns);
            Map<String, String> idToName = this.getMapColumnIdForExpresionToColumnName(columns);
            Map<String, List<String>> parameters = ChartDescriptionGenerator.getNamedParameters(binding, idToName);
            return ChartNLGUtils.generateChartDescription(p, features, parameters, idToName, locale);
        }
        return Optional.empty();
    }
}

