/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.featureAdapters;

import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.Numeric;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.FeatureAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.AutoGrouping;
import java.util.List;
import java.util.Optional;

public class AutoGroupingAllMeasure
implements FeatureAdapter {
    private final int AUTO_GROUPING_DEFAULT_SIZE = 10;

    @Override
    public List<List<ExtractedFeatureSet>> apply(List<List<ExtractedFeatureSet>> features) {
        if (features.stream().anyMatch(fl -> fl.stream().anyMatch(f -> f.getColumn().getDataSet().isDimensional()))) {
            return features;
        }
        if (features.size() > 1 && features.stream().allMatch(l -> l.stream().allMatch(f -> f.getFeatureType().equals((Object)BasicType.MEASURE)))) {
            Optional<List> primary = features.stream().filter(l -> ((ExtractedFeatureSet)l.get(0)).getColumn().isPrimary()).findFirst();
            List<ExtractedFeatureSet> primaryFeatures = primary.isPresent() ? primary.get() : features.get(0);
            Optional<ExtractedFeatureSet> feature = primaryFeatures.stream().filter(f -> f.getConcept().equals("NONE")).findFirst();
            if (feature.isPresent()) {
                primaryFeatures.add(this.convert(feature.get()));
            } else {
                primaryFeatures.add(this.convert(primaryFeatures.get(0)));
            }
        }
        return features;
    }

    private ExtractedFeatureSet convert(ExtractedFeatureSet measure) {
        ExtractedFeatureSet category = new ExtractedFeatureSet(measure);
        category.setType(BasicType.CATEGORY);
        category.setQuantity(Quantity.MODERATE);
        category.setNumeric(Numeric.NONE);
        category.setConcept("NONE");
        category.setGrouping(new AutoGrouping(10));
        return category;
    }
}

