/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.featureAdapters;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilteringMethod;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.FeatureAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopBottomFilterApplicator
implements FeatureAdapter {
    private final int defaultDomainSize;
    Map<String, TopBottomFilter> topBottomFilterMap;
    Map<BindingParams, Double> thresholds;

    public TopBottomFilterApplicator(Map<String, TopBottomFilter> topBottomFilterMap, Map<BindingParams, Double> thresholds, int defaultDomainSize) {
        this.topBottomFilterMap = topBottomFilterMap;
        this.thresholds = thresholds;
        this.defaultDomainSize = defaultDomainSize;
    }

    @Override
    public List<List<ExtractedFeatureSet>> apply(List<List<ExtractedFeatureSet>> features) {
        HashSet<IDataColumn> measures = new HashSet<IDataColumn>();
        HashSet<IDataColumn> categories = new HashSet<IDataColumn>();
        HashSet<IDataColumn> duals = new HashSet<IDataColumn>();
        for (List<ExtractedFeatureSet> featureList2 : features) {
            boolean isMeasure = false;
            boolean isCategory = false;
            for (ExtractedFeatureSet feature : featureList2) {
                if (feature.getFeatureType().equals((Object)BasicType.MEASURE)) {
                    isMeasure = true;
                    continue;
                }
                isCategory = true;
            }
            if (isMeasure && isCategory) {
                duals.add(featureList2.get(0).getColumn());
                continue;
            }
            if (isMeasure) {
                measures.add(featureList2.get(0).getColumn());
                continue;
            }
            categories.add(featureList2.get(0).getColumn());
        }
        features.forEach(featureList -> featureList.forEach(f -> {
            TopBottomFilter filter = this.topBottomFilterMap.get(f.getColumnId());
            if (filter != null) {
                this.applyFilter((ExtractedFeatureSet)f, filter, measures, categories, duals);
            }
        }));
        return features;
    }

    private void applyFilter(ExtractedFeatureSet feature, TopBottomFilter filter, Set<IDataColumn> measures, Set<IDataColumn> categories, Set<IDataColumn> duals) {
        int domainSize;
        int n = domainSize = filter.getDomainSize() > 0 ? filter.getDomainSize() : this.defaultDomainSize;
        if (filter.getMethod().equals((Object)TopBottomFilteringMethod.PERCENTAGE)) {
            domainSize = (int)((double)domainSize / 100.0 * (double)feature.getColumn().getQuantity());
        }
        if (filter.getByColumn() == null && categories.contains(feature.getColumn())) {
            return;
        }
        if (!feature.getFeatureType().equals((Object)BasicType.MEASURE)) {
            feature.setQuantity(ExtractedFeatureSet.getQuantity((double)this.thresholds.get((Object)BindingParams.QUANTITY_FEW_THRESHOLD), (double)this.thresholds.get((Object)BindingParams.QUANTITY_MODERATE_THRESHOLD), domainSize));
        }
    }
}

