/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.featureAdapters;

import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilter;
import com.ibm.smarts.common.modifiers.TopBottomFilterType;
import com.ibm.smarts.common.modifiers.TopBottomFilteringMethod;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.FeatureAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TopBottomFilterCategoryHighDomain
implements FeatureAdapter {
    private final int defaultDomainSize;

    public TopBottomFilterCategoryHighDomain(int defaultDomainSize) {
        this.defaultDomainSize = defaultDomainSize;
    }

    @Override
    public List<List<ExtractedFeatureSet>> apply(List<List<ExtractedFeatureSet>> features) {
        List<ExtractedFeatureSet> candidateMeasure;
        HashSet<List<ExtractedFeatureSet>> measures = new HashSet<List<ExtractedFeatureSet>>();
        HashSet<List<ExtractedFeatureSet>> duals = new HashSet<List<ExtractedFeatureSet>>();
        List<ExtractedFeatureSet> primary = Collections.emptyList();
        ArrayList<List<ExtractedFeatureSet>> hiDomainFeatures = new ArrayList<List<ExtractedFeatureSet>>();
        for (List<ExtractedFeatureSet> featureList : features) {
            boolean isMeasure = false;
            boolean bl = false;
            boolean isHiDomain = false;
            boolean isUsageFact = true;
            for (ExtractedFeatureSet feature : featureList) {
                if (feature.getColumn().getSemanticInfo() == null || feature.getColumn().getSemanticInfo().getUsage() == null || !feature.getColumn().getSemanticInfo().getUsage().equals((Object)UsageType.FACT)) {
                    isUsageFact = false;
                }
                if (feature.getFeatureType().equals((Object)BasicType.MEASURE)) {
                    isMeasure = true;
                    continue;
                }
                bl = true;
                if (!feature.getQuantity().equals((Object)Quantity.MANY)) continue;
                isHiDomain = true;
            }
            if (isHiDomain) {
                hiDomainFeatures.add(featureList);
            }
            if (isMeasure && bl && isUsageFact) {
                duals.add(featureList);
            } else if (isMeasure && isUsageFact) {
                measures.add(featureList);
            }
            if (!featureList.get(0).getColumn().isPrimary()) continue;
            primary = featureList;
        }
        if (hiDomainFeatures.isEmpty()) {
            return features;
        }
        if (measures.isEmpty() && duals.isEmpty()) {
            return features;
        }
        List<ExtractedFeatureSet> p = primary;
        if (measures.isEmpty()) {
            Optional<List<ExtractedFeatureSet>> nonPrimaryDual = this.selectCandidate(duals, false, p);
            candidateMeasure = nonPrimaryDual.isPresent() ? nonPrimaryDual.get() : (List<ExtractedFeatureSet>)duals.iterator().next();
            hiDomainFeatures.remove(candidateMeasure);
            duals.remove(candidateMeasure);
            candidateMeasure.removeIf(f -> !f.getFeatureType().equals((Object)BasicType.MEASURE));
        } else {
            Optional<List<ExtractedFeatureSet>> primaryMeasure = this.selectCandidate(measures, true, p);
            candidateMeasure = primaryMeasure.isPresent() ? primaryMeasure.get() : (List)measures.iterator().next();
        }
        for (List list : hiDomainFeatures) {
            boolean isPureCategory;
            boolean bl = isPureCategory = !duals.contains(list);
            if (!isPureCategory) {
                list.removeIf(f -> !f.getFeatureType().equals((Object)BasicType.MEASURE));
                continue;
            }
            List hiDomainfeatures = list.stream().filter(f -> !f.getFeatureType().equals((Object)BasicType.MEASURE)).collect(Collectors.toList());
            for (ExtractedFeatureSet feature : hiDomainfeatures) {
                this.convert(feature, isPureCategory, ((ExtractedFeatureSet)candidateMeasure.get(0)).getColumn().getIdForExpression());
            }
        }
        return features;
    }

    private Optional<List<ExtractedFeatureSet>> selectCandidate(Set<List<ExtractedFeatureSet>> candidates, boolean preferPrimary, List<ExtractedFeatureSet> primary) {
        Optional<List<ExtractedFeatureSet>> candidate = Optional.empty();
        for (List<ExtractedFeatureSet> features : candidates) {
            if (features.equals(primary)) {
                if (!preferPrimary) continue;
                return Optional.of(features);
            }
            if (candidate.isPresent() && candidate.get().get(0).getColumnId().compareTo(features.get(0).getColumnId()) <= 0) continue;
            candidate = Optional.of(features);
        }
        return candidate;
    }

    private void convert(ExtractedFeatureSet hiDomain, boolean isPureCategory, String byColumn) {
        hiDomain.setQuantity(Quantity.MODERATE);
        hiDomain.getFilters().add((BaseFilter)new TopBottomFilter(hiDomain.getColumnId(), "", "", TopBottomFilterType.TOP, TopBottomFilteringMethod.COUNT, isPureCategory ? byColumn : null, this.defaultDomainSize));
    }
}

