/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.learning;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.ibm.smarts.common.util.CommonJAXBHelper;
import com.ibm.smarts.visualization.recommender.internal.learning.PreferedChart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChartPreferenceContext {
    private List<Double> contextVector;
    private Map<String, List<PreferedChart>> chartPreferenceMap;

    public ChartPreferenceContext() {
        this.contextVector = new ArrayList<Double>();
        this.chartPreferenceMap = new HashMap<String, List<PreferedChart>>();
    }

    public ChartPreferenceContext(List<Double> context) {
        this.contextVector = context;
        this.chartPreferenceMap = new HashMap<String, List<PreferedChart>>();
    }

    public void addChartPreference(PreferedChart chart) {
        List charts = this.chartPreferenceMap.computeIfAbsent(chart.getChartName(), aChart -> new ArrayList());
        charts.add(chart);
    }

    public List<PreferedChart> getChartPreference(String chartName) {
        return this.chartPreferenceMap.getOrDefault(chartName, Collections.emptyList());
    }

    public List<Double> getContextVector() {
        return this.contextVector;
    }

    public void setContextVector(List<Double> contextVector) {
        this.contextVector = contextVector;
    }

    @JsonAnyGetter
    public Map<String, List<PreferedChart>> getChartPreferenceMap() {
        return this.chartPreferenceMap;
    }

    @JsonAnySetter
    public void addChartPreference(String chart, List<PreferedChart> preferences) {
        this.chartPreferenceMap.put(chart, preferences);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChartPreferenceContext)) {
            return false;
        }
        ChartPreferenceContext that = (ChartPreferenceContext)o;
        return Objects.equals(this.getContextVector(), that.getContextVector()) && Objects.equals(this.getChartPreferenceMap(), that.getChartPreferenceMap());
    }

    public int hashCode() {
        return Objects.hash(this.getContextVector(), this.getChartPreferenceMap());
    }

    public String toString() {
        return "ChartPreferenceContext{contextVector=" + this.contextVector + ", chartPreferenceMap=" + this.chartPreferenceMap + '}';
    }

    public static ChartPreferenceContext fromJSON(String json) {
        return (ChartPreferenceContext)CommonJAXBHelper.unmarshalFromJSON(ChartPreferenceContext.class, (String)json);
    }

    public String toJSON() {
        return CommonJAXBHelper.marshalToJSON((Object)this, (boolean)true);
    }
}

