/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.modeling;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.model.datatype.DataType;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.UsageType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.Numeric;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.internal.modeling.AxisType;
import com.ibm.smarts.visualization.recommender.schema.AutoGrouping;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractedFeatureSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractedFeatureSet.class);
    private static final int MAX_CONCEPT_NUM = 6;
    private String columnId;
    private int instance;
    protected AxisType axis = AxisType.X;
    protected BasicType type = BasicType.NONE;
    protected Quantity quantity = Quantity.NONE;
    protected int distinctCount;
    protected Numeric numeric = Numeric.NONE;
    protected String concept = "NONE";
    protected boolean positive;
    protected boolean nullable;
    protected double coefficientOfVariance;
    protected IDataColumn column;
    protected ChartElement chartElement;
    protected Set<ChartElementFeatureMismatch> bindWarnings;
    private static final double HIGH_VARIANCE_THRESHOLD = 0.5;
    private AutoGrouping grouping;
    private AggregationType aggregation;
    List<BaseFilter> filters = new ArrayList<BaseFilter>();

    protected ExtractedFeatureSet() {
    }

    ExtractedFeatureSet(AxisType type) {
        this.axis = type;
    }

    public ExtractedFeatureSet(ExtractedFeatureSet other) {
        this.quantity = other.quantity;
        this.numeric = other.numeric;
        this.positive = other.positive;
        this.nullable = other.nullable;
        this.concept = other.concept;
        this.type = other.type;
        this.axis = other.axis;
        this.column = other.column;
        this.columnId = other.columnId;
        this.instance = other.instance;
        this.distinctCount = other.distinctCount;
        this.coefficientOfVariance = other.coefficientOfVariance;
        this.grouping = other.grouping;
        this.aggregation = other.aggregation;
        this.filters.addAll(other.filters);
    }

    private static List<String> extractExtraConcepts(IDataColumn column, ExtractedFeatureSet feature) {
        ArrayList<String> concepts = new ArrayList<String>();
        if (column.isHierchical()) {
            concepts.add(StdChartElements.HIERARCHY.name());
        }
        if (feature.distinctCount == 2) {
            concepts.add(StdChartElements.BIVALUED.name());
        }
        if (column.getFlatListOfConcepts().contains(BasicType.DATE.getOntologyConcept())) {
            concepts.add(StdChartElements.ORDINAL.name());
        }
        return concepts;
    }

    private static List<String> extractConcepts(ExtractedFeatureSet feature, List<String> conceptIds, Map<BasicType, Set<String>> typeConceptsMap, IDataColumn column, boolean exploerWithoutConcept) {
        ArrayList<String> concepts = new ArrayList<String>();
        concepts.addAll(ExtractedFeatureSet.extractExtraConcepts(column, feature));
        Set allConcepts = typeConceptsMap.getOrDefault((Object)feature.type, Collections.emptySet());
        concepts.addAll(conceptIds.stream().filter(allConcepts::contains).limit(6L).collect(Collectors.toList()));
        if (concepts.isEmpty() || exploerWithoutConcept) {
            concepts.add("NONE");
        }
        return concepts;
    }

    private static ExtractedFeatureSet extractMeasureFeature(IDataColumn column, int instance) {
        ExtractedFeatureSet feature = new ExtractedFeatureSet();
        feature.column = column;
        feature.columnId = column.getIdForExpression();
        feature.instance = instance;
        double mean = column.getMean().doubleValue();
        double stdDev = column.getStdDev().doubleValue();
        feature.nullable = column.isNullable();
        feature.numeric = Numeric.NUMERIC;
        feature.type = BasicType.MEASURE;
        feature.positive = column.getMin().doubleValue() >= 0.0;
        feature.coefficientOfVariance = mean == 0.0 ? 1.0 : stdDev / mean;
        return feature;
    }

    private static ExtractedFeatureSet createCategoricalFeature(IDataColumn column, double featureQuantityFewThreshold, double featureQuantityModerateThreshold, int instance) {
        ExtractedFeatureSet feature = new ExtractedFeatureSet();
        feature.column = column;
        feature.columnId = column.getIdForExpression();
        feature.instance = instance;
        feature.distinctCount = column.getQuantity();
        feature.nullable = column.isNullable();
        feature.quantity = ExtractedFeatureSet.getQuantity(featureQuantityFewThreshold, featureQuantityModerateThreshold, column);
        return feature;
    }

    private static ExtractedFeatureSet extractCategoricalFeature(IDataColumn column, double featureQuantityFewThreshold, double featureQuantityModerateThreshold, List<String> conceptIds, int instance) {
        ExtractedFeatureSet feature = ExtractedFeatureSet.createCategoricalFeature(column, featureQuantityFewThreshold, featureQuantityModerateThreshold, instance);
        feature.type = conceptIds.contains(BasicType.LOCATION.getOntologyConcept()) ? BasicType.LOCATION : (conceptIds.contains(BasicType.DATE.getOntologyConcept()) ? BasicType.DATE : BasicType.CATEGORY);
        return feature;
    }

    private static ExtractedFeatureSet extractFeatureUsingDataType(IDataColumn column, double featureQuantityFewThreshold, double featureQuantityModerateThreshold, int instance) {
        DataType type = column.getDataType();
        ExtractedFeatureSet feature = ExtractedFeatureSet.createCategoricalFeature(column, featureQuantityFewThreshold, featureQuantityModerateThreshold, instance);
        if (type == null || type.isUnknown()) {
            feature.type = BasicType.CATEGORY;
        } else if (type.isNumeric()) {
            feature = ExtractedFeatureSet.extractMeasureFeature(column, instance);
            feature.type = BasicType.MEASURE;
        } else {
            feature.type = type.isTemporal() ? BasicType.DATE : BasicType.CATEGORY;
        }
        return feature;
    }

    public static List<ExtractedFeatureSet> extractFeatures(Map<BindingParams, Double> thresholds, IDataColumn column, List<ConceptInfo> conceptInfos, Map<BasicType, Set<String>> typeConceptsMap, boolean exploerWithoutConcept, int instance, boolean minimalExtraction) {
        double conceptConfidenceThreshold = thresholds.getOrDefault((Object)BindingParams.CONCEPT_CONFIDENCE_THRESHOLD, 0.0);
        double featureQuantityFewThreshold = thresholds.getOrDefault((Object)BindingParams.QUANTITY_FEW_THRESHOLD, 0.0);
        double featureQuantityModerateThreshold = thresholds.getOrDefault((Object)BindingParams.QUANTITY_MODERATE_THRESHOLD, 0.0);
        List<String> conceptIds = conceptInfos.stream().filter(c -> (double)c.getConfidence() > conceptConfidenceThreshold).map(ConceptInfo::getConceptID).collect(Collectors.toList());
        Set featureTypeSet = Arrays.asList(BasicType.MEASURE.getOntologyConcept(), BasicType.CATEGORY.getOntologyConcept(), BasicType.DATE.getOntologyConcept(), BasicType.LOCATION.getOntologyConcept()).stream().collect(Collectors.toSet());
        Map<Boolean, List<ConceptInfo>> typePartition = conceptInfos.stream().filter(c -> featureTypeSet.contains(c.getConceptID())).sorted(Comparator.comparingDouble(ConceptInfo::getConfidence).reversed()).collect(Collectors.partitioningBy(c -> c.getConceptID().equals(BasicType.MEASURE.getOntologyConcept())));
        List<ConceptInfo> categories = typePartition.get(false);
        List<ConceptInfo> measures = typePartition.get(true);
        ArrayList<ExtractedFeatureSet> features = new ArrayList<ExtractedFeatureSet>();
        if (categories.isEmpty() && measures.isEmpty() || minimalExtraction) {
            LOGGER.warn("No type concept info found for column {}", (Object)column.getIdForExpression());
            ExtractedFeatureSet feature = ExtractedFeatureSet.extractFeatureUsingDataType(column, featureQuantityFewThreshold, featureQuantityModerateThreshold, instance);
            features.add(feature);
            return features;
        }
        ExtractedFeatureSet measureFeature = null;
        ExtractedFeatureSet categoryFeature = null;
        if (!categories.isEmpty() && ((double)categories.get(0).getConfidence() > conceptConfidenceThreshold || measures.isEmpty())) {
            categoryFeature = ExtractedFeatureSet.extractCategoricalFeature(column, featureQuantityFewThreshold, featureQuantityModerateThreshold, conceptIds, instance);
            features.add(categoryFeature);
        } else if (column.getUsageType() != UsageType.AUTOMATIC && column.getUsageType() != UsageType.FACT) {
            categoryFeature = ExtractedFeatureSet.extractCategoricalFeature(column, featureQuantityFewThreshold, featureQuantityModerateThreshold, Collections.singletonList(BasicType.CATEGORY.getOntologyConcept()), instance);
            features.add(categoryFeature);
        }
        if (!measures.isEmpty() && ((double)measures.get(0).getConfidence() > conceptConfidenceThreshold || categories.isEmpty())) {
            measureFeature = ExtractedFeatureSet.extractMeasureFeature(column, instance);
            features.add(measureFeature);
        }
        if (features.isEmpty()) {
            if (categories.get(0).getConfidence() > measures.get(0).getConfidence()) {
                categoryFeature = ExtractedFeatureSet.extractCategoricalFeature(column, featureQuantityFewThreshold, featureQuantityModerateThreshold, conceptIds, instance);
                features.add(categoryFeature);
            } else if (categories.get(0).getConfidence() < measures.get(0).getConfidence()) {
                measureFeature = ExtractedFeatureSet.extractMeasureFeature(column, instance);
                features.add(measureFeature);
            } else {
                categoryFeature = ExtractedFeatureSet.extractCategoricalFeature(column, featureQuantityFewThreshold, featureQuantityModerateThreshold, conceptIds, instance);
                features.add(categoryFeature);
                measureFeature = ExtractedFeatureSet.extractMeasureFeature(column, instance);
                features.add(measureFeature);
            }
        }
        List concepts = features.stream().flatMap(f -> ExtractedFeatureSet.extractConcepts(f, conceptIds, typeConceptsMap, column, exploerWithoutConcept).stream()).distinct().collect(Collectors.toList());
        return concepts.stream().flatMap(c -> features.stream().map(f -> {
            ExtractedFeatureSet n = new ExtractedFeatureSet((ExtractedFeatureSet)f);
            n.setConcept((String)c);
            return n;
        })).distinct().collect(Collectors.toList());
    }

    public static Quantity getQuantity(double featureQuantityFewThreshold, double featureQuantityModerateThreshold, IDataColumn col) {
        if (col.isQuantityUndefined()) {
            return Quantity.MODERATE;
        }
        return ExtractedFeatureSet.getQuantity(featureQuantityFewThreshold, featureQuantityModerateThreshold, col.getQuantity());
    }

    public static Quantity getQuantity(double featureQuantityFewThreshold, double featureQuantityModerateThreshold, int numOfUniques) {
        if ((double)numOfUniques <= featureQuantityFewThreshold) {
            return Quantity.FEW;
        }
        if ((double)numOfUniques <= featureQuantityModerateThreshold) {
            return Quantity.MODERATE;
        }
        return Quantity.MANY;
    }

    public BasicType getFeatureType() {
        return this.type;
    }

    public void setAxis(AxisType axis) {
        this.axis = axis;
    }

    public void setType(BasicType type) {
        this.type = type;
    }

    public void setQuantity(Quantity q) {
        this.quantity = q;
    }

    public void setNumeric(Numeric n) {
        this.numeric = n;
    }

    public AxisType getAxis() {
        return this.axis;
    }

    public String getConcept() {
        return this.concept;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isHighVariance() {
        return this.coefficientOfVariance > 0.5;
    }

    public List<String> toVector() {
        ArrayList<String> vector = new ArrayList<String>();
        switch (this.type) {
            case CATEGORY: {
                Collections.addAll(vector, this.quantity.toString(), Quantity.NONE.toString(), Quantity.NONE.toString(), this.numeric.toString());
                break;
            }
            case DATE: {
                Collections.addAll(vector, Quantity.NONE.toString(), this.quantity.toString(), Quantity.NONE.toString(), this.numeric.toString());
                break;
            }
            case LOCATION: {
                Collections.addAll(vector, Quantity.NONE.toString(), Quantity.NONE.toString(), this.quantity.toString(), this.numeric.toString());
                break;
            }
            default: {
                Collections.addAll(vector, Quantity.NONE.toString(), Quantity.NONE.toString(), Quantity.NONE.toString(), this.numeric.toString());
            }
        }
        vector.add(this.concept);
        return vector;
    }

    public void setConcept(String concept) {
        this.concept = concept;
    }

    public Quantity getQuantity() {
        return this.quantity;
    }

    public IDataColumn getColumn() {
        return this.column;
    }

    public void setChartElement(ChartElement element) {
        this.chartElement = element;
    }

    public void setChartElement(ChartElement element, Set<ChartElementFeatureMismatch> warnings) {
        this.chartElement = element;
        this.bindWarnings = warnings;
    }

    public ChartElement getChartElement() {
        return this.chartElement;
    }

    public void setInstance(int instance) {
        this.instance = instance;
    }

    public int getDistinctCount() {
        return this.distinctCount;
    }

    public Set<ChartElementFeatureMismatch> getBindWarnings() {
        return this.bindWarnings;
    }

    public AutoGrouping getGrouping() {
        return this.grouping;
    }

    public void setGrouping(AutoGrouping grouping) {
        this.grouping = grouping;
    }

    public AggregationType getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(AggregationType aggregation) {
        this.aggregation = aggregation;
    }

    public List<BaseFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<BaseFilter> filters) {
        this.filters.addAll(filters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtractedFeatureSet)) {
            return false;
        }
        ExtractedFeatureSet that = (ExtractedFeatureSet)o;
        return this.instance == that.instance && this.getDistinctCount() == that.getDistinctCount() && this.isPositive() == that.isPositive() && this.isNullable() == that.isNullable() && Double.compare(that.coefficientOfVariance, this.coefficientOfVariance) == 0 && Objects.equals(this.getColumnId(), that.getColumnId()) && this.getAxis() == that.getAxis() && this.type == that.type && this.getQuantity() == that.getQuantity() && this.numeric == that.numeric && Objects.equals(this.getConcept(), that.getConcept()) && Objects.equals(this.getColumn(), that.getColumn()) && Objects.equals(this.getChartElement(), that.getChartElement()) && Objects.equals(this.getBindWarnings(), that.getBindWarnings()) && Objects.equals(this.getGrouping(), that.getGrouping()) && this.getAggregation() == that.getAggregation() && Objects.equals(this.getFilters(), that.getFilters());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getColumnId(), this.instance, this.getAxis(), this.type, this.getQuantity(), this.getDistinctCount(), this.numeric, this.getConcept(), this.isPositive(), this.isNullable(), this.coefficientOfVariance, this.getColumn(), this.getChartElement(), this.getBindWarnings(), this.getGrouping(), this.getAggregation(), this.getFilters()});
    }

    public String toString() {
        return "ExtractedFeatureSet{columnId='" + this.columnId + '\'' + ", instance=" + this.instance + ", axis=" + (Object)((Object)this.axis) + ", type=" + (Object)((Object)this.type) + ", quantity=" + (Object)((Object)this.quantity) + ", distinctCount=" + this.distinctCount + ", numeric=" + (Object)((Object)this.numeric) + ", concept='" + this.concept + '\'' + ", positive=" + this.positive + ", nullable=" + this.nullable + ", coefficientOfVariance=" + this.coefficientOfVariance + ", column=" + this.column + ", chartElement=" + this.chartElement + ", bindWarnings=" + this.bindWarnings + ", grouping=" + this.grouping + ", aggregation=" + this.aggregation + ", filters=" + this.filters + '}';
    }
}

