/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.modeling;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.ontology.registry.Concept;
import com.ibm.smarts.ontology.registry.ConceptsRegistry;
import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.LogicalGroup;
import com.ibm.smarts.schema.LogicalGroupType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.exceptions.VisRecommenderWrapperException;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartConcepts;
import com.ibm.smarts.visualization.recommender.internal.modeling.BasicTypeAssocConcepts;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureExtracter {
    protected List<IDataColumn> combination;
    protected List<List<ExtractedFeatureSet>> features;
    protected Map<List<ExtractedFeatureSet>, Map<BasicType, List<ExtractedFeatureSet>>> featureSetTypeMap;
    protected boolean hasLocations = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureExtracter.class);

    private static List<ConceptInfo> getFlattenedConceptsList(List<ConceptInfo> ci) {
        if (ci.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConceptInfo> conceptsList = new ArrayList<ConceptInfo>();
        for (ConceptInfo concept : ci) {
            Concept c = ConceptsRegistry.instance().getConcept(concept.getConceptID());
            if (c == null) continue;
            conceptsList.add(concept);
            if (c.getParents().isEmpty()) continue;
            conceptsList.addAll(c.getAncestors().stream().map(a -> a.toConceptInfo(concept.getConfidence())).collect(Collectors.toList()));
        }
        return conceptsList.stream().distinct().collect(Collectors.toList());
    }

    public FeatureExtracter(List<IDataColumn> combination) {
        this.combination = combination;
    }

    public FeatureExtracter(FeatureExtracter other) {
        this.combination = other.combination;
        this.features = other.features.stream().map(this::cloneFearureSet).collect(Collectors.toList());
        this.hasLocations = other.hasLocations;
        this.featureSetTypeMap = this.features.stream().collect(Collectors.toMap(fl -> fl, fl -> fl.stream().collect(Collectors.groupingBy(ExtractedFeatureSet::getFeatureType)), (fl1, fl2) -> fl1));
    }

    public static List<ExtractedFeatureSet> extractFeatureSetFromColumn(IDataColumn column, Map<BindingParams, Double> thresholds, boolean exploreWithoutConcepts, int instance, boolean minimalExtraction) {
        List concepts = column.getSemanticInfo() == null ? Collections.emptyList() : column.getSemanticInfo().getConcepts();
        return ExtractedFeatureSet.extractFeatures(thresholds, column, FeatureExtracter.getFlattenedConceptsList(concepts), BasicTypeAssocConcepts.getInstance().getAssoc(), exploreWithoutConcepts, instance, minimalExtraction);
    }

    private List<ExtractedFeatureSet> cloneFearureSet(List<ExtractedFeatureSet> source) {
        return source.stream().map(ExtractedFeatureSet::new).collect(Collectors.toList());
    }

    public void extractFeatures(Map<BindingParams, Double> thresholds, Function<List<List<ExtractedFeatureSet>>, List<List<ExtractedFeatureSet>>> adapters, boolean exploreWithoutConcepts, List<LogicalGroup> logicalGroups, boolean minimalExtraction) throws InvalidColumnInfoException {
        AtomicInteger instance = new AtomicInteger(1);
        try {
            List featuresPerColumn = this.combination.stream().map(c -> FeatureExtracter.extractFeatureSetFromColumn(c, thresholds, exploreWithoutConcepts, instance.getAndIncrement(), minimalExtraction)).collect(Collectors.toList());
            featuresPerColumn = adapters.apply(featuresPerColumn);
            List columnsFromLogicalGroups = logicalGroups.stream().filter(lg -> lg.getLogicGroupType() != null && lg.getLogicGroupType().equals((Object)LogicalGroupType.SCENARIO)).map(VisRecommenderUtils::getColsWithPlannedActualConcept).filter(Objects::nonNull).collect(Collectors.toList());
            List idsFromCombination = this.combination.stream().map(col -> col.getIdForExpression()).collect(Collectors.toList());
            Optional<Pair> columnsOfInterest = columnsFromLogicalGroups.stream().filter(pair -> idsFromCombination.contains(pair.getLeft()) && idsFromCombination.contains(pair.getRight())).findFirst();
            this.features = VisRecommenderUtils.cartesianProduct(featuresPerColumn);
            if (columnsOfInterest.isPresent()) {
                this.features.stream().filter(fs -> fs.stream().anyMatch(f -> f.getConcept().equals(StdChartConcepts.PLANNED.getId()) && f.getFeatureType().equals((Object)BasicType.MEASURE))).forEach(fs -> {
                    ArrayList copyFeatures = new ArrayList(fs);
                    copyFeatures.forEach(f -> {
                        if (f.getColumnId().equals(((Pair)columnsOfInterest.get()).getLeft()) && f.getFeatureType().equals((Object)BasicType.MEASURE)) {
                            ExtractedFeatureSet converted = new ExtractedFeatureSet((ExtractedFeatureSet)f);
                            converted.setConcept(StdChartConcepts.ACTUAL.getId());
                            fs.remove(f);
                            fs.add(converted);
                        }
                    });
                });
            }
            this.featureSetTypeMap = this.features.stream().collect(Collectors.toMap(fl -> fl, fl -> fl.stream().collect(Collectors.groupingBy(ExtractedFeatureSet::getFeatureType)), (fl1, fl2) -> fl1));
            this.hasLocations = this.featureSetTypeMap.entrySet().stream().map(e -> ((Map)e.getValue()).containsKey((Object)BasicType.LOCATION)).collect(Collectors.toList()).contains(true);
        }
        catch (VisRecommenderWrapperException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof InvalidColumnInfoException) {
                throw (InvalidColumnInfoException)cause;
            }
            LOGGER.warn("Unexpected exception thrown {}", cause);
        }
    }

    public void convertLocationsToCategories() {
        Function<ExtractedFeatureSet, ExtractedFeatureSet> converter = f -> {
            if (f.getFeatureType() == BasicType.LOCATION) {
                ExtractedFeatureSet cf = new ExtractedFeatureSet((ExtractedFeatureSet)f);
                cf.setType(BasicType.CATEGORY);
                return cf;
            }
            return f;
        };
        this.features = this.features.stream().map(lf -> lf.stream().map(converter).collect(Collectors.toList())).collect(Collectors.toList());
        this.featureSetTypeMap = this.features.stream().collect(Collectors.toMap(fl -> fl, fl -> fl.stream().collect(Collectors.groupingBy(ExtractedFeatureSet::getFeatureType)), (fl1, fl2) -> fl1));
    }

    public List<ExtractedFeatureSet> getCategories(List<ExtractedFeatureSet> in) {
        return this.featureSetTypeMap.getOrDefault(in, Collections.emptyMap()).getOrDefault((Object)BasicType.CATEGORY, Collections.emptyList()).stream().map(ExtractedFeatureSet::new).collect(Collectors.toList());
    }

    public List<ExtractedFeatureSet> getDates(List<ExtractedFeatureSet> in) {
        return this.featureSetTypeMap.getOrDefault(in, Collections.emptyMap()).getOrDefault((Object)BasicType.DATE, Collections.emptyList()).stream().map(ExtractedFeatureSet::new).collect(Collectors.toList());
    }

    public List<ExtractedFeatureSet> getLocations(List<ExtractedFeatureSet> in) {
        return this.featureSetTypeMap.getOrDefault(in, Collections.emptyMap()).getOrDefault((Object)BasicType.LOCATION, Collections.emptyList()).stream().map(ExtractedFeatureSet::new).collect(Collectors.toList());
    }

    public List<ExtractedFeatureSet> getMeasures(List<ExtractedFeatureSet> in) {
        return this.featureSetTypeMap.getOrDefault(in, Collections.emptyMap()).getOrDefault((Object)BasicType.MEASURE, Collections.emptyList()).stream().map(ExtractedFeatureSet::new).collect(Collectors.toList());
    }

    public boolean hasLocations() {
        return this.hasLocations;
    }

    public List<List<ExtractedFeatureSet>> cloneFeatureSets() {
        return this.features.stream().map(this::cloneFearureSet).collect(Collectors.toList());
    }

    public List<IDataColumn> getCombination() {
        return this.combination;
    }

    public List<List<ExtractedFeatureSet>> getFeatures() {
        return this.features;
    }
}

