/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.modeling;

import com.ibm.smarts.visualization.recommender.internal.modeling.AxisType;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureBinding;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureExtracter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ModelChartDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ModelFeaturesBinder {
    private static final int MAX_MODEL_COLUMN_NUM = 4;
    private List<FeatureBinding> bindings = new ArrayList<FeatureBinding>();

    private void bind(FeatureBinding binding, List<ExtractedFeatureSet> features, List<AxisType> toFill) {
        AtomicInteger axis = new AtomicInteger(0);
        features.stream().forEach(f -> binding.bindFeatureSet((ExtractedFeatureSet)f, (AxisType)((Object)((Object)toFill.get(axis.getAndIncrement())))));
    }

    public static int getMaxModelColNum() {
        return 4;
    }

    private static void assignFeaturesToAxisTypes(FeatureBinding binding, List<ExtractedFeatureSet> features, List<AxisType> preferedAxisTypes, List<AxisType> remainingAxisTypes) {
        for (ExtractedFeatureSet feature : features) {
            List types;
            List axisTypes;
            AxisType axisType = null;
            if (!(feature.getConcept().equals("NONE") || (axisTypes = ModelChartDescriptor.conceptAxisAffinity.getOrDefault(feature.getConcept(), Collections.emptyList())).isEmpty() || (types = axisTypes.stream().filter(aType -> preferedAxisTypes.contains(aType) || remainingAxisTypes.contains(aType)).collect(Collectors.toList())).isEmpty())) {
                axisType = (AxisType)((Object)types.get(0));
                preferedAxisTypes.remove((Object)axisType);
                remainingAxisTypes.remove((Object)axisType);
            }
            if (axisType == null) {
                axisType = !preferedAxisTypes.isEmpty() ? preferedAxisTypes.remove(0) : remainingAxisTypes.remove(0);
            }
            binding.bindFeatureSet(feature, axisType);
        }
    }

    private void bindFeatureSet(FeatureExtracter extracter, List<ExtractedFeatureSet> set) {
        ArrayList<ExtractedFeatureSet> genericCategory = new ArrayList<ExtractedFeatureSet>(extracter.getDates(set));
        genericCategory.addAll(extracter.getLocations(set));
        genericCategory.addAll(extracter.getCategories(set));
        genericCategory.sort(Comparator.comparing(f -> f.getConcept().equals("NONE") ? 1 : 0).thenComparing(Comparator.comparing(ExtractedFeatureSet::getFeatureType)).thenComparing(Comparator.comparing(ExtractedFeatureSet::getQuantity).reversed()));
        ArrayList<ExtractedFeatureSet> measures = new ArrayList<ExtractedFeatureSet>(extracter.getMeasures(set));
        measures.sort(Comparator.comparing(m -> m.getConcept().equals("NONE") ? 1 : 0));
        FeatureBinding binding = new FeatureBinding(extracter.getCombination());
        ArrayList<AxisType> availCatAxisTypes = new ArrayList<AxisType>(ModelChartDescriptor.preferedCategoryAxes);
        ArrayList<AxisType> availMeasureAxisTypes = new ArrayList<AxisType>(ModelChartDescriptor.preferedMeasureAxes);
        ModelFeaturesBinder.assignFeaturesToAxisTypes(binding, genericCategory, availCatAxisTypes, availMeasureAxisTypes);
        ModelFeaturesBinder.assignFeaturesToAxisTypes(binding, measures, availMeasureAxisTypes, availCatAxisTypes);
        this.bindings.add(binding);
    }

    public void bind(FeatureExtracter extracter) {
        extracter.getFeatures().forEach(f -> this.bindFeatureSet(extracter, (List<ExtractedFeatureSet>)f));
    }

    public List<List<String>> generateVectors() {
        return this.bindings.stream().map(FeatureBinding::buildFeatureVector).collect(Collectors.toList());
    }

    public List<FeatureBinding> getBindings() {
        return this.bindings;
    }
}

