/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.pipeline;

import com.ibm.smarts.recommenders.core.utils.Pair;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.internal.RecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.pipeline.ChartProcessor;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class ScatterBubbleChartFilter
implements ChartProcessor {
    private static final List<String> SINGLE_DOT_CHARTS = Arrays.asList("Scatter", "Bubble");
    private static final double SCORE_PENALTY = 0.01;

    @Override
    public Pair<Stream<RecommendedVisualization>, VisualizationParameters> apply(Pair<Stream<RecommendedVisualization>, VisualizationParameters> pair) {
        Function<RecommendedVisualization, RecommendedVisualization> updateScore = rec -> {
            boolean chartToPenalize;
            if (SINGLE_DOT_CHARTS.contains(rec.getLabel()) && (chartToPenalize = rec.getFeatures().stream().allMatch(f -> f.getFeatureType().equals((Object)BasicType.MEASURE) && !VisRecommenderUtils.getAggregationForColumn(f.getColumn(), ((VisualizationParameters)pair.getRight()).getAggregationMap()).equals((Object)AggregationType.NONE)))) {
                rec.setScore(rec.getChartDescriptor().getHighLevelDescriptor().getMinChartScore() - 0.01);
            }
            return rec;
        };
        return new Pair<Stream<RecommendedVisualization>, VisualizationParameters>(pair.getLeft().map(updateScore), pair.getRight());
    }
}

