/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.model.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnInfoException;
import com.ibm.smarts.visualization.recommender.internal.charts.BindingChartElementAlloc;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class BaseHeatmap
extends ChartDescriptor {
    protected static final String HEATMAP_NAME = "Heatmap";
    protected static final String IDS_HEATMAP_LABEL = "IDS_HEATMAP_LABEL";
    protected static final String IDS_HEATMAP_TITLE = "IDS_HEATMAP_TITLE";
    protected static final String IDS_HEATMAP_POINTS_LABEL = "IDS_HEATMAP_POINTS_LABEL";
    protected static final String IDS_HEATMAP_POINTS_TITLE = "IDS_HEATMAP_POINTS_TITLE";
    protected static final String IDS_HEATMAP_SIZE_LABEL = "IDS_HEATMAP_SIZE_LABEL";
    protected static final String IDS_HEATMAP_SIZE_TITLE = "IDS_HEATMAP_SIZE_TITLE";
    private static final List<String> MEASURE_AND_CATEGORY_CONCEPTS = Arrays.asList(BasicType.MEASURE.getOntologyConcept(), BasicType.CATEGORY.getOntologyConcept());
    private static final List<String> CATEGORICAL_ORDER = Arrays.asList(StdChartElements.COLUMN.slot(), StdChartElements.ROW.slot(), StdChartElements.COLOR.slot(), StdChartElements.POINTS.slot());
    private Predicate<ExtractedFeatureSet> measurePredicate = f -> f.getFeatureType().equals((Object)BasicType.MEASURE);
    private Comparator<ExtractedFeatureSet> sortMultiTypeColumnsLast = (e1, e2) -> {
        List c1Concepts = e1.getColumn().getFlatListOfConcepts();
        List c2Concepts = e2.getColumn().getFlatListOfConcepts();
        if (c1Concepts.containsAll(MEASURE_AND_CATEGORY_CONCEPTS) && c2Concepts.containsAll(MEASURE_AND_CATEGORY_CONCEPTS)) {
            return 0;
        }
        if (c1Concepts.containsAll(MEASURE_AND_CATEGORY_CONCEPTS)) {
            return 1;
        }
        if (c2Concepts.containsAll(MEASURE_AND_CATEGORY_CONCEPTS)) {
            return -1;
        }
        return 0;
    };
    private Comparator<ChartElement> categoricalSorter = (ce1, ce2) -> {
        int ce2SlotIndex;
        int ce1SlotIndex = CATEGORICAL_ORDER.indexOf(ce1.getType().getSlot());
        if (ce1SlotIndex > (ce2SlotIndex = CATEGORICAL_ORDER.indexOf(ce2.getType().getSlot()))) {
            return 1;
        }
        return -1;
    };

    protected BaseHeatmap() {
        super(HEATMAP_NAME);
    }

    private void assignFeaturesToElements(List<ExtractedFeatureSet> features, List<ChartElement> elem) {
        int length = Math.min(elem.size(), features.size());
        IntStream.range(0, length).forEach(i -> ((ExtractedFeatureSet)features.get(i)).setChartElement((ChartElement)elem.get(i)));
    }

    @Override
    public List<Binding> bindChartElements(List<ExtractedFeatureSet> features) {
        return this.getBindings(features, this.elements, Collections.emptyList());
    }

    @Override
    public List<IBindingResult> bindChartElements(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, Map<BindingParams, Double> params, List<ExtractedFeatureSet> unboundFeatures, boolean forceBinding) throws InvalidColumnBindingException, InvalidColumnInfoException {
        if (bound.isEmpty()) {
            return this.getHeatMapBindingResult(locale, bound, this.elements.stream().collect(Collectors.toList()), Collections.emptyList(), unboundFeatures, forceBinding, boundColumnInfo);
        }
        List<List<BindingChartElementAlloc>> candidateAllocations = this.getCandidateAllocations(bound, boundColumnInfo, params);
        return candidateAllocations.stream().flatMap(c -> {
            ArrayList<Binding> bindings = new ArrayList<Binding>();
            ArrayList<ChartElement> available = new ArrayList<ChartElement>();
            ArrayList<ExtractedFeatureSet> boundFeatures = new ArrayList<ExtractedFeatureSet>();
            this.prepareParametersForBinding((List<BindingChartElementAlloc>)c, (List<Binding>)bindings, (List<ChartElement>)available, (List<ExtractedFeatureSet>)boundFeatures);
            if (available.isEmpty()) {
                int numberOfRemainingSLots = this.elements.size() - bindings.size();
                List<String> unboundFeatureIds = this.getUnboundColumnsIdForExpressions(unboundFeatures);
                BindingResult result = this.getBindingResultWithNLG(locale, boundFeatures, unboundFeatures, boundColumnInfo, bindings, unboundFeatureIds, numberOfRemainingSLots);
                return Stream.of(result);
            }
            return this.getHeatMapBindingResult(locale, bindings, available, boundFeatures, unboundFeatures, forceBinding, boundColumnInfo).stream();
        }).filter(Objects::nonNull).sorted(Comparator.comparingInt(b -> b.getUnbindableColumns().size())).collect(Collectors.toList());
    }

    private List<IBindingResult> getHeatMapBindingResult(Locale locale, List<Binding> bound, List<ChartElement> available, List<ExtractedFeatureSet> boundFeatures, List<ExtractedFeatureSet> unboundFeatures, boolean forceBinding, Map<String, IDataColumn> boundColumnInfo) {
        ArrayList<IBindingResult> results = new ArrayList<IBindingResult>();
        List<ExtractedFeatureSet> unboundFeaturesCopy = unboundFeatures.stream().collect(Collectors.toList());
        int numberOfAvailableFeatures = this.elements.size();
        List<Binding> bindings = this.getBindings(unboundFeaturesCopy, available, bound);
        List<ExtractedFeatureSet> remainingUnbound = unboundFeaturesCopy.stream().filter(efs -> efs.getChartElement() == null).collect(Collectors.toList());
        List<String> unboundColumns = this.getUnboundColumnsIdForExpressions(remainingUnbound);
        int numberOfRemainingSlots = numberOfAvailableFeatures - (bindings.size() + bound.size());
        bindings.addAll(bound);
        BindingResult result = this.getBindingResultWithNLG(locale, boundFeatures, unboundFeatures, boundColumnInfo, bindings, unboundColumns, numberOfRemainingSlots);
        results.add(result);
        return results;
    }

    private List<Binding> getBindings(List<ExtractedFeatureSet> unboundFeatures, List<ChartElement> available, List<Binding> bound) {
        this.assignFeaturesToChartElements(unboundFeatures, available);
        return this.bindColumns(unboundFeatures);
    }

    private void assignFeaturesToChartElements(List<ExtractedFeatureSet> unboundFeatures, List<ChartElement> available) {
        Map<Boolean, List<ExtractedFeatureSet>> featurePartition = unboundFeatures.stream().collect(Collectors.partitioningBy(this.measurePredicate));
        List<ExtractedFeatureSet> categoricalFeatures = featurePartition.get(false);
        categoricalFeatures.sort(Comparator.comparing(ExtractedFeatureSet::getQuantity));
        categoricalFeatures.sort(this.sortMultiTypeColumnsLast);
        List<ExtractedFeatureSet> numericalFeatures = featurePartition.get(true);
        Predicate<ChartElement> measureElementPred = e -> e.getBasicTypes().contains((Object)BasicType.MEASURE);
        Map<Boolean, List<ChartElement>> elementsPart = available.stream().collect(Collectors.partitioningBy(measureElementPred));
        List<ChartElement> categoricalElems = elementsPart.get(false).stream().sorted(this.categoricalSorter).collect(Collectors.toList());
        List<ChartElement> numericalElems = elementsPart.get(true);
        this.assignFeaturesToElements(categoricalFeatures, categoricalElems);
        this.assignFeaturesToElements(numericalFeatures, numericalElems);
    }
}

