/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.learningaggregator.application;

import com.ibm.bi.recommendationmodel.RecommendationModel;
import com.ibm.bi.recommendationmodel.RecommendationModelBuilder;
import com.ibm.bi.rest.RESTClient;
import com.ibm.bi.storageservice.application.StorageService;
import com.ibm.bi.storageservice.application.UserProfileStorageService;
import com.ibm.bi.storageservice.utils.LearningType;
import com.ibm.bi.storageservice.utils.Utils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearningAggregator {
    private final Logger log = LoggerFactory.getLogger(LearningAggregator.class);
    private StorageService storageService = new UserProfileStorageService();

    public RecommendationModel getLearningAggregation(RESTClient restClient) {
        RecommendationModel offlineRecModel = this.getOfflineLearningRecModel(restClient);
        RecommendationModel onlineRecModel = this.getOnlineLearningRecModel(restClient);
        RecommendationModel aggregateRecModel = RecommendationModel.aggregateRecModel((RecommendationModel)offlineRecModel, (RecommendationModel)onlineRecModel);
        this.log.info("Successfully retrieved aggregated learning model");
        return aggregateRecModel;
    }

    private RecommendationModel getOnlineLearningRecModel(RESTClient restClient) {
        String onlineModelString = this.storageService.getRecModel(restClient, LearningType.ONLINE_LEARNING);
        RecommendationModel onlineModel = null;
        try {
            long startTime = System.currentTimeMillis();
            onlineModelString = Utils.uncompressRecModel((String)onlineModelString);
            this.log.info("Uncompressing online learning Model took: " + (System.currentTimeMillis() - startTime) + " ms");
            if (onlineModelString != null) {
                onlineModel = RecommendationModelBuilder.fromJsonString((String)onlineModelString);
                this.log.info("Converting online learning from Json to Model took: " + (System.currentTimeMillis() - startTime) + " ms");
            }
        }
        catch (IOException e) {
            this.log.error("Fetching the Online Recommendation Model failed" + e.getMessage());
        }
        return onlineModel == null ? new RecommendationModel() : onlineModel;
    }

    private RecommendationModel getOfflineLearningRecModel(RESTClient restClient) {
        String offlineModelString = this.storageService.getRecModel(restClient, LearningType.OFFLINE_LEARNING);
        RecommendationModel offlineModel = null;
        try {
            long startTime = System.currentTimeMillis();
            offlineModelString = Utils.uncompressRecModel((String)offlineModelString);
            this.log.info("Uncompressing offline learning Model took: " + (System.currentTimeMillis() - startTime) + " ms");
            if (offlineModelString != null) {
                offlineModel = RecommendationModelBuilder.fromJsonString((String)offlineModelString);
                this.log.info("Converting offline learning from Json to Model took: " + (System.currentTimeMillis() - startTime) + " ms");
            }
        }
        catch (IOException e) {
            this.log.error("Fetching the Offline Recommendation Model failed" + e.getMessage());
        }
        return offlineModel == null ? new RecommendationModel() : offlineModel;
    }
}

