/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.entity_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.uima_annotator.util.ConfigurationParameterUtil;
import com.ibm.dltj.uima_annotator.util.ResultSpecificationUtil;
import com.ibm.langware.annotator.Copyright;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.text.Language;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
abstract class Method {
    protected TypeSystem _typeSystem;
    protected LowLevelTypeSystem _llTypeSystem;
    protected int _featureCodeSofa;
    protected int _featureCodeBegin;
    protected int _featureCodeEnd;
    protected final ConfigurationParameterUtil _cfg;
    protected final ResultSpecificationUtil _capability = new ResultSpecificationUtil();
    protected final Logger _logger;
    protected final Language _language;
    static final String RESOURCE_KEY = "Resources";
    static final String RESOURCE_FILENAME = "ee.dic";

    protected Method(UimaContext uimaContext, String string) {
        this._cfg = new ConfigurationParameterUtil(uimaContext);
        this._language = new Language(string);
        this._logger = uimaContext.getLogger();
    }

    void typeSystemInit(TypeSystem typeSystem) throws DLTException {
        assert (typeSystem != null);
        this._typeSystem = typeSystem;
        this._llTypeSystem = typeSystem.getLowLevelTypeSystem();
        this._capability.setTypeSystem(typeSystem);
        this._featureCodeSofa = this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:sofa");
        this._featureCodeBegin = this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:begin");
        this._featureCodeEnd = this._llTypeSystem.ll_getCodeForFeatureName("uima.tcas.Annotation:end");
        assert (this._featureCodeBegin > 0);
        assert (this._featureCodeEnd > 0);
    }

    void setResultSpecification(ResultSpecification resultSpecification) {
        assert (resultSpecification != null);
        this._capability.setResultSpecification(resultSpecification);
    }

    abstract void process(CAS var1) throws DLTException;

    abstract void collectionProcessComplete() throws DLTException;

    protected static interface LabelPrefix {
        public static final String B = "B-";
        public static final String I = "I-";
        public static final int LENGTH = 2;
    }
}

