/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.flow;

import com.ibm.dltj.uima_annotator.flow.IFlowStage;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class FixedFlowStage
implements IFlowStage {
    private final List<String> _ids;
    private int _currIndex = 0;

    public FixedFlowStage() {
        this._ids = new ArrayList<String>(0);
    }

    public FixedFlowStage(String string) {
        this._ids = new ArrayList<String>(1);
        this._ids.add(string);
    }

    public FixedFlowStage(String[] stringArray) {
        this._ids = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            this._ids.add(string);
        }
    }

    public FixedFlowStage(List<String> list) {
        this._ids = new ArrayList<String>(list.size());
        this._ids.addAll(list);
    }

    public void addId(String string) {
        this._ids.add(string);
    }

    public List<String> getIds() {
        return this._ids;
    }

    @Override
    public void reset() {
        this._currIndex = 0;
    }

    @Override
    public void describe(int n, Logger logger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(Messages.getMessage("FixedFlowStage.name"));
        for (String string : this._ids) {
            stringBuilder.append(' ').append(string);
        }
        logger.log(Level.CONFIG, stringBuilder.toString());
    }

    @Override
    public boolean hasNext(CAS cAS) {
        return this._currIndex < this._ids.size();
    }

    @Override
    public String next() {
        String string = this._ids.get(this._currIndex);
        ++this._currIndex;
        return string;
    }

    void newCasProduced(String string, Logger logger) throws AnalysisEngineProcessException {
        logger.log(Level.INFO, Messages.getMessage("FixedFlowStage.newcas"));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FixedFlowStage");
        stringBuilder.append("[index=").append(this._currIndex);
        if (this._currIndex >= 0 && this._currIndex < this._ids.size()) {
            stringBuilder.append(",id=").append(this._ids.get(this._currIndex));
        }
        stringBuilder.append(']');
        stringBuilder.trimToSize();
        return stringBuilder.toString();
    }
}

