/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.implBase;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.uima_annotator.ConfigurationManager;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import com.ibm.langware.annotator.jFrostResourceInitException;
import java.io.File;
import org.apache.uima.UimaContext;
import org.apache.uima.resource.ResourceInitializationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public abstract class ConfigMgr_ImplBase
implements ConfigurationManager {
    protected final UimaContext mUimaContext;
    protected String[] mSofaNames = null;
    protected String mFrostDataSubdir = "";
    protected String mFrostDataSpec;
    protected String[] mFrostDataSpecEntries;
    private CapMatrix cm;

    public ConfigMgr_ImplBase(UimaContext uimaContext) {
        this.mUimaContext = uimaContext;
    }

    @Override
    public void readConfigValues() throws ResourceInitializationException {
        this.mSofaNames = (String[])this.mUimaContext.getConfigParameterValue("SofaNames");
        this.mFrostDataSubdir = ConfigMgr_ImplBase.secureGetConfigParameterValue(this.mUimaContext, "LWDataSubdir", this.mFrostDataSubdir);
        String string = this.mUimaContext.getDataPath();
        this.mFrostDataSpecEntries = string.split(File.pathSeparator);
        if (this.mFrostDataSubdir != null && this.mFrostDataSubdir.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.mFrostDataSpecEntries.length; ++i) {
                File file = new File(this.mFrostDataSpecEntries[i]);
                if (file.isDirectory()) {
                    int n = i;
                    this.mFrostDataSpecEntries[n] = this.mFrostDataSpecEntries[n] + File.separatorChar + this.mFrostDataSubdir;
                }
                stringBuilder.append(this.mFrostDataSpecEntries[i]);
                stringBuilder.append(File.pathSeparatorChar);
            }
            this.mFrostDataSpec = stringBuilder.substring(0, stringBuilder.length() - 1);
        } else {
            this.mFrostDataSpec = string;
        }
        try {
            if (this.cm == null) {
                this.cm = new CapMatrix(this.mFrostDataSpec);
            } else {
                this.cm.setDataSpec(this.mFrostDataSpec);
            }
        }
        catch (DLTException dLTException) {
            throw new jFrostResourceInitException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
        }
    }

    @Override
    public final String getjFrostDataSpec() {
        return this.mFrostDataSpec;
    }

    @Override
    public final CapMatrix getjFrostCapabilityMatrix() {
        return this.cm;
    }

    protected static int secureGetConfigParameterValue(UimaContext uimaContext, String string, int n) {
        try {
            Integer n2 = (Integer)uimaContext.getConfigParameterValue(string);
            if (n2 != null) {
                return n2;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return n;
    }

    protected static boolean secureGetConfigParameterValue(UimaContext uimaContext, String string, boolean bl) {
        try {
            Boolean bl2 = (Boolean)uimaContext.getConfigParameterValue(string);
            if (bl2 != null) {
                return bl2;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return bl;
    }

    protected static String secureGetConfigParameterValue(UimaContext uimaContext, String string, String string2) {
        try {
            String string3 = (String)uimaContext.getConfigParameterValue(string);
            if (string3 != null) {
                return string3;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return string2;
    }
}

