/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.implBase.ConfigMgr_ImplBase;
import com.ibm.dltj.uima_annotator.lex_analysis.config.MWBoundary;
import com.ibm.dltj.uima_annotator.lex_analysis.config.ProcessLanguageWithNoDictionaries;
import com.ibm.dltj.uima_annotator.util.Language;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.impl.UimaContext_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class ConfigurationMgr
extends ConfigMgr_ImplBase {
    public static final String CLASS_NAME = ConfigurationMgr.class.getName();
    private static final int DEFAULT_DICTS_CACHE_SIZE = 5;
    protected boolean mUseExplicitDicts = false;
    protected String[] mPreloadLanguageArray;
    protected String mDefaultLanguage = null;
    @Deprecated
    protected int mDictsCacheSize = 5;
    protected ProcessLanguageWithNoDictionaries mProcessLanguagesWithNoDictionaries = ProcessLanguageWithNoDictionaries.SKIP;
    public boolean mUseFirstMatchPolicy = false;
    public boolean mUseStrictCaseMode = true;
    protected boolean mAdjustToSpecialTokenTypes = true;
    protected boolean mAnnotateMWConstituentTokens = true;
    protected MWBoundary mMWBoundary = MWBoundary.SENTENCE;
    protected boolean mUseRelativeTokenAndSentenceNumbers = false;
    protected boolean mIgnorePunctuationTokens = false;
    @Deprecated
    public boolean mAggressiveSentenceBreaks = false;
    public boolean mCrossDictionaryDecomposition = true;
    public boolean mBOFAOnlyDecomposition = false;
    public boolean mCreateCompoundPartsInsteadOfToken = true;
    public boolean mReturnOnlyFirstLevelOfCompoundBreakdown = true;
    public boolean mCreateDecompStructure = false;
    @Deprecated
    public boolean mBreakOnHyphens = true;
    public boolean mFilterDecompositions = true;
    public boolean mStandaloneDecomposition = false;
    public boolean mDoLookupVariant = false;
    public boolean mDoRuleBasedNormalization4All = false;
    public boolean mDoRuleBasedNormalization4Katakana = false;
    public boolean mJaDeepWordBreak = false;
    protected boolean mJaDecomposition = false;
    protected boolean mKoLegacyAnalyzer = false;
    public String mGlossComparatorClassname;
    protected int mLemmaPoolingThreshold = 10000;
    public boolean mCreateGenericAnnotations = true;
    public boolean mCheckGenericTypes = false;
    boolean mReturnOnlyFirstLevelOfCompoundBreakdown_ConfigVal;
    boolean mCreateDecompStructure_ConfigVal;
    boolean mDoLookupVariant_ConfigVal;
    boolean mDoRuleBasedNormalization4All_ConfigVal;
    boolean mDoRuleBasedNormalization4Katakana_ConfigVal;
    public boolean mLemmatizationEnabled = false;
    public boolean mDecompositionEnabled = false;

    public ConfigurationMgr(UimaContext uimaContext) {
        super(uimaContext);
    }

    @Override
    public void readConfigValues() throws ResourceInitializationException {
        super.readConfigValues();
        this.mUseExplicitDicts = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "UseExplicitDicts", this.mUseExplicitDicts);
        Object object = this.mUimaContext.getConfigParameterValue("ProcessLanguagesWithNoDictionaries");
        if (object != null) {
            if (object instanceof Boolean) {
                this.mProcessLanguagesWithNoDictionaries = (Boolean)object != false ? ProcessLanguageWithNoDictionaries.TOKENIZE : ProcessLanguageWithNoDictionaries.ERROR;
            } else {
                try {
                    this.mProcessLanguagesWithNoDictionaries = ProcessLanguageWithNoDictionaries.valueOf(((String)object).toUpperCase());
                }
                catch (ClassCastException classCastException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        try {
            this.mPreloadLanguageArray = (String[])this.mUimaContext.getConfigParameterValue("PreloadLanguages");
        }
        catch (ClassCastException classCastException) {
            this.mPreloadLanguageArray = null;
        }
        this.mDefaultLanguage = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "DefaultLanguage", this.mDefaultLanguage);
        this.mDictsCacheSize = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "DictionaryCacheSize", this.mDictsCacheSize);
        this.mUseFirstMatchPolicy = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "UseFirstMatchPolicy", this.mUseFirstMatchPolicy);
        this.mUseStrictCaseMode = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "UseStrictCaseMode", this.mUseStrictCaseMode);
        this.mAdjustToSpecialTokenTypes = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "AdjustToSpecialTokenTypes", this.mAdjustToSpecialTokenTypes);
        this.mFilterDecompositions = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "FilterDecomposedGlosses", this.mFilterDecompositions);
        this.mAnnotateMWConstituentTokens = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "AnnotateMWConstituentTokens", this.mAnnotateMWConstituentTokens);
        String string = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "MWBoundary", "");
        if (string != null && string.length() > 0) {
            try {
                this.mMWBoundary = MWBoundary.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.mUseRelativeTokenAndSentenceNumbers = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "UseRelativeTokenAndSentenceNumbers", this.mUseRelativeTokenAndSentenceNumbers);
        this.mIgnorePunctuationTokens = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "IgnorePunctuationTokens", this.mIgnorePunctuationTokens);
        this.mAggressiveSentenceBreaks = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "AggressiveSentenceBreaks", this.mAggressiveSentenceBreaks);
        this.mCreateCompoundPartsInsteadOfToken = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "CreateCompoundPartsInsteadOfToken", this.mCreateCompoundPartsInsteadOfToken);
        this.mReturnOnlyFirstLevelOfCompoundBreakdown = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "ReturnOnlyFirstLevelOfCompoundBreakdown", this.mReturnOnlyFirstLevelOfCompoundBreakdown);
        this.mCreateDecompStructure = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "CreateDecompStructure", this.mCreateDecompStructure);
        this.mCreateDecompStructure = this.mCreateDecompStructure && !this.mCreateCompoundPartsInsteadOfToken && !this.mReturnOnlyFirstLevelOfCompoundBreakdown;
        this.mCrossDictionaryDecomposition = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "CrossDictionaryDecomposition", this.mCrossDictionaryDecomposition);
        this.mBOFAOnlyDecomposition = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "BOFAOnlyDecomposition", this.mBOFAOnlyDecomposition);
        this.mStandaloneDecomposition = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "StandaloneDecomposition", this.mStandaloneDecomposition);
        this.mBreakOnHyphens = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "BreakOnHyphens", this.mBreakOnHyphens);
        this.mDoLookupVariant = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "DoLookupVariant", this.mDoLookupVariant);
        this.mDoRuleBasedNormalization4All = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "DoRuleBasedNormalization4All", this.mDoRuleBasedNormalization4All);
        this.mDoRuleBasedNormalization4Katakana = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "DoRuleBasedNormalization4Katakana", this.mDoRuleBasedNormalization4Katakana);
        this.mJaDeepWordBreak = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "JapaneseDeepWordBreak", this.mJaDeepWordBreak);
        this.mJaDecomposition = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "JapaneseDecomposition", this.mJaDecomposition);
        this.mKoLegacyAnalyzer = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "KoreanLegacyAnalyzer", this.mKoLegacyAnalyzer);
        this.mGlossComparatorClassname = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "GlossComparatorClassname", this.mGlossComparatorClassname);
        this.mLemmaPoolingThreshold = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "LemmaPoolingThreshold", this.mLemmaPoolingThreshold);
        this.mCreateGenericAnnotations = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "CreateGenericAnnotations", this.mCreateGenericAnnotations);
        this.mCheckGenericTypes = ConfigurationMgr.secureGetConfigParameterValue(this.mUimaContext, "CheckGenericTypes", this.mCheckGenericTypes);
        this.mReturnOnlyFirstLevelOfCompoundBreakdown_ConfigVal = this.mReturnOnlyFirstLevelOfCompoundBreakdown;
        this.mCreateDecompStructure_ConfigVal = this.mCreateDecompStructure;
        this.mDoLookupVariant_ConfigVal = this.mDoLookupVariant;
        this.mDoRuleBasedNormalization4All_ConfigVal = this.mDoRuleBasedNormalization4All;
        this.mDoRuleBasedNormalization4Katakana_ConfigVal = this.mDoRuleBasedNormalization4Katakana;
    }

    public String getLanguageSpecificFileName(UimaContext uimaContext, Language language, String string) {
        String string2 = null;
        try {
            string2 = (String)uimaContext.getConfigParameterValue(language.getLanguageFullName(), string);
            if (string2 == null && language.hasTerritoryInformation()) {
                string2 = (String)uimaContext.getConfigParameterValue(language.getLanguageWithNoTerritory(), string);
            }
            if (string2 == null) {
                string2 = (String)uimaContext.getConfigParameterValue("default", string);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (string2 != null && string2.length() != 0) {
            Serializable serializable;
            String string3 = string2;
            if (this.mFrostDataSubdir != null && this.mFrostDataSubdir.length() > 0) {
                serializable = new StringBuilder(this.mFrostDataSubdir);
                int n = this.mFrostDataSubdir.indexOf(File.pathSeparatorChar);
                if (n != -1) {
                    ((StringBuilder)serializable).delete(n, ((StringBuilder)serializable).length());
                }
                ((StringBuilder)serializable).append(File.separatorChar);
                ((StringBuilder)serializable).append(string2);
                string3 = ((StringBuilder)serializable).toString();
            }
            try {
                String string4;
                serializable = ((UimaContext_ImplBase)this.mUimaContext).getResourceManager().resolveRelativePath(string3);
                if (serializable != null && (string4 = new File(((URL)serializable).getFile()).getPath()) != null && string4.length() != 0) {
                    string2 = string4;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string2;
    }

    public String[] getDictsForLang(UimaContext uimaContext, Language language, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        try {
            stringArray = (String[])uimaContext.getConfigParameterValue(language.getLanguageFullName(), string);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (stringArray == null && language.hasTerritoryInformation()) {
            try {
                stringArray = (String[])uimaContext.getConfigParameterValue(language.getLanguageWithNoTerritory(), string);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (stringArray != null) {
            for (String string2 : stringArray) {
                arrayList.add(string2);
            }
        }
        try {
            stringArray = (String[])uimaContext.getConfigParameterValue("default", string);
        }
        catch (ClassCastException classCastException) {
            stringArray = null;
        }
        if (stringArray != null) {
            for (String string2 : stringArray) {
                arrayList.add(string2);
            }
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public String[] resolveDictionaryEntries(AnalyzerContext analyzerContext, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".dic");
            }
        };
        for (String string : stringArray) {
            File file = new File(string);
            if (file.isAbsolute()) {
                if (file.isFile()) {
                    arrayList.add(file.getAbsolutePath());
                    continue;
                }
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles(fileFilter);
                    if (fileArray == null || fileArray.length == 0) {
                        if (analyzerContext.isTraceEnabled()) {
                            analyzerContext.logMsg(Level.WARNING, CLASS_NAME, "resolveDictionaryEntries", Messages.MessageKeys.ConfigurationMgr__empty_directory__WARNING.name(), file.getAbsolutePath());
                        }
                    } else {
                        for (File file2 : fileArray) {
                            arrayList.add(file2.getAbsolutePath());
                        }
                        continue;
                    }
                }
            }
            boolean bl = false;
            for (String string2 : this.mFrostDataSpecEntries) {
                File file3 = new File(string2);
                if (!file3.isDirectory()) continue;
                file = new File(file3, string);
                if (file.isFile()) {
                    arrayList.add(file.getAbsolutePath());
                    bl = true;
                    break;
                }
                if (!file.isDirectory()) continue;
                File[] fileArray = file.listFiles(fileFilter);
                if (fileArray == null || fileArray.length == 0) {
                    if (!analyzerContext.isTraceEnabled()) continue;
                    analyzerContext.logMsg(Level.WARNING, CLASS_NAME, "resolveDictionaryEntries", Messages.MessageKeys.ConfigurationMgr__empty_directory__WARNING.name(), file.getAbsolutePath());
                    continue;
                }
                for (File file4 : fileArray) {
                    arrayList.add(file4.getAbsolutePath());
                }
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

