/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.uima_annotator.lex_analysis.AnnotationsCreator;
import com.ibm.dltj.uima_annotator.lex_analysis.ConfigurationMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.LexicalAnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.ResultSpecMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.util.Language;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.text.CharacterIterator;
import java.util.Iterator;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class ResultHandler
implements MWUParsingStream {
    private static String CLASS_NAME = ResultHandler.class.getName();
    protected final LexicalAnalyzerContext mContext;
    protected final ConfigurationMgr mConfigMgr;
    private final ResultSpecMgr mRsltSpecMgr;
    protected final AnnotationsCreator mAnnoCreator;
    protected final CharacterIterator mDocumentTextItr;
    protected boolean mFirstComponent;
    protected boolean mInSecondLevelOfDecomp = false;
    protected int mFirstForkRBBI4CJ;
    protected TokenInfo mLastCompoundToken = null;

    public ResultHandler(LexicalAnalyzerContext lexicalAnalyzerContext, AnnotationsCreator annotationsCreator, CharacterIterator characterIterator) {
        this.mContext = lexicalAnalyzerContext;
        this.mConfigMgr = (ConfigurationMgr)this.mContext.getConfigurationManager();
        this.mRsltSpecMgr = (ResultSpecMgr)this.mContext.getResultSpecManager();
        this.mAnnoCreator = annotationsCreator;
        this.mDocumentTextItr = characterIterator;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        TokenInfo tokenInfo;
        block14: {
            TokenInfo.BasicType basicType;
            if (n2 == n3) {
                return;
            }
            TokenInfo.BasicType basicType2 = basicType = glossCollection.isGeneric() ? TokenInfo.BasicType.STD_GENERIC : TokenInfo.BasicType.STD;
            if (this.mAnnoCreator.isInCompound()) {
                if (this.mConfigMgr.mReturnOnlyFirstLevelOfCompoundBreakdown && this.mInSecondLevelOfDecomp) {
                    return;
                }
                if (!this.mContext.mLanguageDicts.getLanguage().isLanguageOfType(Language.LanguageType.EU) && this.mAnnoCreator.isInCompound(1) && this.mFirstComponent) {
                    this.mFirstComponent = false;
                    this.mFirstForkRBBI4CJ = 0;
                    if (this.mConfigMgr.mCreateDecompStructure) {
                        tokenInfo = this.mLastCompoundToken;
                        break block14;
                    } else {
                        Iterator iterator = glossCollection.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                return;
                            }
                            Gloss gloss = (Gloss)iterator.next();
                            this.mAnnoCreator.processAnnotateOnly(n2, n3, gloss);
                        }
                    }
                }
                switch (this.mFirstForkRBBI4CJ) {
                    case 105: 
                    case 106: 
                    case 109: 
                    case 420: 
                    case 421: 
                    case 425: 
                    case 426: 
                    case 427: {
                        tokenInfo = this.mAnnoCreator.addToken(n2, n3, this.mFirstForkRBBI4CJ, TokenInfo.BasicType.STD_GENERIC);
                        break;
                    }
                    default: {
                        tokenInfo = this.mAnnoCreator.addToken(n2, n3, 0, basicType);
                        break;
                    }
                }
            } else {
                tokenInfo = this.mAnnoCreator.addToken(n2, n3, 0, basicType);
            }
        }
        this.mAnnoCreator.sortGlossCollection(glossCollection);
        Iterator iterator = glossCollection.iterator();
        while (iterator.hasNext()) {
            Gloss gloss = (Gloss)iterator.next();
            this.mAnnoCreator.processGloss(tokenInfo, gloss);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createUnknown(int n, int n2, int n3, int n4) {
        TokenInfo tokenInfo;
        if (n2 == n3) {
            return;
        }
        if (this.mConfigMgr.mReturnOnlyFirstLevelOfCompoundBreakdown && this.mInSecondLevelOfDecomp) {
            return;
        }
        if (!this.mContext.mLanguageDicts.getLanguage().isLanguageOfType(Language.LanguageType.EU) && this.mAnnoCreator.isInCompound(1) && this.mFirstComponent) {
            this.mFirstComponent = false;
            int n5 = this.mFirstForkRBBI4CJ = this.mFirstForkRBBI4CJ == -1 ? n4 : 0;
            if (!this.mConfigMgr.mCreateDecompStructure) return;
            tokenInfo = this.mLastCompoundToken;
        } else {
            tokenInfo = this.mAnnoCreator.addToken(n2, n3, n4, TokenInfo.BasicType.UNKNOWN);
        }
        this.mAnnoCreator.processUnknown(tokenInfo);
    }

    public void createBreakpoint(int n, int n2, int n3) {
        this.mAnnoCreator.finalizeToken();
        try {
            if (n3 == 1) {
                if (!this.mAnnoCreator.isSentenceBreakEncountered()) {
                    if (this.mContext.isTraceEnabled()) {
                        this.mContext.logMsg(Level.FINEST, CLASS_NAME, "createBreakpoint", Messages.getMessage(Messages.MessageKeys.ResultHandler__Focre_Sentence_Break__FINEST.name()));
                    }
                    this.mAnnoCreator.createNewSentenceAnnotation(this.mAnnoCreator.getBeginOfNextSentence(), n2);
                }
                if (!this.mAnnoCreator.isParagraphBreakEncountered()) {
                    this.mAnnoCreator.createNewParagraphAnnotation(this.mAnnoCreator.getBeginOfNextParagraph(), n2);
                }
            }
            if (n3 == 2 && !this.mAnnoCreator.isSentenceBreakEncountered()) {
                this.mAnnoCreator.createNewSentenceAnnotation(this.mAnnoCreator.getBeginOfNextSentence(), n2);
            }
        }
        catch (AnalysisEngineProcessException analysisEngineProcessException) {
            this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.ResultHandler__Exception_In_CreateBreakpoint__FINEST.name(), n2), (Exception)((Object)analysisEngineProcessException));
        }
    }

    public void createPunctuation(int n, int n2, int n3, int n4) {
        if (!this.mConfigMgr.mIgnorePunctuationTokens && n2 != n3 && n >= 32768) {
            this.mAnnoCreator.addToken(n2, n3, n4, TokenInfo.BasicType.PUNCTUATION);
        }
    }

    public int startGroup(int n, int n2, int n3) {
        if (n != n2 && !this.mConfigMgr.mCreateCompoundPartsInsteadOfToken) {
            this.mLastCompoundToken = this.mAnnoCreator.addToken(n, n2, 0, TokenInfo.BasicType.COMPOUND);
        }
        this.mAnnoCreator.startCompoundGroup(n3);
        this.mFirstForkRBBI4CJ = -1;
        return 0;
    }

    public void closeGroup(int n) {
        this.mAnnoCreator.finalizeToken();
        try {
            this.mAnnoCreator.closeCompoundGroup();
        }
        catch (AnalysisEngineProcessException analysisEngineProcessException) {
            this.mContext.logErrorMsg(Level.FINEST, CLASS_NAME, "closeGroup", Messages.MessageKeys.ResultHandler__Error_create_decomp_analysis_route_for_compound_ignoring_error__FINEST.name(), (Exception)((Object)analysisEngineProcessException));
        }
        this.mLastCompoundToken = null;
        this.mFirstForkRBBI4CJ = -1;
        this.mFirstComponent = true;
    }

    public void fork() {
        this.mFirstComponent = true;
    }

    public void addToFork() {
        this.mInSecondLevelOfDecomp = true;
        if (this.mConfigMgr.mCreateDecompStructure && !this.mConfigMgr.mReturnOnlyFirstLevelOfCompoundBreakdown) {
            this.mAnnoCreator.finalizeDecompositionAnalysisFS();
        }
    }

    public void mergeRoutes(int n) {
        this.mInSecondLevelOfDecomp = false;
    }

    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        if (n2 == n3) {
            return;
        }
        if (this.mRsltSpecMgr.mIsMWURequired) {
            TokenInfo tokenInfo = this.mAnnoCreator.addToken(n2, n3, 0, TokenInfo.BasicType.MWU);
            this.mAnnoCreator.processGloss(tokenInfo, gloss);
        } else {
            this.mAnnoCreator.processAnnotateOnly(n2, n3, gloss);
        }
    }

    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.mContext.logMsg(Level.FINEST, CLASS_NAME, "reset", Messages.getMessage(Messages.MessageKeys.ResultHandler__Lexical_Analyzer_Callback_Reset__FINEST.name()));
        this.mLastCompoundToken = null;
        ((TokenInfo)((Object)this.mAnnoCreator.mTokenAllocator.getCurItem())).reset(0, 0, 0, TokenInfo.BasicType.UNKNOWN);
    }

    public void close() {
        this.mAnnoCreator.finalizeToken();
        this.mContext.logMsg(Level.FINEST, CLASS_NAME, "close", Messages.getMessage(Messages.MessageKeys.ResultHandler__Lexical_Analyzer_Callback_Close__FINEST.name()));
        try {
            if (!this.mAnnoCreator.isParagraphBreakEncountered()) {
                this.mAnnoCreator.createNewParagraphAnnotation(this.mAnnoCreator.getBeginOfNextParagraph(), this.mDocumentTextItr.getEndIndex());
            }
            if (!this.mAnnoCreator.isSentenceBreakEncountered()) {
                this.mAnnoCreator.createNewSentenceAnnotation(this.mAnnoCreator.getBeginOfNextSentence(), this.mDocumentTextItr.getEndIndex());
            }
        }
        catch (AnalysisEngineProcessException analysisEngineProcessException) {
            this.mContext.logError(Level.FINEST, Messages.getFormattedMessage(Messages.MessageKeys.ResultHandler__Exception_In_CreateBreakpoint__FINEST.name(), this.mDocumentTextItr.getEndIndex()), (Exception)((Object)analysisEngineProcessException));
        }
    }
}

