/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.pos_analysis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.tagger.Tagger;
import com.ibm.dltj.tagger.Token;
import com.ibm.dltj.tagger.feature.RawTagHandler;
import com.ibm.dltj.tagger.impl.DLTTaggerFactory;
import com.ibm.dltj.tagger.interpreter.TokenInterpreter;
import com.ibm.dltj.tagger.interpreter.TokenInterpreterFactory;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.pos_analysis.Method;
import com.ibm.dltj.uima_annotator.pos_analysis.PartOfSpeechAnnotationCreator;
import com.ibm.dltj.util.PooledList;
import com.ibm.langware.annotator.Copyright;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceConfigurationException;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
final class MethodMappingBased
extends Method<String> {
    private final Tagger<String, String> _tagger = DLTTaggerFactory.newInstance().createTagger("MAPPING_BASED");
    private final TokenInterpreter<String> _interpreter;

    MethodMappingBased(UimaContext uimaContext, String string, URL uRL) throws IOException, ResourceConfigurationException {
        super(uimaContext, string, uRL);
        this._tagger.open(uRL);
        this._handler = new RawTagHandler();
        this._interpreter = TokenInterpreterFactory.newInstance().createInterpreter(this._language.getLanguagePart(), this._handler.getType());
        assert (this._tagger != null);
        assert (this._handler != null);
        assert (this._interpreter != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void invoke(CAS cAS, int n, int n2, PooledList<TokenInfo> pooledList, PartOfSpeechAnnotationCreator partOfSpeechAnnotationCreator) throws DLTException {
        try {
            String string = cAS.getDocumentText();
            this._tagger.setText(string.substring(n, n2));
            int n3 = 0;
            for (Object object : pooledList) {
                if (((TokenInfo)((Object)object)).begin < n3) {
                    ((TokenInfo)((Object)object)).skipped = true;
                    continue;
                }
                Object object2 = this.toTag(string, ((TokenInfo)((Object)object)).begin, ((TokenInfo)((Object)object)).end, (TokenInfo)((Object)object), this._tagger.isEmpty());
                this._tagger.setAnnotation(((TokenInfo)((Object)object)).begin - n, ((TokenInfo)((Object)object)).end - n, object2);
                n3 = ((TokenInfo)((Object)object)).end;
            }
            this._tagger.process();
            Iterator iterator = this._tagger.iterator();
            for (Object object2 : pooledList) {
                if (object2.skipped) {
                    this.annotate((TokenInfo)((Object)object2), null, partOfSpeechAnnotationCreator);
                    continue;
                }
                Token token = (Token)iterator.next();
                String string2 = (String)token.getTag();
                if (string2 == null) {
                    string2 = (String)token.getGloss();
                }
                this.annotate((TokenInfo)((Object)object2), string2, partOfSpeechAnnotationCreator);
            }
            assert (!iterator.hasNext());
        }
        finally {
            this._tagger.clear();
        }
    }

    private String toTag(CharSequence charSequence, int n, int n2, TokenInfo tokenInfo, boolean bl) {
        assert (charSequence != null);
        if (tokenInfo.isEmpty()) {
            return (String)this._interpreter.toTag(charSequence, n, n2, tokenInfo.wclass);
        }
        TokenInfo.LemmaEntry lemmaEntry = (TokenInfo.LemmaEntry)tokenInfo.getFirst();
        String string = (String)this._interpreter.toTag(charSequence, n, n2, lemmaEntry.pos, lemmaEntry.extPos, lemmaEntry.morphBitMaskArray, lemmaEntry.morphBitMaskArray.length, bl);
        lemmaEntry.tag = string;
        return string;
    }
}

