/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.util;

import com.ibm.langware.annotator.Copyright;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class PropertiesUtil {
    private final Properties _properties;

    public PropertiesUtil() {
        this(new Properties());
    }

    public PropertiesUtil(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this._properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesUtil(File file) throws IOException {
        this(new Properties());
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            this._properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public PropertiesUtil(InputStream inputStream) throws IOException {
        this(new Properties());
        this._properties.load(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesUtil(Class<?> clazz, String string) throws IOException {
        this(new Properties());
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(clazz.getResourceAsStream(string));
            this._properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public boolean containsKey(String string) {
        String string2 = this._properties.getProperty(string);
        return string2 != null && string2.length() > 0;
    }

    public String getString(String string) {
        return this.getString(string, "");
    }

    public String getString(String string, String string2) {
        String string3 = this._properties.getProperty(string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        return string3;
    }

    public List<String> getStringList(String string) {
        return this.getStringList(string, String.valueOf(','));
    }

    public List<String> getStringList(String string, String string2) {
        List<String> list = Collections.emptyList();
        return this.getStringList(string, string2, list);
    }

    public List<String> getStringList(String string, String string2, List<String> list) {
        String string3 = this._properties.getProperty(string);
        if (string3 == null || string3.length() == 0) {
            return list;
        }
        return Arrays.asList(string3.split(string2));
    }

    public int getInteger(String string) {
        return this.getInteger(string, 0);
    }

    public int getInteger(String string, int n) {
        String string2 = this._properties.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    public long getLong(String string, long l) {
        String string2 = this._properties.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        String string2 = this._properties.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            return f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        String string2 = this._properties.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        this._properties.store(outputStream, string);
    }

    public void println() {
        Object[] objectArray = this._properties.keySet().toArray();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            Object object2 = this._properties.get(object);
            System.out.println(object + "=" + object2);
        }
    }
}

