/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.analyzer;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class PreProcessor {
    public static final String[] SPECIAL_CHARS_UPPER_CASE = new String[]{"\u00b0C", "\u00b0F", "R$"};
    public static final String LIST_OF_CURRENCIES = "\\u0024|\\u20ac|\\u060B|\\u17DB|\\u00A5|\\uFFE5|\\u20A1|\\u20B1|\\u00A2|\\uFFE0|\\uFDFC|\\u20AA|\\u20A9|\\uFFE6|\\u20AD|\\u20AE|\\u20A6|\\u20BD|\\u0E3F|\\u20B4|\\u007D|\\u005D|\\u0029|\\u0028|\\u007B|\\uFF3B|\\u00A3";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String QUESTION_MARK = "?";
    public static final String SLASH = "[/\\\\]";
    protected Locale locale;

    public Locale getLocale() {
        return this.locale;
    }

    public String replaceCamelCaseWithSpace(String text, String camelCaseFormat) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        return text.replaceAll(camelCaseFormat, SPACE);
    }

    public String replaceExtraSpace(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        text = text.replaceAll("(?<=([(<]))(?=.)", SPACE);
        text = text.replaceAll("(?<=.)(?=([)>]))", SPACE);
        text = text.replaceAll("(?<=[\\u0024|\\u20ac|\\u060B|\\u17DB|\\u00A5|\\uFFE5|\\u20A1|\\u20B1|\\u00A2|\\uFFE0|\\uFDFC|\\u20AA|\\u20A9|\\uFFE6|\\u20AD|\\u20AE|\\u20A6|\\u20BD|\\u0E3F|\\u20B4|\\u007D|\\u005D|\\u0029|\\u0028|\\u007B|\\uFF3B|\\u00A3])(?=.)", SPACE);
        text = text.replaceAll("(?<=.)(?=[\\u0024|\\u20ac|\\u060B|\\u17DB|\\u00A5|\\uFFE5|\\u20A1|\\u20B1|\\u00A2|\\uFFE0|\\uFDFC|\\u20AA|\\u20A9|\\uFFE6|\\u20AD|\\u20AE|\\u20A6|\\u20BD|\\u0E3F|\\u20B4|\\u007D|\\u005D|\\u0029|\\u0028|\\u007B|\\uFF3B|\\u00A3])", SPACE);
        text = text.replaceAll("(?<=\\d)\\s+(?=(s(\\s|$)))", "");
        text = text.replaceAll("(?<=.)(?=\u00b0[CF])", SPACE);
        text = text.replaceAll("\\s{2,}", SPACE);
        text = text.replaceAll("(?<=(BZ|R|RD|J|C|NT|TT|Z))\\s+(?=(\\u0024))", "");
        text = text.replaceAll("(?<=\\u0024)\\s+(?=((b|U|M)(\\s|$)))", "");
        text = text.replaceAll("(?<=\\u0024)\\s+(?=(M|B|K)(\\s|$))", "");
        return text;
    }

    public String replaceSlashWithSpace(String text) {
        return text.replaceAll(SLASH, SPACE);
    }

    public String replaceUnderscoreWithSpace(String text) {
        return text.replaceAll(UNDERSCORE, SPACE);
    }

    public String replaceDashWithSpace(String text) {
        return text.replaceAll("(?<!\\+/)-(?!/\\+|[0-9])|(?<=[\\p{L}_])-", SPACE);
    }

    public String[] splitDash(String text) {
        return this.replaceDashWithSpace(text).split(SPACE);
    }

    public boolean shouldSplitDash(String[] phrases) {
        int count = 0;
        for (String str : phrases) {
            if (!str.contains(DASH)) continue;
            ++count;
        }
        return (double)count >= (double)phrases.length / 3.0;
    }

    public String removeExtraSpaceChars(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        return this.replaceExtraSpace(text);
    }

    private boolean containsSpecialChars(String text) {
        if (!StringUtils.isBlank((CharSequence)text)) {
            for (String element : SPECIAL_CHARS_UPPER_CASE) {
                if (text.toUpperCase(this.locale).indexOf(element) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public String toLowerCaseExcludeSpecialCases(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        if (text.length() < 2 || !this.containsSpecialChars(text)) {
            return text.toLowerCase(this.locale);
        }
        text = text.toLowerCase(this.locale);
        int len = text.length();
        for (String spec : SPECIAL_CHARS_UPPER_CASE) {
            int index = text.toUpperCase(this.locale).indexOf(spec);
            while (index >= 0) {
                text = text.substring(0, index) + spec + (spec.length() + index < len ? text.substring(spec.length() + index) : "");
                index = text.toUpperCase(this.locale).indexOf(spec, index + 1);
            }
        }
        return text;
    }

    public String[] splitCamelCase(String text, String camelCaseFormat) {
        return this.replaceCamelCaseWithSpace(text, camelCaseFormat).split(SPACE);
    }

    public String[] splitUnderscore(String text, String camelCaseFormat) {
        return this.replaceCamelCaseWithSpace(text, camelCaseFormat).split(SPACE);
    }

    public String splitText(String text, String camelCaseFormat) {
        String textSplit = this.replaceCamelCaseWithSpace(text, camelCaseFormat);
        textSplit = this.replaceUnderscoreWithSpace(textSplit);
        return this.replaceDashWithSpace(textSplit);
    }

    protected String[] processPhrases(String[] phrases, String format) {
        List<String> list = Arrays.asList(phrases).stream().map(p -> this.replaceCamelCaseWithSpace((String)p, format)).map(p -> this.replaceDashWithSpace((String)p)).map(p -> this.replaceSlashWithSpace((String)p)).map(p -> this.replaceUnderscoreWithSpace((String)p)).map(p -> this.removeExtraSpaceChars((String)p)).collect(Collectors.toList());
        return list.toArray(new String[0]);
    }

    protected String[] preProcessPhrases(String[] phrases, String format) {
        List<String> list = Arrays.asList(phrases).stream().map(p -> this.replaceCamelCaseWithSpace((String)p, format)).map(p -> this.replaceDashWithSpace((String)p)).map(p -> this.replaceSlashWithSpace((String)p)).map(p -> this.replaceUnderscoreWithSpace((String)p)).collect(Collectors.toList());
        return list.toArray(new String[0]);
    }

    public abstract String[] preProcessPhrases(String[] var1);

    public abstract String[] processPhrases(String[] var1);
}

