/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.combinations.generator.util;

import com.ibm.smarts.combinations.generator.util.ElementSpec;
import com.ibm.smarts.combinations.generator.util.api.ICombinationSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CombinationSpec
implements ICombinationSpec {
    private List<ElementSpec> elements;

    public CombinationSpec(List<ElementSpec> list) {
        this.elements = new ArrayList<ElementSpec>(list);
    }

    public CombinationSpec() {
        this.elements = new ArrayList<ElementSpec>();
    }

    @Override
    public List<ElementSpec> getElements() {
        return this.elements;
    }

    @Override
    public void addElement(ElementSpec element) {
        if (element.getNumberOfColumns() != 0) {
            this.elements.add(element);
        }
    }

    @Override
    public boolean contains(ElementSpec element) {
        return this.elements.contains(element);
    }

    public String toString() {
        return this.elements.toString();
    }

    public boolean equals(Object spec) {
        if (!(spec instanceof CombinationSpec)) {
            return false;
        }
        CombinationSpec temp = (CombinationSpec)spec;
        if (temp.elements.size() != this.elements.size()) {
            return false;
        }
        for (ElementSpec element : temp.elements) {
            if (!this.elements.contains(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getConcepts() {
        ArrayList<String> concepts = new ArrayList<String>();
        for (ElementSpec element : this.elements) {
            concepts.add(element.getConcept());
        }
        return concepts;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.elements});
    }
}

