/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.fields.recommender.core.influencers;

import com.ibm.smarts.fields.recommender.core.AbstractAnalysisStep;
import com.ibm.smarts.fields.recommender.core.influencers.InfluencersAnalysisContext;
import com.ibm.smarts.ontology.util.Pair;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BivariateStatistics;
import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.ConceptInfo;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluencersCandidateCollection
extends AbstractAnalysisStep<InfluencersAnalysisContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluencersCandidateCollection.class);
    private static final List<String> IGNOREALBE_ATTRIBUTES = Arrays.asList("http://www.ibm.com/ontologies/waca/domain/common#Description", "http://www.ibm.com/ontologies/waca/domain/common#RowIdentifier");

    @Override
    public void execute(@Nonnull InfluencersAnalysisContext rfac) {
        Instant start = Instant.now();
        this.collectRelatedFieldsCandidates(rfac);
        LOGGER.info("collectRelatedFieldsCandidates takes [{}] ms", (Object)Duration.between(start, Instant.now()).toMillis());
        Instant startAttr = Instant.now();
        this.collectAttributes(rfac);
        LOGGER.info("collectAttributes takes [{}] ms", (Object)Duration.between(startAttr, Instant.now()).toMillis());
        LOGGER.info("Total elasped time for InfluencersCandidateCollection is [{}] ms", (Object)Duration.between(start, Instant.now()).toMillis());
    }

    private void collectRelatedFieldsCandidates(InfluencersAnalysisContext rfac) {
        Map<String, Map.Entry<String, Float>> flattenChildren = rfac.getFlattenInfluencerConceptChildren();
        this.getJoinableDatasets(rfac).forEach(ds -> {
            Map<Pair<String, String>, BivariateStatistics> bvMap = this.getBVMapAndStoreIfAbsent(rfac, (DatasetInfo)ds);
            SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream().filter(col -> rfac.isInScope(ds.getId(), this.toFieldUID(col.getId(), ds.getId()), (ColumnInfo)col)).forEach(col -> {
                Set<Map.Entry<String, Float>> matches = this.getMatchingConcepts(col.getSemanticInfo().getConcepts(), flattenChildren);
                boolean cor = !matches.isEmpty() && this.isOKCorrelated((ColumnInfo)col, rfac, (DatasetInfo)ds, bvMap);
                matches.forEach(entry -> {
                    if (cor) {
                        rfac.addInfluentialCandidate((ColumnInfo)col, (Map.Entry<String, Float>)entry, this.toFieldUID(col.getId(), ds.getId()), ds.getId());
                        LOGGER.info("Added influential column [{}] in dataset [{}] to target [{}]", new Object[]{col.getId(), ds.getId(), rfac.getTargetFieldID()});
                    }
                });
            });
        });
    }

    private Set<Map.Entry<String, Float>> getMatchingConcepts(List<ConceptInfo> concepts, Map<String, Map.Entry<String, Float>> flattenChildren) {
        HashSet<Map.Entry<String, Float>> matching = new HashSet<Map.Entry<String, Float>>(concepts.size());
        for (ConceptInfo concept : concepts) {
            Map.Entry<String, Float> matched = flattenChildren.get(concept.getConceptID());
            if (matched == null) continue;
            matching.add(matched);
        }
        return matching;
    }

    private boolean isOKCorrelated(ColumnInfo col, InfluencersAnalysisContext rfac, DatasetInfo ds, Map<Pair<String, String>, BivariateStatistics> bvMap) {
        if (rfac.getTargetFieldTableID().equals(ds.getId()) && bvMap != null && !bvMap.isEmpty()) {
            BivariateStatistics bvValue = bvMap.get(new Pair((Object)rfac.getTargetFieldID(), (Object)col.getId()));
            if (bvValue == null) {
                bvValue = bvMap.get(new Pair((Object)col.getId(), (Object)rfac.getTargetFieldID()));
            }
            return this.valueInRange(bvValue, rfac, CORR_MEASURE) || this.isMeasureCalculation(rfac.getTargetField());
        }
        LOGGER.info("Add candidates from joined table [{}]", (Object)ds.getId());
        return true;
    }

    private void collectAttributes(InfluencersAnalysisContext rfac) {
        this.getJoinableDatasets(rfac).forEach(ds -> {
            Map<Pair<String, String>, BivariateStatistics> bvMap = this.getBVMapAndStoreIfAbsent(rfac, (DatasetInfo)ds);
            ds.getLogicalGroups().stream().filter(g -> Optional.ofNullable(rfac.getInfluencerConceptMap().get(g.getConcept().getConceptID())).isPresent()).forEach(g -> {
                String conceptID = g.getConcept().getConceptID();
                Float score = rfac.getInfluencerConceptMap().get(conceptID);
                g.getMember().stream().filter(m -> !IGNOREALBE_ATTRIBUTES.contains(m.getAttribute().getConceptID())).forEach(m -> {
                    ColumnInfo col = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream().filter(c -> m.getColumnId().equals(c.getId())).filter(c -> rfac.isInScope(ds.getId(), this.toFieldUID(c.getId(), ds.getId()), (ColumnInfo)c)).findFirst().orElse(null);
                    if (col != null && this.isOKCorrelated(col, rfac, (DatasetInfo)ds, bvMap)) {
                        rfac.addInfluentialCandidate(col, conceptID, score.floatValue(), this.toFieldUID(col.getId(), ds.getId()), ds.getId());
                        LOGGER.info("Added influential column [{}] from attribute in dataset [{}] for target [{}]", new Object[]{col.getId(), ds.getId(), rfac.getTargetFieldID()});
                    }
                });
            });
        });
    }
}

