/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.common.core;

import com.ibm.smarts.similarity.classifier.common.core.VectorUtility;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormedVector {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormedVector.class);
    private float[] vector;
    private double norm;

    public NormedVector(float[] vector) {
        this.vector = vector;
        this.norm = VectorUtility.norm(vector);
    }

    public NormedVector(float[] vector, boolean computeNorm) {
        this.vector = vector;
        this.norm = computeNorm ? this.computeNorm() : -1.0;
    }

    public NormedVector(float[] vector, double norm) {
        this.vector = vector;
        this.norm = norm;
    }

    public float[] getVector() {
        return this.vector;
    }

    public double getNorm() {
        if (this.norm < 0.0) {
            this.norm = this.computeNorm();
        }
        return this.norm;
    }

    public NormedVector add(NormedVector v) {
        if (this.vector.length != v.getVector().length) {
            LOGGER.error("Vector lengths not same while performing sum.");
            throw new IllegalArgumentException("Vector lengths not same while performing sum.");
        }
        IntStream.range(0, this.vector.length).forEach(i -> {
            this.vector[i] = this.vector[i] + v.getVector()[i];
        });
        this.norm = -1.0;
        return this;
    }

    public NormedVector multiply(float a) {
        IntStream.range(0, this.vector.length).forEach(i -> {
            this.vector[i] = a * this.vector[i];
        });
        this.norm = -1.0;
        return this;
    }

    private double computeNorm() {
        return VectorUtility.norm(this.vector);
    }
}

