/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import simplenlg.server.SimpleServer;
import simplenlg.xmlrealiser.XMLRealiser;
import simplenlg.xmlrealiser.XMLRealiserException;
import simplenlg.xmlrealiser.wrapper.RequestType;

public class RealisationRequest
implements Runnable {
    Socket socket;
    static boolean DEBUG = SimpleServer.DEBUG;

    public RealisationRequest(Socket s) {
        this.socket = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (null == this.socket) {
            return;
        }
        DataInputStream input = null;
        DataOutputStream output = null;
        if (DEBUG) {
            System.out.println("Client connected from " + this.socket.getRemoteSocketAddress());
        }
        try {
            input = new DataInputStream(this.socket.getInputStream());
            output = new DataOutputStream(this.socket.getOutputStream());
            int msgLen = input.readInt();
            byte[] data = new byte[msgLen];
            input.readFully(data);
            if (data.length < 1) {
                throw new Exception("Client did not send data.");
            }
            String tmp = new String(data, "UTF-8");
            StringReader reader = new StringReader(tmp);
            String result = this.doRealisation(reader).trim();
            byte[] tmp2 = result.getBytes("UTF-8");
            output.writeInt(tmp2.length);
            output.write(tmp2);
            if (DEBUG) {
                String text = "The following realisation was sent to client:";
                System.out.println(text + "\n\t" + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                byte[] tmp = ("Exception: " + e.getMessage()).getBytes("UTF-8");
                output.writeInt(tmp.length);
                output.write(tmp);
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        catch (XMLRealiserException e) {
            e.printStackTrace();
            try {
                byte[] tmp = ("Exception: " + e.getMessage()).getBytes("UTF-8");
                output.writeInt(tmp.length);
                output.write(tmp);
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        finally {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                System.err.println("Could not close client socket!");
            }
        }
    }

    protected String doRealisation(Reader inputReader) throws XMLRealiserException {
        RequestType request = XMLRealiser.getRequest(inputReader);
        String output = XMLRealiser.realise(request.getDocument());
        return output;
    }
}

