/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.async;

import com.ibm.smarts.core.util.AbstractMetrics;
import com.ibm.smarts.core.util.Timer;

public final class AsyncMetrics
extends AbstractMetrics<AsyncMetrics> {
    public final AsyncMetrics parent;
    public final Timer.DurationTally queued;
    public final Timer.DurationTally working;
    public final Timer.DurationTally callbacks;
    public final Timer.DurationTally blocked;

    public AsyncMetrics() {
        this(null);
    }

    public AsyncMetrics(AsyncMetrics parent) {
        this(parent, null, null, null, null);
    }

    private AsyncMetrics(AsyncMetrics parent, Timer.DurationTally queued, Timer.DurationTally working, Timer.DurationTally callbacks, Timer.DurationTally blocked) {
        this.parent = parent;
        Timer.DurationTally durationTally = queued != null ? queued : (this.queued = new Timer.DurationTally(parent != null ? parent.queued : null));
        Timer.DurationTally durationTally2 = working != null ? working : (this.working = new Timer.DurationTally(parent != null ? parent.working : null));
        Timer.DurationTally durationTally3 = callbacks != null ? callbacks : (this.callbacks = new Timer.DurationTally(parent != null ? parent.callbacks : null));
        this.blocked = blocked != null ? blocked : new Timer.DurationTally(parent != null ? parent.blocked : null);
    }

    @Override
    public boolean isTouched() {
        return AsyncMetrics.isTouched((AbstractMetrics[])new Timer.DurationTally[]{this.queued, this.working, this.callbacks, this.blocked});
    }

    @Override
    public long firstTouchNanos() {
        return AsyncMetrics.minNonZero(this.queued.firstTouchNanos(), this.working.firstTouchNanos(), this.callbacks.firstTouchNanos(), this.blocked.firstTouchNanos());
    }

    @Override
    public long lastTouchNanos() {
        return AsyncMetrics.max(this.queued.lastTouchNanos(), this.working.lastTouchNanos(), this.callbacks.lastTouchNanos(), this.blocked.lastTouchNanos());
    }

    public AsyncMetrics combine(AsyncMetrics other) {
        AsyncMetrics newParent = null;
        if (this.parent != null || other.parent != null) {
            AsyncMetrics thisParent = this.parent != null ? this.parent : new AsyncMetrics();
            AsyncMetrics otherParent = other.parent != null ? other.parent : new AsyncMetrics();
            newParent = thisParent.combine(otherParent);
        }
        return this.combine(newParent, other);
    }

    public AsyncMetrics combine(AsyncMetrics newParent, AsyncMetrics other) {
        return new AsyncMetrics(newParent, this.queued.combine(newParent != null ? newParent.queued : null, other.queued), this.working.combine(newParent != null ? newParent.working : null, other.working), this.callbacks.combine(newParent != null ? newParent.callbacks : null, other.callbacks), this.blocked.combine(newParent != null ? newParent.blocked : null, other.blocked));
    }

    public Timer.Stopwatch working() {
        return new Timer.Stopwatch(this.working);
    }

    public Timer.Stopwatch blocked() {
        return new Timer.Stopwatch(this.blocked);
    }

    public Timer.Stopwatch callback() {
        return new Timer.Stopwatch(this.callbacks);
    }

    @Override
    public String toString(boolean pretty, int indent) {
        double[] percentages;
        String prefix;
        StringBuilder sb = new StringBuilder();
        sb.append("[AsyncMetrics");
        int touchedCount = AsyncMetrics.countTouched((AbstractMetrics[])new Timer.DurationTally[]{this.queued, this.working, this.callbacks, this.blocked});
        String string = prefix = touchedCount == 1 ? " " : AsyncMetrics.linePrefix(pretty, indent);
        if (this.queued.isTouched()) {
            sb.append(prefix + "queued=" + this.queued.toString(pretty, indent + 1));
        }
        if (this.working.isTouched()) {
            sb.append(prefix + "working=" + this.working.toString(pretty, indent + 1));
        }
        if (this.callbacks.isTouched()) {
            sb.append(prefix + "callbacks=" + this.callbacks.toString(pretty, indent + 1));
        }
        if (this.blocked.isTouched()) {
            sb.append(prefix + "blocked=" + this.blocked.toString(pretty, indent + 1));
        }
        if (AsyncMetrics.countValues(percentages = AsyncMetrics.getPercents(this.queued.getTotalNanos(), this.working.getTotalNanos(), this.callbacks.getTotalNanos(), this.blocked.getTotalNanos())) > 1) {
            sb.append(AsyncMetrics.linePrefix(pretty, indent) + "percentages=[");
            AsyncMetrics.maybePrint(sb, "queued", percentages[0]);
            AsyncMetrics.maybePrint(sb, "working", percentages[1]);
            AsyncMetrics.maybePrint(sb, "callbacks", percentages[2]);
            AsyncMetrics.maybePrint(sb, "blocked", percentages[3]);
            sb.append("]");
        }
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    private static void maybePrint(StringBuilder sb, String name, double value) {
        if (value > 0.0) {
            sb.append(name);
            sb.append("=");
            sb.append(AsyncMetrics.format(value));
            sb.append(" ");
        }
    }

    private static int countValues(double ... ds) {
        int ret = 0;
        for (double d : ds) {
            if (!(d > 0.0)) continue;
            ++ret;
        }
        return ret;
    }

    public static String format(double d) {
        String ret = String.format("%3.2f", d);
        return ret;
    }

    public double[] getPercents() {
        return AsyncMetrics.getPercents(this.queued.getTotalNanos(), this.working.getTotalNanos(), this.blocked.getTotalNanos());
    }

    public static double[] getPercents(long ... values) {
        double[] ret = new double[values.length];
        double total = AsyncMetrics.sum(values);
        for (int i = 0; i < values.length; ++i) {
            double p;
            if (total == 0.0) {
                ret[i] = 0.0;
                continue;
            }
            long v = values[i];
            ret[i] = p = (double)(v * 100L) / total;
        }
        return ret;
    }

    public static long sum(long ... values) {
        long ret = 0L;
        for (long v : values) {
            ret += v;
        }
        return ret;
    }
}

